/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.asn.x509;

import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BitString;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.BaseASNWrapper;
import tr.gov.tubitak.uekae.esya.api.asn.Constants;
import tr.gov.tubitak.uekae.esya.api.asn.pqixqualified.EQCStatements;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAuthorityInfoAccessSyntax;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EBasicConstraints;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRLDistributionPoint;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRLDistributionPoints;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificatePolicies;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtendedKeyUsage;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtension;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EGeneralName;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EKeyUsage;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EName;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectAltName;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ETBSCertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.util.OIDUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.asn.esya._esyaValues;
import tr.gov.tubitak.uekae.esya.asn.etsiqc._etsiqcValues;
import tr.gov.tubitak.uekae.esya.asn.util.AsnIO;
import tr.gov.tubitak.uekae.esya.asn.util.UtilEsitlikler;
import tr.gov.tubitak.uekae.esya.asn.util.UtilName;
import tr.gov.tubitak.uekae.esya.asn.util.UtilTime;
import tr.gov.tubitak.uekae.esya.asn.x509.AccessDescription;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.AuthorityInfoAccessSyntax;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;
import tr.gov.tubitak.uekae.esya.asn.x509.ORAddress;
import tr.gov.tubitak.uekae.esya.asn.x509.TBSCertificate;
import tr.gov.tubitak.uekae.esya.asn.x509.Version;

public class ECertificate
extends BaseASNWrapper<Certificate> {
    private static final Logger a;
    private static Asn1ObjectIdentifier c;
    private static Asn1ObjectIdentifier d;
    private static Asn1ObjectIdentifier e;
    private static Asn1ObjectIdentifier f;
    private static final String[] g;

    public ECertificate(Certificate aObject) {
        super(aObject);
    }

    public ECertificate(File aFile) throws ESYAException, IOException {
        this(new FileInputStream(aFile));
    }

    public ECertificate(byte[] aBytes) throws ESYAException {
        super(aBytes, new Certificate());
    }

    public ECertificate(String aBase64Encoded) throws ESYAException {
        super(aBase64Encoded, new Certificate());
    }

    public ECertificate(InputStream aCertStream) throws ESYAException {
        super(null);
        try {
            byte[] byArray = AsnIO.streamOku(aCertStream);
            this.mObject = new Certificate();
            this.mObject = (Certificate)AsnIO.arraydenOku(this.mObject, byArray);
        }
        catch (Exception exception) {
            throw new ESYAException((Throwable)exception);
        }
    }

    public ECertificate(ETBSCertificate tbsCertificate, EAlgorithmIdentifier algorithmIdentifier, byte[] signature) {
        super(new Certificate());
        this.setTBSCertificate(tbsCertificate);
        this.setSignatureAlgorithm(algorithmIdentifier);
        this.setSignatureValue(signature);
    }

    public ETBSCertificate getTBSCertificate() {
        return new ETBSCertificate(((Certificate)this.mObject).tbsCertificate);
    }

    public void setTBSCertificate(ETBSCertificate aTBSCertificate) {
        block5: {
            block4: {
                if (aTBSCertificate != null) break block4;
                ((Certificate)this.mObject).tbsCertificate = null;
                if (!EExtension.c) break block5;
            }
            ((Certificate)this.mObject).tbsCertificate = (TBSCertificate)((Object)aTBSCertificate.getObject());
        }
    }

    public ESubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return new ESubjectPublicKeyInfo(((Certificate)this.mObject).tbsCertificate.subjectPublicKeyInfo);
    }

    public BigInteger getSerialNumber() {
        return ((Certificate)this.mObject).tbsCertificate.serialNumber.value;
    }

    public String getSerialNumberHex() {
        return StringUtil.toHexString((byte[])this.getSerialNumber().toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionStr() {
        Version version = ((Certificate)this.mObject).tbsCertificate.version;
        if (version == null) {
            return "";
        }
        switch ((int)version.value) {
            case 0: {
                return g[3];
            }
            case 1: {
                return g[4];
            }
            case 2: {
                return g[5];
            }
        }
        return null;
    }

    public long getVersion() {
        Version version = ((Certificate)this.mObject).tbsCertificate.version;
        if (version == null) {
            return -1L;
        }
        return version.value;
    }

    public byte[] getSignatureValue() {
        return ((Certificate)this.mObject).signature.value;
    }

    public void setSignatureValue(byte[] aSignatureValue) {
        ((Certificate)this.mObject).signature = new Asn1BitString(aSignatureValue.length << 3, aSignatureValue);
    }

    public Calendar getNotBefore() {
        return UtilTime.timeToCalendar(((Certificate)this.mObject).tbsCertificate.validity.notBefore);
    }

    public Calendar getNotAfter() {
        return UtilTime.timeToCalendar(((Certificate)this.mObject).tbsCertificate.validity.notAfter);
    }

    public EAlgorithmIdentifier getPublicKeyAlgorithm() {
        return this.getSubjectPublicKeyInfo().getAlgorithm();
    }

    public EAlgorithmIdentifier getSignatureAlgorithm() {
        return new EAlgorithmIdentifier(((Certificate)this.mObject).signatureAlgorithm);
    }

    public void setSignatureAlgorithm(EAlgorithmIdentifier aAlgorithm) {
        block5: {
            block4: {
                if (aAlgorithm != null) break block4;
                ((Certificate)this.mObject).signatureAlgorithm = null;
                if (!EExtension.c) break block5;
            }
            ((Certificate)this.mObject).signatureAlgorithm = (AlgorithmIdentifier)((Object)aAlgorithm.getObject());
        }
    }

    public byte[] getTBSEncodedBytes() {
        byte[] byArray = null;
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            ((Certificate)this.mObject).tbsCertificate.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            byArray = asn1DerEncodeBuffer.getMsgCopy();
            asn1DerEncodeBuffer.reset();
        }
        catch (Asn1Exception asn1Exception) {
            a.error(g[2], (Throwable)asn1Exception);
        }
        return byArray;
    }

    public EName getSubject() {
        return new EName(((Certificate)this.mObject).tbsCertificate.subject);
    }

    public EName getIssuer() {
        return new EName(((Certificate)this.mObject).tbsCertificate.issuer);
    }

    public String getEmail() {
        boolean bl = EExtension.c;
        ESubjectAltName eSubjectAltName = this.getExtensions().getSubjectAltName();
        if (eSubjectAltName != null) {
            for (int i = 0; i < eSubjectAltName.getElementCount(); ++i) {
                EGeneralName eGeneralName = eSubjectAltName.getElement(i);
                if (eGeneralName.getType() != 2) continue;
                return eGeneralName.getRfc822Name();
            }
        }
        return null;
    }

    public ORAddress getX400Name() {
        boolean bl = EExtension.c;
        ESubjectAltName eSubjectAltName = this.getExtensions().getSubjectAltName();
        if (eSubjectAltName != null) {
            for (int i = 0; i < eSubjectAltName.getElementCount(); ++i) {
                EGeneralName eGeneralName = eSubjectAltName.getElement(i);
                if (eGeneralName.getX400Address() == null) continue;
                return eGeneralName.getX400Address();
            }
        }
        return null;
    }

    public EExtensions getExtensions() {
        return new EExtensions(((Certificate)this.mObject).tbsCertificate.extensions, this);
    }

    public boolean isSelfIssued() {
        return UtilEsitlikler.esitMi((Asn1Type)((Certificate)this.mObject).tbsCertificate.issuer, (Asn1Type)((Certificate)this.mObject).tbsCertificate.subject);
    }

    public boolean isQualifiedCertificate() {
        block6: {
            block7: {
                EQCStatements eQCStatements = this.getExtensions().getQCStatements();
                if (eQCStatements == null) break block6;
                if (eQCStatements.checkStatement(new Asn1ObjectIdentifier(_etsiqcValues.id_etsi_qcs_QcCompliance))) break block7;
                if (!eQCStatements.checkStatement(new Asn1ObjectIdentifier(_esyaValues.id_TK_nesoid))) break block6;
            }
            return true;
        }
        return false;
    }

    public boolean isMaliMuhurCertificate() {
        if (this.a(d)) {
            boolean bl;
            block6: {
                block5: {
                    EExtendedKeyUsage eExtendedKeyUsage = this.getExtensions().getExtendedKeyUsage();
                    if (eExtendedKeyUsage == null || !eExtendedKeyUsage.hasElement(c)) break block5;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public boolean isKurumsalMuhurCertificate() {
        return this.a(e);
    }

    public boolean isEncryptionCertificate() {
        block6: {
            block7: {
                EKeyUsage eKeyUsage = this.getExtensions().getKeyUsage();
                if (eKeyUsage == null) break block6;
                if (eKeyUsage.isKeyEncipherment()) break block7;
                if (!eKeyUsage.isDataEncipherment()) break block6;
            }
            return true;
        }
        return false;
    }

    public boolean isOCSPSigningCertificate() {
        boolean bl;
        block5: {
            block4: {
                EExtendedKeyUsage eExtendedKeyUsage = this.getExtensions().getExtendedKeyUsage();
                if (eExtendedKeyUsage == null || !eExtendedKeyUsage.hasElement(Constants.IMP_ID_KP_OCSPSIGNING)) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public boolean isTimeStampingCertificate() {
        boolean bl;
        block5: {
            block4: {
                EExtendedKeyUsage eExtendedKeyUsage = this.getExtensions().getExtendedKeyUsage();
                if (eExtendedKeyUsage == null || !eExtendedKeyUsage.hasElement(Constants.IMP_ID_KP_TIMESTAMPING)) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public boolean isCACertificate() {
        boolean bl;
        block5: {
            block4: {
                EBasicConstraints eBasicConstraints = this.getExtensions().getBasicConstraints();
                if (eBasicConstraints == null || !eBasicConstraints.isCA()) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public List<String> getOCSPAdresses() {
        AccessDescription[] accessDescriptionArray;
        block8: {
            boolean bl = EExtension.c;
            EAuthorityInfoAccessSyntax eAuthorityInfoAccessSyntax = this.getExtensions().getAuthorityInfoAccessSyntax();
            accessDescriptionArray = null;
            if (eAuthorityInfoAccessSyntax == null || eAuthorityInfoAccessSyntax.getObject() == null) break block8;
            accessDescriptionArray = ((AuthorityInfoAccessSyntax)((Object)eAuthorityInfoAccessSyntax.getObject())).elements;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (accessDescriptionArray == null) {
            return arrayList;
        }
        for (AccessDescription accessDescription : accessDescriptionArray) {
            if (!accessDescription.accessMethod.equals((Asn1Type)Constants.EXP_ID_AD_OCSP)) continue;
            arrayList.add(UtilName.generalName2String(accessDescription.accessLocation));
        }
        return arrayList;
    }

    public EName getCRLIssuer() {
        boolean bl = EExtension.c;
        ECRLDistributionPoints eCRLDistributionPoints = this.getExtensions().getCRLDistributionPoints();
        if (eCRLDistributionPoints != null) {
            for (int i = 0; i < eCRLDistributionPoints.getCRLDistributionPointCount(); ++i) {
                ECRLDistributionPoint eCRLDistributionPoint = eCRLDistributionPoints.getCRLDistributionPoint(i);
                EName eName = eCRLDistributionPoint.getCRLIssuer();
                if (eName == null) continue;
                return eName;
            }
        }
        return this.getIssuer();
    }

    public byte[] getSCTValue() {
        return this.getExtensions().getExtension(f).getValue();
    }

    public boolean hasIndirectCRL() {
        boolean bl = !this.getCRLIssuer().equals(this.getIssuer());
        return bl;
    }

    public X509Certificate asX509Certificate() {
        try {
            return (X509Certificate)CertificateFactory.getInstance(g[0]).generateCertificate(new ByteArrayInputStream(this.getEncoded()));
        }
        catch (Exception exception) {
            throw new ESYARuntimeException(g[1] + this, (Throwable)exception);
        }
    }

    @Override
    public int hashCode() {
        return this.getIssuer().stringValue().hashCode() & this.getSerialNumber().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        String string;
        block4: {
            boolean bl;
            block6: {
                block5: {
                    boolean bl2 = EExtension.c;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(g[14]).append(g[9]).append(this.getSubject().stringValue()).append('\n').append(g[10]).append(this.getIssuer().stringValue()).append('\n').append(g[13]).append(this.getSerialNumberHex()).append('\n').append(g[8]).append(this.getNotBefore().getTime()).append(g[11]).append(this.getNotAfter().getTime()).append('\n').append(g[6]).append(this.isCACertificate()).append(g[7]).append(this.isSelfIssued()).append('\n').append(g[12]);
                    string = stringBuilder.toString();
                    if (BaseASNWrapper.b == 0) break block4;
                    if (!bl2) break block5;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            EExtension.c = bl;
        }
        return string;
    }

    public static ECertificate readFromFile(String aPath) throws IOException, Asn1Exception, ESYAException {
        Certificate certificate = new Certificate();
        certificate = (Certificate)AsnIO.dosyadanOKU(certificate, aPath);
        return new ECertificate(certificate);
    }

    private boolean a(Asn1ObjectIdentifier asn1ObjectIdentifier) {
        boolean bl = EExtension.c;
        ECertificatePolicies eCertificatePolicies = this.getExtensions().getCertificatePolicies();
        if (eCertificatePolicies != null) {
            for (int i = 0; i < eCertificatePolicies.getPolicyInformationCount(); ++i) {
                if (!eCertificatePolicies.getPolicyInformation((int)i).policyIdentifier.equals((Asn1Type)asn1ObjectIdentifier)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[19];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "'\u0014\u001d~Y";
        int n2 = -1;
        block26: while (true) {
            char[] cArray;
            block31: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block30: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block30;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block31;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 127;
                                break;
                            }
                            case 1: {
                                n8 = 58;
                                break;
                            }
                            case 2: {
                                n8 = 40;
                                break;
                            }
                            case 3: {
                                n8 = 78;
                                break;
                            }
                            default: {
                                n8 = 96;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = ":HZ!\u0012_YG \u0016\u001aH\\'\u000e\u0018\u001a\\!@'\u000f\u0018w@<_Z:\t\u0019SK/\u0014\u001a\u001a";
                    n2 = 0;
                    continue block26;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = ",_Z:\t\u0019SC/@\u001b_\u0137+\u0012\u0016\u001aI\"\u0151\u0011\u010bZ%\u0005\u0011\u001a@/\u0014\u001e\u001aG\"\u0015\u0120N]`";
                    n2 = 1;
                    continue block26;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\t\u000b";
                    n2 = 2;
                    continue block26;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\t\b";
                    n2 = 3;
                    continue block26;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\t\t";
                    n2 = 4;
                    continue block26;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "<[\u0012n";
                    n2 = 5;
                    continue block26;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "S\u001a[+\f\u0019\u0017A=\u0013\n_Lt";
                    n2 = 6;
                    continue block26;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = ")[D'\u0004_\\Z!\r_";
                    n2 = 7;
                    continue block26;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = ",OJ$\u0005\u001cN\u0012n";
                    n2 = 8;
                    continue block26;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "6I[;\u0005\r\u0000\b";
                    n2 = 9;
                    continue block26;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "_NGn";
                    n2 = 10;
                    continue block26;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "R\u0017\u0005cMR\u0017\u0005cMR\u0017\u0005cMR\u0017\u0005cMR\u0017\"";
                    n2 = 11;
                    continue block26;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = ",_Z'\u0001\u0013\u0000\b";
                    n2 = 12;
                    continue block26;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "u\u0017\u0005cMR\u001ak+\u0012\u000bSN'\u0003\u001eNMnMR\u0017\u0005cj";
                    n2 = 13;
                    continue block26;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "M\u0014\u0019xNH\u0003\u001a`QQ\b\u0006\u007fNN\u0014\u001d`WQ\u000e\u0006\u007f";
                    n2 = 14;
                    continue block26;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "N\u0014\u001b`VQ\u000b\u0006zNN\u0014\u0019\u007fQM\u0003\u0006|NK\u0014\u001a";
                    n2 = 15;
                    continue block26;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "M\u0014\u0019xNH\u0003\u001a`QQ\b\u0006\u007fNN\u0014\u001d`WQ\u000f\u0018`Q";
                    n2 = 16;
                    continue block26;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "M\u0014\u0019xNH\u0003\u001a`QQ\b\u0006\u007fNN\u0014\u001d`WQ\u000b\u0006\u007fP";
                    n2 = 17;
                    continue block26;
                }
                case 17: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        g = stringArray3;
        a = LoggerFactory.getLogger(ECertificate.class);
        c = new Asn1ObjectIdentifier(OIDUtil.parse((String)g[17]));
        d = new Asn1ObjectIdentifier(OIDUtil.parse((String)g[15]));
        e = new Asn1ObjectIdentifier(OIDUtil.parse((String)g[18]));
        f = new Asn1ObjectIdentifier(OIDUtil.parse((String)g[16]));
    }
}

