/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.validator;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EName;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.QualifyingProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.UnsignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.XAdESBaseElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.policy.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.RevocationValuesType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.BaseTimeStampValidator;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.Validator;

public class TurkishESigProfileValidator
implements Validator {
    protected static Logger logger;
    private static final String[] a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidationResult validate(XMLSignature aSignature, ECertificate aCertificate) throws XMLSignatureException {
        int n = BaseTimeStampValidator.b;
        QualifyingProperties qualifyingProperties = aSignature.createOrGetQualifyingProperties();
        UnsignedSignatureProperties unsignedSignatureProperties = qualifyingProperties.getUnsignedSignatureProperties();
        try {
            List<EOCSPResponse> list;
            XAdESBaseElement xAdESBaseElement;
            TurkishESigProfile turkishESigProfile = aSignature.getContext().getConfig().getValidationConfig().getValidationProfile();
            if (turkishESigProfile == null && (xAdESBaseElement = qualifyingProperties.getSignedSignatureProperties().getSignaturePolicyIdentifier()) != null) {
                turkishESigProfile = ((SignaturePolicyIdentifier)xAdESBaseElement).getTurkishESigProfile();
            }
            if (turkishESigProfile == null) {
                return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[3], new Object[0]), I18n.translate(a[5], new Object[0]), null, this.getClass());
            }
            xAdESBaseElement = null;
            SignatureType signatureType = aSignature.getSignatureType();
            if (turkishESigProfile == TurkishESigProfile.P4_1 || turkishESigProfile == TurkishESigProfile.P3_1) {
                try {
                    xAdESBaseElement = unsignedSignatureProperties.getRevocationValues();
                }
                catch (Exception exception) {
                    logger.warn(a[12], (Throwable)exception);
                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[13], new Object[0]), I18n.translate(a[8], new Object[0]), null, this.getClass());
                }
            }
            if (turkishESigProfile.equals((Object)TurkishESigProfile.P4_1)) {
                if (signatureType != SignatureType.XAdES_X_L && signatureType != SignatureType.XAdES_A) {
                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[0], new Object[0]), I18n.translate(a[14], new Object[0]), null, this.getClass());
                }
                boolean bl = false;
                EName eName = aSignature.getKeyInfo().resolveCertificate().getIssuer();
                list = ((RevocationValuesType)xAdESBaseElement).getAllOCSPResponses();
                for (EOCSPResponse eOCSPResponse : list) {
                    for (int i = 0; i < eOCSPResponse.getBasicOCSPResponse().getCertificateCount(); ++i) {
                        if (!eOCSPResponse.getBasicOCSPResponse().getCertificate(i).getIssuer().equals((Object)eName)) continue;
                        bl = true;
                        if (n == 0) break;
                        if (n == 0) continue;
                    }
                    if ((!bl || n != 0) && n == 0) continue;
                }
                if (!bl) {
                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[9], new Object[0]), I18n.translate(a[10], new Object[0]), null, this.getClass());
                }
                if (n == 0) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            }
            if (turkishESigProfile.equals((Object)TurkishESigProfile.P3_1)) {
                if (signatureType != SignatureType.XAdES_X_L && signatureType != SignatureType.XAdES_A) {
                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[11], new Object[0]), I18n.translate(a[7], new Object[0]), null, this.getClass());
                }
                boolean bl = false;
                EName eName = aSignature.getKeyInfo().resolveCertificate().getIssuer();
                list = ((RevocationValuesType)xAdESBaseElement).getAllCRLs();
                for (EOCSPResponse eOCSPResponse : list) {
                    if (eOCSPResponse.getIssuer().equals((Object)eName)) {
                        bl = true;
                        if (n == 0) break;
                    }
                    if (n == 0) continue;
                }
                if (!bl) {
                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[16], new Object[0]), I18n.translate(a[6], new Object[0]), null, this.getClass());
                }
                if (n == 0) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            }
            if (!turkishESigProfile.equals((Object)TurkishESigProfile.P2_1)) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            if (signatureType == SignatureType.XAdES_T) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            if (signatureType == SignatureType.XAdES_C) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            if (signatureType == SignatureType.XAdES_X) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            if (signatureType == SignatureType.XAdES_X_L) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            if (signatureType == SignatureType.XAdES_A) return new ValidationResult(ValidationResultType.VALID, I18n.translate(a[2], new Object[0]), I18n.translate(a[18], new Object[0]), null, this.getClass());
            return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[15], new Object[0]), I18n.translate(a[17], new Object[0]), null, this.getClass());
        }
        catch (Exception exception) {
            logger.warn(a[19], (Throwable)exception);
            return new ValidationResult(ValidationResultType.INVALID, I18n.translate(a[1], new Object[0]), I18n.translate(a[4], new Object[0]), null, this.getClass());
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[20];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
        int n2 = -1;
        block27: while (true) {
            char[] cArray;
            block32: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block31: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block31;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block32;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 124;
                                break;
                            }
                            case 1: {
                                n8 = 83;
                                break;
                            }
                            case 2: {
                                n8 = 30;
                                break;
                            }
                            case 3: {
                                n8 = 62;
                                break;
                            }
                            default: {
                                n8 = 54;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 0;
                    continue block27;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 1;
                    continue block27;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 2;
                    continue block27;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0]W\u0012'}VS\u001f8";
                    n2 = 3;
                    continue block27;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0PY\b\u0007kL]\u0015 vnD\u00135wRS";
                    n2 = 4;
                    continue block27;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0PY?\u0001R";
                    n2 = 5;
                    continue block27;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0WX\n2rWR/:yPW\b&l[b\u0005#{";
                    n2 = 6;
                    continue block27;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0WX\n2rWR/:yPW\b&l[b\u0005#{";
                    n2 = 7;
                    continue block27;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 8;
                    continue block27;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0PY3\u0010Mn";
                    n2 = 9;
                    continue block27;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 10;
                    continue block27;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "+2lP_\u00124>WX\\\u0007kL]\u0015 v{e\u00154NLY\u001a:r[`\u001d?wZW\b<l";
                    n2 = 11;
                    continue block27;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 12;
                    continue block27;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0WX\n2rWR/:yPW\b&l[b\u0005#{";
                    n2 = 13;
                    continue block27;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 14;
                    continue block27;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "\n2rWR\u001d'wQXR0v[U\u0017}mWQ\u00122jKD\u0019\u0003qR_\u001f*_JB\u000e:|KB\u0019 ";
                    n2 = 15;
                    continue block27;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0WX\n2rWR/:yPW\b&l[b\u0005#{";
                    n2 = 16;
                    continue block27;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "\n2rWR\u001d'wQXR#qR_\u001f*0MC\u001f0{ME\u001a&r";
                    n2 = 17;
                    continue block27;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "+2lP_\u00124>WX\\\u0007kL]\u0015 v{e\u00154NLY\u001a:r[`\u001d?wZW\b<l";
                    n2 = 18;
                    continue block27;
                }
                case 18: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
        logger = LoggerFactory.getLogger(TurkishESigProfileValidator.class);
    }
}

