/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.validator;

import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.util.Base64;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.signature.profile.SignatureProfile;
import tr.gov.tubitak.uekae.esya.api.signature.profile.TurkishESigProfiles;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.DigestMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.document.Document;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.Transforms;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.Identifier;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.QualifyingProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.policy.SignaturePolicyId;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.policy.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.policy.SignaturePolicyQualifier;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.resolver.Resolver;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.KriptoUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.BaseTimeStampValidator;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.Validator;

public class SignaturePolicyValidator
implements Validator {
    private static final Logger a;
    private static final String[] b;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidationResult validate(XMLSignature aSignature, ECertificate aCertificate) throws XMLSignatureException {
        Object object;
        int n = BaseTimeStampValidator.b;
        QualifyingProperties qualifyingProperties = aSignature.getQualifyingProperties();
        if (qualifyingProperties == null) {
            return null;
        }
        SignedProperties signedProperties = qualifyingProperties.getSignedProperties();
        if (signedProperties == null) {
            return null;
        }
        SignedSignatureProperties signedSignatureProperties = signedProperties.getSignedSignatureProperties();
        if (signedSignatureProperties == null) {
            return null;
        }
        SignaturePolicyIdentifier signaturePolicyIdentifier = signedSignatureProperties.getSignaturePolicyIdentifier();
        if (signaturePolicyIdentifier == null) {
            return null;
        }
        SignaturePolicyId signaturePolicyId = signaturePolicyIdentifier.getSignaturePolicyId();
        if (signaturePolicyId == null && signaturePolicyIdentifier.isSignaturePolicyImplied()) {
            return null;
        }
        if (signaturePolicyId == null) {
            return new ValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(b[12], new Object[0]), I18n.translate(b[13], new Object[0]), null, this.getClass());
        }
        DigestMethod digestMethod = signaturePolicyId.getDigestMethod();
        byte[] byArray = signaturePolicyId.getDigestValue();
        Transforms transforms = signaturePolicyId.getTransforms();
        if (!this.a(signaturePolicyId)) {
            Document document;
            object = signaturePolicyId.getPolicyId().getIdentifier().getValue();
            if (a.isDebugEnabled()) {
                a.debug(b[18] + (String)object);
            }
            try {
                document = Resolver.resolve((String)object, aSignature.getContext());
            }
            catch (Exception exception) {
                a.warn(b[10], (Throwable)exception);
                return new ValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(b[7], new Object[0]), I18n.translate(b[17], new Object[0]), null, this.getClass());
            }
            boolean bl = this.validateDigest(document, transforms, digestMethod, byArray);
            if (!bl) {
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(b[14], new Object[0]), I18n.translate(b[9], new Object[0]), null, this.getClass());
            }
        }
        object = signaturePolicyId.getPolicyQualifiers();
        boolean bl = aSignature.getContext().getConfig().getValidationConfig().isCheckPolicyURI();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            SignaturePolicyQualifier signaturePolicyQualifier = (SignaturePolicyQualifier)iterator.next();
            if (signaturePolicyQualifier.getURI() != null && bl) {
                Document document;
                try {
                    document = Resolver.resolve(signaturePolicyQualifier.getURI(), aSignature.getContext());
                }
                catch (Exception exception) {
                    a.warn(b[8], (Throwable)exception);
                    return new ValidationResult(ValidationResultType.WARNING, I18n.translate(b[16], new Object[0]), I18n.translate(b[6], new Object[0]), null, this.getClass());
                }
                boolean bl2 = this.validateDigest(document, transforms, digestMethod, byArray);
                if (!bl2) {
                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(b[5], new Object[0]), I18n.translate(b[15], new Object[0]), null, this.getClass());
                }
            }
            if (n == 0) continue;
        }
        return new ValidationResult(ValidationResultType.VALID, I18n.translate(b[19], new Object[0]), I18n.translate(b[11], new Object[0]), null, this.getClass());
    }

    private boolean a(SignaturePolicyId signaturePolicyId) {
        try {
            SignatureProfile signatureProfile;
            OID oID;
            block8: {
                Identifier identifier;
                block7: {
                    identifier = signaturePolicyId.getPolicyId().getIdentifier();
                    if (identifier.getQualifier() != b[3]) break block7;
                    oID = OID.parse((String)identifier.getValue());
                    if (BaseTimeStampValidator.b == 0) break block8;
                }
                oID = OID.fromURN((String)identifier.getValue());
            }
            if ((signatureProfile = TurkishESigProfiles.resolve((OID)oID)) == null) {
                return false;
            }
            DigestAlg digestAlg = signaturePolicyId.getDigestMethod().getAlgorithm();
            boolean bl = Arrays.equals(signaturePolicyId.getDigestValue(), signatureProfile.getProfileDocInfo().getDigestOfProfile(digestAlg));
            if (!bl) {
                a.error(b[2]);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            a.debug(b[4], (Throwable)exception);
            return false;
        }
    }

    public boolean validateDigest(Document doc, Transforms transforms, DigestMethod digestMethod, byte[] digestValue) throws XMLSignatureException {
        if (transforms != null) {
            doc = transforms.apply(doc);
        }
        byte[] byArray = KriptoUtil.digest(doc.getBytes(), digestMethod);
        if (a.isDebugEnabled()) {
            a.debug(b[0] + Base64.encode((byte[])digestValue));
            a.debug(b[1] + Base64.encode((byte[])byArray));
        }
        return Arrays.equals(byArray, digestValue);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[20];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "&q\u00144\u001c66\u001c#\u0006%q\u001d0\u0003b8SkO";
        int n2 = -1;
        block27: while (true) {
            char[] cArray;
            block32: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block31: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block31;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block32;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 66;
                                break;
                            }
                            case 1: {
                                n8 = 24;
                                break;
                            }
                            case 2: {
                                n8 = 115;
                                break;
                            }
                            case 3: {
                                n8 = 81;
                                break;
                            }
                            default: {
                                n8 = 111;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "&q\u00144\u001c66\u00100\u0003!m\u001f0\u001b'|SkO";
                    n2 = 0;
                    continue block27;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0012w\u001f8\f;8\u00178\b'k\u0007q\u000b-8\u001d>\u001bbu\u0012%\f*9";
                    n2 = 1;
                    continue block27;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\rQ7\u0010\u001c\u0017J:";
                    n2 = 2;
                    continue block27;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u0012w\u001f8\f;8<\u0018+bh\u0012#\u001c'8\u00165\u0006.}\u001e4\u000b+6S";
                    n2 = 3;
                    continue block27;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001l{\u001b4\f)6\u00008\b,y\u0007$\u001d'H\u001c=\u0006!a";
                    n2 = 4;
                    continue block27;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001lh\u001c=\u0006!a]2\u000e,l58\u0001&Z\n\u0004\u001d+";
                    n2 = 5;
                    continue block27;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001l{\u001b4\f)6\u00008\b,y\u0007$\u001d'H\u001c=\u0006!a";
                    n2 = 6;
                    continue block27;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0015y\u0001?\u0006,\u007fS8\u0001bK\u001a6\u0001#l\u0006#\n\u0012w\u001f8\f;N\u0012=\u0006&y\u0007>\u001d";
                    n2 = 7;
                    continue block27;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001lh\u001c=\u0006!a]8\u00014y\u001f8\u000b\u0006q\u00144\u001c6";
                    n2 = 8;
                    continue block27;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u0015y\u0001?\u0006,\u007fS8\u0001bK\u001a6\u0001#l\u0006#\n\u0012w\u001f8\f;N\u0012=\u0006&y\u0007>\u001d";
                    n2 = 9;
                    continue block27;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001lh\u001c=\u0006!a]'\u000e.q\u0017";
                    n2 = 10;
                    continue block27;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001l{\u001b4\f)6\u00008\b,y\u0007$\u001d'H\u001c=\u0006!a";
                    n2 = 11;
                    continue block27;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001lh\u001c=\u0006!a]2\u000e,l58\u0001&Q\u0017";
                    n2 = 12;
                    continue block27;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001l{\u001b4\f)6\u00008\b,y\u0007$\u001d'H\u001c=\u0006!a";
                    n2 = 13;
                    continue block27;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001lh\u001c=\u0006!a]8\u00014y\u001f8\u000b\u0006q\u00144\u001c6Z\n\u0004\u001d+";
                    n2 = 14;
                    continue block27;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001l{\u001b4\f)6\u00008\b,y\u0007$\u001d'H\u001c=\u0006!a";
                    n2 = 15;
                    continue block27;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001lh\u001c=\u0006!a]2\u000e,l58\u0001&";
                    n2 = 16;
                    continue block27;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "\u0012w\u001f8\f;8&\u0003&x8";
                    n2 = 17;
                    continue block27;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "4y\u001f8\u000b#l\u001a>\u0001l{\u001b4\f)6\u00008\b,y\u0007$\u001d'H\u001c=\u0006!a";
                    n2 = 18;
                    continue block27;
                }
                case 18: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        b = stringArray3;
        a = LoggerFactory.getLogger(SignaturePolicyValidator.class);
    }
}

