/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.validator;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignatureTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedDataObjectProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.UnsignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.timestamp.EncapsulatedTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.timestamp.XAdESTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.EncapsulatedTimeStampValidator;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.Validator;

public abstract class BaseTimeStampValidator
implements Validator {
    public static final int MILLIS_IN_SECONDS = 1000;
    private static Logger a;
    public static int b;
    private static final String[] c;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidationResult validate(XMLSignature aSignature, ECertificate aCertificate) throws XMLSignatureException {
        int n = b;
        List<? extends XAdESTimeStamp> list = this.a(aSignature);
        if (list == null || list.size() < 1) {
            return null;
        }
        ValidationResult validationResult = new ValidationResult(this.getClass());
        for (XAdESTimeStamp xAdESTimeStamp : list) {
            a.debug(c[16] + xAdESTimeStamp.getLocalName() + c[11] + aSignature.getId());
            byte[] byArray = xAdESTimeStamp.getContentForTimeStamp(aSignature);
            if (xAdESTimeStamp.getEncapsulatedTimeStampCount() < 1) {
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[14], this.a()), I18n.translate(c[7], this.a()), null, this.getClass());
            }
            for (int i = 0; i < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++i) {
                EncapsulatedTimeStamp encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(i);
                try {
                    if (!encapsulatedTimeStamp.isTimeStamp()) {
                        return new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[17], this.a()), I18n.translate(c[5], this.a(), i), null, this.getClass());
                    }
                    byte[] byArray2 = DigestUtil.digest((DigestAlg)encapsulatedTimeStamp.getDigestAlgorithm(), (byte[])byArray);
                    if (!Arrays.equals(byArray2, encapsulatedTimeStamp.getDigestValue())) {
                        return new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[10], this.a()), I18n.translate(c[6], this.a(), i), null, this.getClass());
                    }
                    boolean bl = this.a(validationResult, encapsulatedTimeStamp.getTime(), encapsulatedTimeStamp, i, xAdESTimeStamp, aSignature, aCertificate);
                    if (!bl) {
                        validationResult.setStatus(ValidationResultType.INVALID, I18n.translate(c[15], this.a()), I18n.translate(c[9], new Object[0]), null);
                        return validationResult;
                    }
                    ValidationResult validationResult2 = this.verifySignature(aSignature, xAdESTimeStamp, encapsulatedTimeStamp);
                    validationResult.addItem(validationResult2);
                    if (validationResult2.getType() != ValidationResultType.VALID) {
                        validationResult.setStatus(ValidationResultType.INVALID, I18n.translate(c[13], this.a()), I18n.translate(c[12], this.a(), i), null);
                        return validationResult2;
                    }
                    ++i;
                    continue;
                }
                catch (Exception exception) {
                    throw new XMLSignatureException(exception, c[19], this.a(), i);
                }
            }
            if (n == 0) continue;
        }
        validationResult.setStatus(ValidationResultType.VALID, I18n.translate(c[18], this.a()), I18n.translate(c[8], this.a()), null);
        return validationResult;
    }

    protected ValidationResult verifySignature(XMLSignature signature, XAdESTimeStamp aXAdESTimeStamp, EncapsulatedTimeStamp aTimeStamp) {
        ValidationResult validationResult = new ValidationResult(this.getClass());
        try {
            XAdESTimeStamp xAdESTimeStamp = this.a(aXAdESTimeStamp, signature);
            EncapsulatedTimeStampValidator encapsulatedTimeStampValidator = new EncapsulatedTimeStampValidator(signature, aXAdESTimeStamp);
            EncapsulatedTimeStampValidator encapsulatedTimeStampValidator2 = encapsulatedTimeStampValidator;
            EncapsulatedTimeStamp encapsulatedTimeStamp = aTimeStamp;
            Calendar calendar = xAdESTimeStamp != null ? xAdESTimeStamp.getEncapsulatedTimeStamp(0).getTime() : null;
            return encapsulatedTimeStampValidator2.verify(encapsulatedTimeStamp, calendar);
        }
        catch (Exception exception) {
            a.error(c[25], (Throwable)exception);
            validationResult.setStatus(ValidationResultType.INCOMPLETE, I18n.translate(c[24], this.a()), I18n.translate(c[26], new Object[0]), exception.getMessage());
            return validationResult;
        }
    }

    abstract List<? extends XAdESTimeStamp> a(XMLSignature var1);

    abstract XAdESTimeStamp a(XAdESTimeStamp var1, XMLSignature var2) throws XMLSignatureException;

    abstract boolean a(ValidationResult var1, Calendar var2, EncapsulatedTimeStamp var3, int var4, XAdESTimeStamp var5, XMLSignature var6, ECertificate var7) throws XMLSignatureException;

    abstract String a();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected boolean checkTimestampVsSigningTime(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        int n;
        long l;
        long l2;
        long l3;
        SignedSignatureProperties signedSignatureProperties = aSignature.getQualifyingProperties().getSignedSignatureProperties();
        int n2 = aSignature.getContext().getConfig().getValidationConfig().getSignatureTimeToleranceInSeconds();
        if (signedSignatureProperties != null && signedSignatureProperties.getSigningTime() != null && (l3 = aTime.getTimeInMillis()) < (l2 = (l = signedSignatureProperties.getSigningTime().toGregorianCalendar().getTimeInMillis()) - (long)(n = n2 * 1000))) {
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[20], this.a()), I18n.translate(c[21], this.a(), aTSIndex, aTime.getTime(), signedSignatureProperties.getSigningTime().toGregorianCalendar().getTime()), null, this.getClass()));
            return false;
        }
        return true;
    }

    protected boolean checkTimestampVsSigningCertificate(Calendar aTime, int aTSIndex, ECertificate aCertificate, ValidationResult aResult) {
        Calendar calendar = aCertificate.getNotBefore();
        Calendar calendar2 = aCertificate.getNotAfter();
        if (aTime.after(calendar2) || aTime.before(calendar)) {
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[23], this.a()), I18n.translate(c[22], this.a(), aTSIndex, aTime.getTime()), null, this.getClass()));
            return false;
        }
        return true;
    }

    protected boolean checkTimestampVsDataObjectTimestamps(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        EncapsulatedTimeStamp encapsulatedTimeStamp;
        int n;
        XAdESTimeStamp xAdESTimeStamp;
        int n2;
        int n3 = b;
        boolean bl = true;
        SignedDataObjectProperties signedDataObjectProperties = aSignature.getQualifyingProperties().getSignedDataObjectProperties();
        if (signedDataObjectProperties == null) {
            return bl;
        }
        for (n2 = 0; n2 < signedDataObjectProperties.getAllDataObjectsTimeStampCount(); ++n2) {
            xAdESTimeStamp = signedDataObjectProperties.getAllDataObjectsTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        for (n2 = 0; n2 < signedDataObjectProperties.getIndividualDataObjectsTimeStampCount(); ++n2) {
            xAdESTimeStamp = signedDataObjectProperties.getIndividualDataObjectsTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        return bl;
    }

    protected boolean checkTimestampVsRefTimestamps(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        EncapsulatedTimeStamp encapsulatedTimeStamp;
        int n;
        XAdESTimeStamp xAdESTimeStamp;
        int n2;
        int n3 = b;
        boolean bl = true;
        UnsignedSignatureProperties unsignedSignatureProperties = aSignature.getQualifyingProperties().getUnsignedSignatureProperties();
        if (unsignedSignatureProperties == null) {
            return bl;
        }
        for (n2 = 0; n2 < unsignedSignatureProperties.getRefsOnlyTimeStampCount(); ++n2) {
            xAdESTimeStamp = unsignedSignatureProperties.getRefsOnlyTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        for (n2 = 0; n2 < unsignedSignatureProperties.getSigAndRefsTimeStampCount(); ++n2) {
            xAdESTimeStamp = unsignedSignatureProperties.getSigAndRefsTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        return bl;
    }

    protected boolean checkTimestampVsSignatureTimestamp(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        int n = b;
        boolean bl = true;
        UnsignedSignatureProperties unsignedSignatureProperties = aSignature.getQualifyingProperties().getUnsignedSignatureProperties();
        if (unsignedSignatureProperties == null) {
            return bl;
        }
        for (int i = 0; i < unsignedSignatureProperties.getSignatureTimeStampCount(); ++i) {
            SignatureTimeStamp signatureTimeStamp = unsignedSignatureProperties.getSignatureTimeStamp(i);
            for (int j = 0; j < signatureTimeStamp.getEncapsulatedTimeStampCount(); ++j) {
                EncapsulatedTimeStamp encapsulatedTimeStamp = signatureTimeStamp.getEncapsulatedTimeStamp(j);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, signatureTimeStamp, aResult);
                if (n == 0) continue;
            }
            if (n == 0) continue;
        }
        return bl;
    }

    protected boolean checkTimestampVsPreviousTimestamp(Calendar aTime, int aTSIndex, EncapsulatedTimeStamp aPreviousTS, XAdESTimeStamp aPreviousNode, ValidationResult aResult) {
        Calendar calendar;
        try {
            calendar = aPreviousTS.getTime();
        }
        catch (Exception exception) {
            a.warn(c[3], (Throwable)exception);
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[1], this.a()), exception.getMessage() + c[2] + aPreviousNode.getLocalName(), null, this.getClass()));
            return false;
        }
        if (aTime.before(calendar)) {
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(c[0], this.a()), I18n.translate(c[4], this.a(), aTSIndex, aTime.getTime(), aPreviousNode.getLocalName(), calendar.getTime()), null, this.getClass()));
            return false;
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[27];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
        int n2 = -1;
        block34: while (true) {
            char[] cArray;
            block39: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block38: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block38;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block39;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 26;
                                break;
                            }
                            case 1: {
                                n8 = 21;
                                break;
                            }
                            case 2: {
                                n8 = 69;
                                break;
                            }
                            case 3: {
                                n8 = 53;
                                break;
                            }
                            default: {
                                n8 = 73;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 0;
                    continue block34;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = ":/e";
                    n2 = 1;
                    continue block34;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "Mt7[ tre\\':W$F,N|(P\u001ant(E\u001f{y,Q(nz7";
                    n2 = 2;
                    continue block34;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94v$[=Xp\u0007P/ug a wp6A(we";
                    n2 = 3;
                    continue block34;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94|+C(v|!s&hx$A";
                    n2 = 4;
                    continue block34;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94|+C(v|!q }p6A";
                    n2 = 5;
                    continue block34;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94v$[=\\|+Q";
                    n2 = 6;
                    continue block34;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94c$Y ~";
                    n2 = 7;
                    continue block34;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94|+V&rp7P'n";
                    n2 = 8;
                    continue block34;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 9;
                    continue block34;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = ":s*Gii|\"[(n`7Pi";
                    n2 = 10;
                    continue block34;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94p7G&h";
                    n2 = 11;
                    continue block34;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 12;
                    continue block34;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 13;
                    continue block34;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 14;
                    continue block34;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "Lt)\\-{a \u0015";
                    n2 = 15;
                    continue block34;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 16;
                    continue block34;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 17;
                    continue block34;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94p7G&h";
                    n2 = 18;
                    continue block34;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 19;
                    continue block34;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94v$[=Xp\u0007P/ug f }{,[.N|(P";
                    n2 = 20;
                    continue block34;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94{*A\u001esa-\\'Yp7A ||&T=\u007fE G uq";
                    n2 = 21;
                    continue block34;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 22;
                    continue block34;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "lt)\\-{a,Z'4v-P*q;1\\$\u007ff1T$j";
                    n2 = 23;
                    continue block34;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "Yt+Ailp7\\/c5\u0011\\$\u007ff1T$j56\\.tt1@;\u007f";
                    n2 = 24;
                    continue block34;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "lt)\\-{a,Z'4a,X,ia$X94f,R'{a0G,4c G ||&T=sz+p;hz7";
                    n2 = 25;
                    continue block34;
                }
                case 25: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
        a = LoggerFactory.getLogger(BaseTimeStampValidator.class);
    }
}

