/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.core;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.BaseASNWrapper;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.signature.certval.CertificateSearchCriteria;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolverFromCertStore;
import tr.gov.tubitak.uekae.esya.api.signature.certval.match.CRLCriteriaMatcher;
import tr.gov.tubitak.uekae.esya.api.signature.certval.match.CertificateCriteriaMatcher;
import tr.gov.tubitak.uekae.esya.api.signature.certval.match.OCSPResponseCriteriaMatcher;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.CertValidationData;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.core.Constants;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.document.Document;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.BaseElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.KeyInfo;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.KeyInfoElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.RetrievalMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.X509Data;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509CRL;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509Certificate;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509DataElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509IssuerSerial;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509SKI;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509SubjectName;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.CertID;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.QualifyingProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.UnsignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CRLReference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CertificateValues;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CompleteCertificateRefs;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CompleteRevocationRefs;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.OCSPReference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.RevocationValues;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.resolver.Resolver;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.asn.util.AsnIO;

public class ValidationDataCollector {
    private static final Logger a;
    private boolean b = false;
    private String c;
    private ValidationInfoResolver d;
    private static final String[] e;

    public ValidationResult collect(XMLSignature aSignature, boolean resolveReferencesFromExternalSources) {
        int n;
        block8: {
            block7: {
                n = Constants.b;
                if (!resolveReferencesFromExternalSources) break block7;
                this.d = new ValidationInfoResolverFromCertStore();
                if (n == 0) break block8;
                BaseElement.b = !BaseElement.b;
            }
            this.d = new ValidationInfoResolver();
        }
        this.c = aSignature.getContext().getBaseURIStr();
        ValidationResult validationResult = this.fillValidationDataFromKeyInfo(aSignature);
        if (validationResult != null && validationResult.getType() != ValidationResultType.VALID) {
            return validationResult;
        }
        ValidationResult validationResult2 = this.fillValidationDataFromSignatureProperties(aSignature);
        if (validationResult2 != null && validationResult2.getType() != ValidationResultType.VALID) {
            return validationResult2;
        }
        for (XMLSignature xMLSignature : aSignature.getAllCounterSignatures()) {
            ValidationResult validationResult3 = this.collect(xMLSignature, resolveReferencesFromExternalSources);
            if (validationResult3 != null && validationResult3.getType() != ValidationResultType.VALID) {
                return validationResult3;
            }
            if (n == 0) continue;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValidationResult fillValidationDataFromKeyInfo(XMLSignature aSignature) {
        int n = Constants.b;
        CertValidationData certValidationData = aSignature.getContext().getValidationData(aSignature);
        try {
            KeyInfo keyInfo = aSignature.getKeyInfo();
            for (int i = 0; i < keyInfo.getElementCount(); ++i) {
                X509Data x509Data;
                KeyInfoElement keyInfoElement = keyInfo.get(i);
                if (keyInfoElement instanceof X509Data) {
                    x509Data = (X509Data)keyInfoElement;
                    boolean bl = false;
                    ECertificate eCertificate = null;
                    CertificateSearchCriteria certificateSearchCriteria = new CertificateSearchCriteria();
                    for (int j = 0; j < x509Data.getElementCount(); ++j) {
                        X509DataElement x509DataElement;
                        X509DataElement x509DataElement2 = x509Data.get(j);
                        if (x509DataElement2 instanceof X509Certificate) {
                            x509DataElement = (X509Certificate)x509DataElement2;
                            eCertificate = new ECertificate(((X509Certificate)x509DataElement).getCertificateBytes());
                            certValidationData.addCertificate(eCertificate);
                            this.a((BaseASNWrapper)eCertificate, e[5] + i);
                            if (n == 0) continue;
                        }
                        if (x509DataElement2 instanceof X509CRL) {
                            x509DataElement = (X509CRL)x509DataElement2;
                            certValidationData.addCRL(new ECRL(((X509CRL)x509DataElement).getCRLBytes()));
                            if (n == 0) continue;
                        }
                        if (x509DataElement2 instanceof X509IssuerSerial) {
                            x509DataElement = (X509IssuerSerial)x509DataElement2;
                            certificateSearchCriteria.setIssuer(((X509IssuerSerial)x509DataElement).getIssuerName());
                            certificateSearchCriteria.setSerial(((X509IssuerSerial)x509DataElement).getSerialNumber());
                            bl = true;
                            if (n == 0) continue;
                        }
                        if (x509DataElement2 instanceof X509SKI) {
                            x509DataElement = (X509SKI)x509DataElement2;
                            certificateSearchCriteria.setSubjectKeyIdentifier(((X509SKI)x509DataElement).getSKIBytes());
                            bl = true;
                            if (n == 0) continue;
                        }
                        if (!(x509DataElement2 instanceof X509SubjectName)) continue;
                        x509DataElement = (X509SubjectName)x509DataElement2;
                        certificateSearchCriteria.setSubject(((X509SubjectName)x509DataElement).getSubjectName());
                        bl = true;
                        if (n == 0) continue;
                    }
                    if (bl && eCertificate == null) {
                        List list = this.d.resolve(certificateSearchCriteria);
                        a.error(e[3]);
                        certValidationData.addCertificate((ECertificate)list.get(0));
                        this.a((BaseASNWrapper)list.get(0), e[0] + i);
                    }
                    if (n == 0) continue;
                }
                if (!(keyInfoElement instanceof RetrievalMethod)) continue;
                x509Data = new ECertificate(((RetrievalMethod)keyInfoElement).getRawX509());
                certValidationData.addCertificate((ECertificate)x509Data);
                this.a((BaseASNWrapper)x509Data, e[1] + i);
                if (n == 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            a.warn(exception.getMessage(), (Throwable)exception);
            return new ValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(e[2], new Object[0]), I18n.translate(e[4], new Object[0]), exception.getMessage(), this.getClass());
        }
        if (!BaseElement.b) return null;
        Constants.b = ++n;
        return null;
    }

    public ValidationResult fillValidationDataFromSignatureProperties(XMLSignature aSignature) {
        UnsignedSignatureProperties unsignedSignatureProperties;
        int n = Constants.b;
        CertValidationData certValidationData = aSignature.getContext().getValidationData(aSignature);
        QualifyingProperties qualifyingProperties = aSignature.getQualifyingProperties();
        if (qualifyingProperties != null && (unsignedSignatureProperties = qualifyingProperties.getUnsignedSignatureProperties()) != null) {
            CompleteRevocationRefs completeRevocationRefs;
            Object object;
            Object object2;
            CertID certID;
            int n2;
            RevocationValues revocationValues;
            CompleteCertificateRefs completeCertificateRefs;
            aSignature.getContext().getValidationData(aSignature).getTSValidationData().putAll(unsignedSignatureProperties.getAllTimeStampValidationData());
            CertificateValues certificateValues = unsignedSignatureProperties.getCertificateValues();
            if (certificateValues != null) {
                for (int i = 0; i < certificateValues.getCertificateCount(); ++i) {
                    try {
                        this.a((BaseASNWrapper)certificateValues.getCertificate(i), e[41] + i);
                        certValidationData.addCertificate(certificateValues.getCertificate(i));
                        continue;
                    }
                    catch (Exception exception) {
                        a.warn(exception.getMessage(), (Throwable)exception);
                        return new ValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(e[23], new Object[0]), I18n.translate(e[47], i, e[35], e[30]), null, ValidationDataCollector.class);
                    }
                }
            }
            if ((completeCertificateRefs = unsignedSignatureProperties.getCompleteCertificateRefs()) != null) {
                revocationValues = new CertificateCriteriaMatcher();
                for (n2 = 0; n2 < completeCertificateRefs.getCertificateReferenceCount(); ++n2) {
                    block50: {
                        block49: {
                            certID = completeCertificateRefs.getCertificateReference(n2);
                            boolean bl = false;
                            CertificateSearchCriteria certificateSearchCriteria = certID.toSearchCriteria();
                            for (int i = 0; i < certValidationData.getCertificates().size(); ++i) {
                                if (!revocationValues.match(certificateSearchCriteria, certValidationData.getCertificates().get(i))) continue;
                                bl = true;
                                if (n == 0) break;
                                if (n == 0) continue;
                                break;
                            }
                            if (bl && n == 0) continue;
                            String string = certID.getURI();
                            if (string == null || string.length() <= 0) break block49;
                            try {
                                object2 = Resolver.resolve(string, aSignature.getContext());
                                object = new ECertificate(((Document)object2).getBytes());
                                if (!revocationValues.match(certID.toSearchCriteria(), (ECertificate)object)) {
                                    this.a((BaseASNWrapper)object, e[50] + string);
                                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(e[26], new Object[0]), I18n.translate(e[17], e[28], string, e[45], certID), null, ValidationDataCollector.class);
                                }
                                this.a((BaseASNWrapper)object, e[37] + string);
                                certValidationData.addCertificate((ECertificate)object);
                                continue;
                            }
                            catch (Exception exception) {
                                a.warn(e[20] + certID.getX509IssuerName() + e[18] + certID.getX509SerialNumber() + e[36] + string + "'");
                                a.warn(exception.getMessage(), (Throwable)exception);
                                if (n == 0) continue;
                            }
                        }
                        try {
                            object2 = this.d.resolve(certID.toSearchCriteria());
                            if (object2 == null || object2.size() != 1) break block50;
                            this.a((BaseASNWrapper)object2.get(0), e[44] + n2);
                            certValidationData.addCertificate((ECertificate)object2.get(0));
                            if (n == 0) continue;
                        }
                        catch (Exception exception) {
                            a.warn(e[38], (Throwable)exception);
                        }
                    }
                    a.warn(e[27] + certID.getX509IssuerName() + e[6] + certID.getX509SerialNumber());
                    if (n == 0) continue;
                }
            }
            if ((revocationValues = unsignedSignatureProperties.getRevocationValues()) != null) {
                for (n2 = 0; n2 < revocationValues.getCRLValueCount(); ++n2) {
                    try {
                        this.a((BaseASNWrapper)revocationValues.getCRL(n2), e[11] + n2);
                        certValidationData.addCRL(revocationValues.getCRL(n2));
                        continue;
                    }
                    catch (Exception exception) {
                        a.warn(exception.getMessage(), (Throwable)exception);
                        return new ValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(e[12], new Object[0]), I18n.translate(e[53], n2, e[29], e[14]), null, ValidationDataCollector.class);
                    }
                }
                for (n2 = 0; n2 < revocationValues.getOCSPValueCount(); ++n2) {
                    try {
                        this.a((BaseASNWrapper)revocationValues.getOCSPResponse(n2), e[43] + n2);
                        certValidationData.addOCSPResponse(revocationValues.getOCSPResponse(n2));
                        continue;
                    }
                    catch (Exception exception) {
                        a.warn(exception.getMessage(), (Throwable)exception);
                        return new ValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(e[40], new Object[0]), I18n.translate(e[15], n2, e[10], e[51]), null, ValidationDataCollector.class);
                    }
                }
            }
            if ((completeRevocationRefs = unsignedSignatureProperties.getCompleteRevocationRefs()) != null) {
                EOCSPResponse eOCSPResponse;
                int n3;
                certID = new OCSPResponseCriteriaMatcher();
                CRLCriteriaMatcher cRLCriteriaMatcher = new CRLCriteriaMatcher();
                for (n3 = 0; n3 < completeRevocationRefs.getOCSPReferenceCount(); ++n3) {
                    OCSPReference oCSPReference;
                    block52: {
                        block51: {
                            oCSPReference = completeRevocationRefs.getOCSPReference(n3);
                            object2 = oCSPReference.getOCSPIdentifier().getURI();
                            if (object2 == null || ((String)object2).length() <= 0) break block51;
                            try {
                                object = Resolver.resolve((String)object2, aSignature.getContext());
                                eOCSPResponse = new EOCSPResponse(((Document)object).getBytes());
                                if (!certID.match(oCSPReference.toSearchCriteria(), eOCSPResponse)) {
                                    this.a((BaseASNWrapper)eOCSPResponse, e[24] + (String)object2);
                                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(e[42], new Object[0]), I18n.translate(e[34], e[56], object2, e[31], oCSPReference), null, ValidationDataCollector.class);
                                }
                                this.a((BaseASNWrapper)eOCSPResponse, e[55] + (String)object2);
                                certValidationData.addOCSPResponse(eOCSPResponse);
                                continue;
                            }
                            catch (Exception exception) {
                                a.warn(e[9] + oCSPReference + e[13] + (String)object2 + "'");
                                a.warn(exception.getMessage(), (Throwable)exception);
                                if (n == 0) continue;
                            }
                        }
                        try {
                            object = this.d.resolve(oCSPReference.toSearchCriteria());
                            if (object == null || object.size() != 1) break block52;
                            this.a((BaseASNWrapper)object.get(0), e[49] + n3);
                            certValidationData.addOCSPResponse((EOCSPResponse)object.get(0));
                            if (n == 0) continue;
                        }
                        catch (Exception exception) {
                            a.warn(e[32], (Throwable)exception);
                        }
                    }
                    a.warn(e[54] + oCSPReference);
                    if (n == 0) continue;
                }
                for (n3 = 0; n3 < completeRevocationRefs.getCRLReferenceCount(); ++n3) {
                    CRLReference cRLReference;
                    block54: {
                        block53: {
                            cRLReference = completeRevocationRefs.getCRLReference(n3);
                            object2 = cRLReference.getCRLIdentifier().getURI();
                            if (object2 == null || ((String)object2).length() <= 0) break block53;
                            try {
                                object = Resolver.resolve((String)object2, aSignature.getContext());
                                eOCSPResponse = new ECRL(((Document)object).getBytes());
                                certValidationData.addCRL((ECRL)eOCSPResponse);
                                if (!cRLCriteriaMatcher.match(cRLReference.toSearchCriteria(), (ECRL)eOCSPResponse)) {
                                    a.error(e[22] + (String)object2 + e[21] + cRLReference);
                                    this.a((BaseASNWrapper)eOCSPResponse, e[19] + (String)object2);
                                    return new ValidationResult(ValidationResultType.INVALID, I18n.translate(e[16], new Object[0]), I18n.translate(e[52], e[7], object2, e[46], cRLReference), null, ValidationDataCollector.class);
                                }
                                this.a((BaseASNWrapper)eOCSPResponse, e[48] + (String)object2);
                                continue;
                            }
                            catch (Exception exception) {
                                a.debug(e[33] + cRLReference + e[57] + (String)object2 + "'");
                                a.debug(exception.getMessage(), (Throwable)exception);
                                if (n == 0) continue;
                            }
                        }
                        try {
                            object = this.d.resolve(cRLReference.toSearchCriteria());
                            if (object == null || object.size() != 1) break block54;
                            this.a((BaseASNWrapper)object.get(0), e[25] + n3);
                            certValidationData.addCRL((ECRL)object.get(0));
                            if (n == 0) continue;
                        }
                        catch (Exception exception) {
                            a.warn(e[39], (Throwable)exception);
                        }
                    }
                    a.warn(e[8] + cRLReference);
                    if (n == 0) continue;
                }
            }
        }
        return null;
    }

    public List<ECertificate> findCertificatesFromReferences(XMLSignature aSignature) {
        int n = Constants.b;
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        CompleteCertificateRefs completeCertificateRefs = aSignature.getQualifyingProperties().getUnsignedSignatureProperties().getCompleteCertificateRefs();
        if (completeCertificateRefs != null) {
            for (int i = 0; i < completeCertificateRefs.getCertificateReferenceCount(); ++i) {
                arrayList.addAll(this.d.resolve(completeCertificateRefs.getCertificateReference(i).toSearchCriteria()));
                if (n == 0) continue;
            }
        }
        return arrayList;
    }

    public List<ECRL> findCRLsFromReferences(XMLSignature aSignature) {
        int n = Constants.b;
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        CompleteRevocationRefs completeRevocationRefs = aSignature.getQualifyingProperties().getUnsignedSignatureProperties().getCompleteRevocationRefs();
        if (completeRevocationRefs != null) {
            for (int i = 0; i < completeRevocationRefs.getCRLReferenceCount(); ++i) {
                arrayList.addAll(this.d.resolve(completeRevocationRefs.getCRLReference(i).toSearchCriteria()));
                if (n == 0) continue;
            }
        }
        return arrayList;
    }

    public List<EOCSPResponse> findOCSResponsesFromReferences(XMLSignature aSignature) {
        int n = Constants.b;
        ArrayList<EOCSPResponse> arrayList = new ArrayList<EOCSPResponse>();
        CompleteRevocationRefs completeRevocationRefs = aSignature.getQualifyingProperties().getUnsignedSignatureProperties().getCompleteRevocationRefs();
        if (completeRevocationRefs != null) {
            for (int i = 0; i < completeRevocationRefs.getOCSPReferenceCount(); ++i) {
                arrayList.addAll(this.d.resolve(completeRevocationRefs.getOCSPReference(i).toSearchCriteria()));
                if (n == 0) continue;
            }
        }
        return arrayList;
    }

    private void a(BaseASNWrapper baseASNWrapper, String string) {
        block4: {
            block5: {
                if (!this.b) break block4;
                if (string != null) break block5;
                string = System.currentTimeMillis() + "";
            }
            try {
                AsnIO.dosyayaz((byte[])baseASNWrapper.getEncoded(), (String)(this.c + e[58] + string + "." + baseASNWrapper.getClass().getSimpleName()));
            }
            catch (Exception exception) {
                a.error(e[59], (Throwable)exception);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[60];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0002yJ)[\u000fsl\u0006Z\u001crW?";
        int n2 = -1;
        block67: while (true) {
            char[] cArray;
            block72: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block71: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block71;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block72;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 105;
                                break;
                            }
                            case 1: {
                                n8 = 28;
                                break;
                            }
                            case 2: {
                                n8 = 51;
                                break;
                            }
                            case 3: {
                                n8 = 96;
                                break;
                            }
                            default: {
                                n8 = 53;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u0002yJ)[\u000fsl\u0012P\u001dnZ\u0005C\fxl";
                    n2 = 0;
                    continue block67;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u001f}_\tQ\bhZ\u000f[G\u007f[\u0005V\u00022X\u0005L rU\u000f";
                    n2 = 1;
                    continue block67;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "*}]\u0014\u0015\u000fu]\u0004\u0015\nyA\u0014\\\u000fuP\u0001A\f<A\u0005S\fnV\u000eV\fx\u0013\t[IWV\u0019|\u0007z\\";
                    n2 = 2;
                    continue block67;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\nsA\u0005\u001b\u0000rE\u0001Y\u0000xx\u0005L rU\u000f";
                    n2 = 3;
                    continue block67;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0002yJ)[\u000fs";
                    n2 = 4;
                    continue block67;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "R<@\u0005G\u0000}_]";
                    n2 = 5;
                    continue block67;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "*N\u007f";
                    n2 = 6;
                    continue block67;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "*}]\u0014\u0015\u001by@\u000fY\u001fy\u0013\u0003G\u0005<\u001c@";
                    n2 = 7;
                    continue block67;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "*}]\u0014\u0015\u001by@\u000fY\u001fy\u0013\u000fV\u001al\u0013\u0012P\u001al\\\u000eF\f<";
                    n2 = 8;
                    continue block67;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "&_`0";
                    n2 = 9;
                    continue block67;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "\u001byE?C\bpF\u0005j";
                    n2 = 10;
                    continue block67;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "\u001f}_\tQ\bhZ\u000f[G\u007f[\u0005V\u00022X\u0005L rU\u000f";
                    n2 = 11;
                    continue block67;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "IzA\u000fXIIa)\u000fI;";
                    n2 = 12;
                    continue block67;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = ";yE\u000fV\bhZ\u000f[?}_\u0015P\u001a";
                    n2 = 13;
                    continue block67;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "\u001f}_\tQ\bhZ\u000f[GxR\u0014TG\u007fR\u000eA*s]\u0013A\u001biP\u0014";
                    n2 = 14;
                    continue block67;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "\u001f}_\tQ\bhZ\u000f[G\u007f[\u0005V\u00022X\u0005L rU\u000f";
                    n2 = 15;
                    continue block67;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "\u001f}_\tQ\bhZ\u000f[GxR\u0014TGnV\u0013Z\u0005iG\tZ\u0007QZ\u0013X\bhP\b";
                    n2 = 16;
                    continue block67;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "R<@\u0005G\u0000}_]";
                    n2 = 17;
                    continue block67;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "\u001byU?X\u0000o^\u0001A\ntl\u0015G\u0000C";
                    n2 = 18;
                    continue block67;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "*}]\u0014\u0015\u001by@\u000fY\u001fy\u0013\u0003P\u001bhZ\u0006\\\n}G\u0005\u0015F<Z\u0013F\u001cyAZ\u0015";
                    n2 = 19;
                    continue block67;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "N5\u0013\r\\\u001aqR\u0014V\u0001<p2y;yUZ\u0015";
                    n2 = 20;
                    continue block67;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = ";y@\u000fY\u001fyW@v;P\u0013H@\u001bu\u000eG";
                    n2 = 21;
                    continue block67;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "\u001f}_\tQ\bhZ\u000f[G\u007f[\u0005V\u00022X\u0005L rU\u000f";
                    n2 = 22;
                    continue block67;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "\u001byU?X\u0000o^\u0001A\ntl\u0015G\u0000C";
                    n2 = 23;
                    continue block67;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "\u001byU?S\u0006i]\u0004j";
                    n2 = 24;
                    continue block67;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "\u001f}_\tQ\bhZ\u000f[G\u007f[\u0005V\u00022X\u0005L rU\u000f";
                    n2 = 25;
                    continue block67;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "*}]\u0014\u0015\u001by@\u000fY\u001fy\u0013\u0003P\u001bhZ\u0006\\\n}G\u0005\u0015F<Z\u0013F\u001cyAZ\u0015";
                    n2 = 26;
                    continue block67;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "\nyA\u0014\\\u000fuP\u0001A\f";
                    n2 = 27;
                    continue block67;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "*N\u007f";
                    n2 = 28;
                    continue block67;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "*yA\u0014\\\u000fuP\u0001A\fJR\f@\fo";
                    n2 = 29;
                    continue block67;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "&_`0g\fz";
                    n2 = 30;
                    continue block67;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = ",nA\u000fGIsP\u0003@\u001bnV\u0004\u0015\u001ayR\u0012V\u0001u]\u0007\u0015\u0006\u007f@\u0010\u0015\u001by@\u0010Z\u0007oV@";
                    n2 = 31;
                    continue block67;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "*}]\u0014\u0015\u001by@\u000fY\u001fy\u0013#g%<\u001c@";
                    n2 = 32;
                    continue block67;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "\u001f}_\tQ\bhZ\u000f[GxR\u0014TGnV\u0013Z\u0005iG\tZ\u0007QZ\u0013X\bhP\b";
                    n2 = 33;
                    continue block67;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "\nyA\u0014\\\u000fuP\u0001A\f";
                    n2 = 34;
                    continue block67;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "IzA\u000fXIIa)\u000fI;";
                    n2 = 35;
                    continue block67;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = "\u001byU?@\u001bul";
                    n2 = 36;
                    continue block67;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = ",nA\u000fGIsP\u0003@\u001bnV\u0004\u0015\u001ayR\u0012V\u0001u]\u0007\u0015\nyA\u0014\u0015";
                    n2 = 37;
                    continue block67;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = ",nA\u000fGIsP\u0003@\u001bnV\u0004\u0015\u001ayR\u0012V\u0001u]\u0007\u0015\nn_@";
                    n2 = 38;
                    continue block67;
                }
                case 38: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 40;
                    string2 = "\u001f}_\tQ\bhZ\u000f[G\u007f[\u0005V\u00022X\u0005L rU\u000f";
                    n2 = 39;
                    continue block67;
                }
                case 39: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 41;
                    string2 = "\nyA\u0014j\u001f}_\u0015P6";
                    n2 = 40;
                    continue block67;
                }
                case 40: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 42;
                    string2 = "\u001f}_\tQ\bhZ\u000f[G\u007f[\u0005V\u00022X\u0005L rU\u000f";
                    n2 = 41;
                    continue block67;
                }
                case 41: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 43;
                    string2 = "\u001byE?C\bpF\u0005j";
                    n2 = 42;
                    continue block67;
                }
                case 42: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 44;
                    string2 = "\u001byU?S\u0006i]\u0004j";
                    n2 = 43;
                    continue block67;
                }
                case 43: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 45;
                    string2 = "*yA\u0014|-";
                    n2 = 44;
                    continue block67;
                }
                case 44: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 46;
                    string2 = "*N\u007f2P\u000f";
                    n2 = 45;
                    continue block67;
                }
                case 45: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 47;
                    string2 = "\u001f}_\tQ\bhZ\u000f[GxR\u0014TG\u007fR\u000eA*s]\u0013A\u001biP\u0014";
                    n2 = 46;
                    continue block67;
                }
                case 46: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 48;
                    string2 = "\u001byU?@\u001bul";
                    n2 = 47;
                    continue block67;
                }
                case 47: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 49;
                    string2 = "\u001byU?S\u0006i]\u0004j";
                    n2 = 48;
                    continue block67;
                }
                case 48: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 50;
                    string2 = "\u001byU?X\u0000o^\u0001A\ntl\u0015G\u0000C";
                    n2 = 49;
                    continue block67;
                }
                case 49: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 51;
                    string2 = ";yE\u000fV\bhZ\u000f[?}_\u0015P\u001a";
                    n2 = 50;
                    continue block67;
                }
                case 50: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 52;
                    string2 = "\u001f}_\tQ\bhZ\u000f[GxR\u0014TGnV\u0013Z\u0005iG\tZ\u0007QZ\u0013X\bhP\b";
                    n2 = 51;
                    continue block67;
                }
                case 51: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 53;
                    string2 = "\u001f}_\tQ\bhZ\u000f[GxR\u0014TG\u007fR\u000eA*s]\u0013A\u001biP\u0014";
                    n2 = 52;
                    continue block67;
                }
                case 52: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 54;
                    string2 = "*}]\u0014\u0015\u001by@\u000fY\u001fy\u0013\u000fV\u001al\u0013\u0012P\u001al\\\u000eF\f<";
                    n2 = 53;
                    continue block67;
                }
                case 53: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 55;
                    string2 = "\u001byU?@\u001bul";
                    n2 = 54;
                    continue block67;
                }
                case 54: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 56;
                    string2 = "&_`0";
                    n2 = 55;
                    continue block67;
                }
                case 55: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 57;
                    string2 = "IzA\u000fXIIa)\u000fI;";
                    n2 = 56;
                    continue block67;
                }
                case 56: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 58;
                    string2 = "5xV\u0002@\u000eC";
                    n2 = 57;
                    continue block67;
                }
                case 57: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 59;
                    string2 = ",nA\u000fGIu]@c\bpZ\u0004T\u001du\\\u000eq\bhR#Z\u0005pV\u0003A\u0006n";
                    n2 = 58;
                    continue block67;
                }
                case 58: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
        a = LoggerFactory.getLogger(ValidationDataCollector.class);
    }
}

