/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.algorithms;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.Crypto;
import tr.gov.tubitak.uekae.esya.api.crypto.MAC;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MACAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.algorithms.XmlSignatureAlgorithm;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;

public class HMACIntegrity
implements XmlSignatureAlgorithm {
    private static Logger a;
    public static final String PARAM_HMAC_OUTPUT_LEGTH;
    private MACAlg b;
    private MAC c;
    private static final String[] d;

    public HMACIntegrity(MACAlg aMACAlg) {
        this.b = aMACAlg;
    }

    @Override
    public String getAlgorithmName() {
        return this.b.getName();
    }

    @Override
    public void initSign(Key aKey, AlgorithmParams aParameters) throws XMLSignatureException {
        this.a(aKey, aParameters);
    }

    @Override
    public void initVerify(Key aKey, AlgorithmParams aParameters) throws XMLSignatureException {
        this.a(aKey, aParameters);
    }

    @Override
    public void update(byte[] aData) throws XMLSignatureException {
        try {
            this.c.process(aData);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, d[11], d[12]);
        }
    }

    @Override
    public byte[] sign() throws XMLSignatureException {
        try {
            return this.c.doFinal(null);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, d[0]);
        }
    }

    @Override
    public boolean verify(byte[] aSignatureValue) throws XMLSignatureException {
        try {
            byte[] byArray = this.c.doFinal(null);
            if (a.isDebugEnabled()) {
                a.debug(d[1] + new String(byArray));
                a.debug(d[2] + new String(aSignatureValue));
            }
            return Arrays.equals(byArray, aSignatureValue);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, d[3]);
        }
    }

    private void a(Key key, AlgorithmParams algorithmParams) throws XMLSignatureException {
        if (a.isDebugEnabled()) {
            a.debug(d[5] + key + d[10] + algorithmParams);
        }
        if (!(key instanceof SecretKey)) {
            throw new XMLSignatureException(d[8], key.toString());
        }
        try {
            this.c = Crypto.getMAC((MACAlg)this.b);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, d[9] + this.b);
        }
        try {
            this.c.init(key, algorithmParams);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, d[4], d[7] + I18n.translate(d[6], new Object[0]));
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "TZ\u0004\u0003dSB\u0011\u0010?H\u0019\t\u0005$[_\u0011";
        int n2 = 12;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block25;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 60;
                                break;
                            }
                            case 1: {
                                n8 = 55;
                                break;
                            }
                            case 2: {
                                n8 = 101;
                                break;
                            }
                            case 3: {
                                n8 = 96;
                                break;
                            }
                            default: {
                                n8 = 74;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                case 12: {
                    PARAM_HMAC_OUTPUT_LEGTH = string.intern();
                    string2 = "\u007fV\u000b\u0014jX^\u0002\u00059H\u0017(!\t";
                    n2 = -1;
                    continue block21;
                }
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "X^\u0002\u00059H\rE";
                    n2 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "O^\u0002\u000e+HB\u0017\u0005\u001c][\u0010\u0005p\u001c";
                    n2 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u007fV\u000b\u0014jJR\u0017\t,E\u0017(!\t";
                    n2 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "YE\u0017\u000f8O\u0019\u0006\u0001$H~\u000b\t>";
                    n2 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "TZ\u0004\u0003jUY\f\u0014p\u001c";
                    n2 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "O^\u0002\u000e/N";
                    n2 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "tz$#j";
                    n2 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "_X\u0017\u0005dUY\u0013\u0001&USK\u0013/_E\u0000\u0014!YN";
                    n2 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u007fV\u000b\u0014jNR\u0016\u000f&JRE-+_\u0017";
                    n2 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u0010\u0017";
                    n2 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "YE\u0017\u000f8O\u0019\u0006\u0001$Hb\u0015\u0004+HR";
                    n2 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "qv&";
                    n2 = 11;
                    continue block21;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        d = stringArray3;
        a = LoggerFactory.getLogger(HMACIntegrity.class);
    }

    public static class HMACwithSHA512
    extends HMACIntegrity {
        public HMACwithSHA512() {
            super(MACAlg.HMAC_SHA512);
        }
    }

    public static class HMACwithSHA384
    extends HMACIntegrity {
        public HMACwithSHA384() {
            super(MACAlg.HMAC_SHA384);
        }
    }

    public static class HMACwithSHA256
    extends HMACIntegrity {
        public HMACwithSHA256() {
            super(MACAlg.HMAC_SHA256);
        }
    }

    public static class HMACwithSHA1
    extends HMACIntegrity {
        public HMACwithSHA1() {
            super(MACAlg.HMAC_SHA1);
        }
    }

    public static class HMACwithRIPEMD
    extends HMACIntegrity {
        public HMACwithRIPEMD() {
            super(MACAlg.HMAC_RIPEMD);
        }
    }

    public static class HMACwithMD5
    extends HMACIntegrity {
        public HMACwithMD5() {
            super(MACAlg.HMAC_MD5);
        }
    }
}

