/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.AkisException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.UnsupportedVersionException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands.AbstractAkisCommands;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands.CIFFactory;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.CommandTransmitterPCSC;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.Conversions;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.ICommandTransmitter;

public class PKCS11Functions {
    protected Hashtable<String, Integer> serialCertID;
    protected Hashtable<String, Integer> serialKeyID;
    protected TerminalFactory terminalFact = TerminalFactory.getDefault();
    protected AbstractAkisCommands commands;
    protected ICommandTransmitter card;
    private static final String[] a;

    public PKCS11Functions() throws CertificateException {
        this.serialCertID = new Hashtable();
        this.serialKeyID = new Hashtable();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getSlotList() throws CardException {
        boolean bl = AbstractAkisCommands.b;
        int n = this.terminalFact.terminals().list().size();
        long[] lArray = new long[n];
        int n2 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            lArray[n2] = n2 + 1;
            ++n2;
        } while (n2 < n);
        return lArray;
    }

    public CardTerminal[] getTerminalList() throws CardException {
        return this.terminalFact.terminals().list().toArray(new CardTerminal[0]);
    }

    public void openSession(long aSlot) throws CardException, AkisException, Exception {
        this.openSession(new CommandTransmitterPCSC(this.terminalFact.terminals().list().get((int)aSlot - 1), false));
    }

    public void openSession(ICommandTransmitter transmitter) throws CardException, AkisException, Exception {
        this.card = transmitter;
        this.commands = CIFFactory.getAkisCIFInstance(transmitter);
        this.commands.selectMF();
        try {
            this.commands.selectDFByName(a[3].getBytes(a[4]));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public void closeSession() throws CardException {
        this.card.closeCardTerminal();
    }

    public void login(String aPIN) throws CardException, UnsupportedVersionException {
        this.commands.verify(aPIN.getBytes(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<byte[]> getSignatureCertificates() throws CardException, CertificateException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[]{47, 15};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 1;
        int n2 = 0;
        while (true) {
            try {
                while (true) {
                    byArray[1] = (byte)(byArray[1] + 1);
                    byte[] byArray2 = this.commands.readFileBySelectingUnderActiveDF(byArray);
                    n2 = 0;
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(a[2]);
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
                    if (x509Certificate.getKeyUsage()[0]) {
                        arrayList.add(byArray2);
                        this.serialCertID.put(Conversions.hexBytetoHexString(x509Certificate.getSerialNumber().toByteArray()), n);
                    }
                    ++n;
                }
            }
            catch (AkisException akisException) {
                if (akisException.getErrorCode() != 27266L) throw akisException;
                if (++n2 <= 2) continue;
                if (!bl) return arrayList;
                throw akisException;
            }
            break;
        }
    }

    private byte[] a(byte[] byArray, byte by, byte[] byArray2, String string, X509Certificate x509Certificate, String string2) throws CardException, Exception {
        byte[] byArray3 = this.commands.sign(byArray, by);
        if (this.a(byArray3, byArray2, x509Certificate, string2)) {
            this.serialKeyID.put(string, Integer.valueOf(by));
            return byArray3;
        }
        throw new AkisException(25616L);
    }

    private boolean a(CardException cardException) {
        block8: {
            if (cardException instanceof AkisException) {
                block7: {
                    long l = ((AkisException)cardException).getErrorCode();
                    if (l == 25616L || l == 25625L) break block7;
                    if (l != 27015L) break block8;
                }
                return true;
            }
        }
        return false;
    }

    private boolean a(byte[] byArray, byte[] byArray2, X509Certificate x509Certificate, String string) throws Exception {
        String string2 = String.valueOf(string.replaceAll("-", "")) + a[0] + a[1];
        Signature signature = Signature.getInstance(string2);
        signature.initVerify(x509Certificate);
        signature.update(byArray2);
        return signature.verify(byArray);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0018\u001dA[";
        int n2 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block16;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 111;
                                break;
                            }
                            case 1: {
                                n8 = 116;
                                break;
                            }
                            case 2: {
                                n8 = 53;
                                break;
                            }
                            case 3: {
                                n8 = 51;
                                break;
                            }
                            default: {
                                n8 = 42;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "='t";
                    n2 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "7Z\u0000\u0003\u0013";
                    n2 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "??v`\u0007^A";
                    n2 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = ".'vzc";
                    n2 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

