/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import javax.crypto.Cipher;
import javax.smartcardio.CardException;
import javax.smartcardio.ResponseAPDU;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.AkisException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.akisExceptions.UnsupportedVersionException;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands.AbstractAkisCommands;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.commands.PublicKeys;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.AkisKey;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.Algorithm;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.AuthenticationType;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FCI;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileAccessRules;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileIDs;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileLevel;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.FileTypes;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.GetDataModes;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.KeyType;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.Manufacturer;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.P1P2;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.RSAKeyFields;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.dataStructures.Version;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.Crypto;
import tr.gov.tubitak.bilgem.uekae.akis.akisCIF.functions.ICommandTransmitter;

public class CommandsV11
extends AbstractAkisCommands {
    protected PublicKey currentSecureMessagingGeneratingKey = null;
    private static final String[] a;

    public CommandsV11(ICommandTransmitter transmitter, Version vers) {
        super(transmitter, vers);
        this.phaseBytePosition = 8;
        this.pso_param.cds = new P1P2(-98, -102);
        this.pso_param.vds = new P1P2(0, -88);
        this.pso_param.enc = new P1P2(-122, -128);
        this.pso_param.dec = new P1P2(-128, -122);
        this.pso_param.ccc = new P1P2(-114, -128);
        this.pso_param.vcc = new P1P2(0, -94);
        this.fileAccessRules = new FileAccessRules(-65, -77, -1, 0);
        this.fileTypes = new FileTypes(-128, 65, 67, 69);
    }

    @Override
    public void createBinaryEFbySFI(byte[] FID, byte SFI, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void createDFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[7];
        byArray[0] = -128;
        byArray[1] = 16;
        byArray[3] = -73;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
    }

    @Override
    public void createDFbyName(byte[] FID, byte[] name, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 16;
        byArray[3] = 55;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)name.length;
        byArray3 = new byte[name.length + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(name, 0, byArray3, byArray2.length, name.length);
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
    }

    @Override
    public void deleteCurrent() throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteByFIDUnderMF(byte[] FID, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[7];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[4] = 2;
        byArray[5] = FID[0];
        byArray[6] = FID[1];
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public void deleteByFIDUnderDF(byte[] FID, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        int n2 = level == FileLevel.DF ? 1 : 2;
        byte by2 = (byte)n2;
        byte[] byArray = new byte[7];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = by2;
        byArray[4] = 2;
        byArray[5] = FID[0];
        byArray[6] = FID[1];
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public void deleteDFByName(byte[] name) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 17;
        byArray[2] = 4;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + name.length];
        byArray2[4] = (byte)name.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(name, 0, byArray3, byArray2.length, name.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByFIDPathFromMF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 8;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByFIDPathFromDF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 9;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByNamePathFromMF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 12;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteByNamePathFromDF(byte[] path, FileLevel level) throws AkisException, CardException, UnsupportedVersionException {
        int n = level == FileLevel.DF ? 17 : 22;
        byte by = (byte)n;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = by;
        byArray[2] = 13;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + path.length];
        byArray2[4] = (byte)path.length;
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(path, 0, byArray3, byArray2.length, path.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void deleteParentDF() throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    public void selectFileByNameUnderActiveDF(byte[] name) throws AkisException, CardException {
        byte[] byArray = new byte[4];
        byArray[1] = -92;
        byArray[2] = 13;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + name.length + 1];
        int n = 0;
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        byArray3[n += byArray2.length] = (byte)name.length;
        System.arraycopy(name, 0, byArray3, ++n, name.length);
        this.sendCommand(byArray3);
    }

    @Override
    public FCI selectMF() throws AkisException, CardException {
        return this.selectFileUnderMF(FileIDs.MF);
    }

    @Override
    public FCI selectFileUnderMF(byte[] FID) throws AkisException, CardException {
        byte[] byArray = new byte[8];
        byArray[1] = -92;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectChildDF(byte[] FID) throws AkisException, CardException {
        byte[] byArray = new byte[8];
        byArray[1] = -92;
        byArray[2] = 1;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectEFUnderDF(byte[] FID) throws AkisException, CardException {
        byte[] byArray = new byte[8];
        byArray[1] = -92;
        byArray[2] = 2;
        byArray[4] = 2;
        byte[] byArray2 = byArray;
        byArray2[5] = FID[0];
        byArray2[6] = FID[1];
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectParentDF() throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = -92;
        byArray[2] = 3;
        byte[] byArray2 = byArray;
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        byte[] byArray3 = responseAPDU.getData();
        return new FCI(byArray3);
    }

    @Override
    public FCI selectDFByName(byte[] name) throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = -92;
        byArray[2] = 4;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)name.length;
        byArray3 = new byte[name.length + 6];
        int n = 0;
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(name, 0, byArray3, n += byArray2.length, name.length);
        byArray3[n += name.length] = 0;
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
        byte[] byArray4 = responseAPDU.getData();
        return new FCI(byArray4);
    }

    @Override
    public FCI selectFromMFByPath(byte[] path) throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = -92;
        byArray[2] = 8;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)path.length;
        byArray3 = new byte[path.length + 6];
        int n = 0;
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(path, 0, byArray3, n += byArray2.length, path.length);
        byArray3[n += path.length] = 0;
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
        byte[] byArray4 = responseAPDU.getData();
        return new FCI(byArray4);
    }

    @Override
    public FCI selectFromDFByPath(byte[] path) throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = -92;
        byArray[2] = 9;
        byte[] byArray2 = byArray;
        byte[] byArray3 = null;
        byArray2[4] = (byte)path.length;
        byArray3 = new byte[path.length + 6];
        int n = 0;
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(path, 0, byArray3, n += byArray2.length, path.length);
        byArray3[n += path.length] = 0;
        ResponseAPDU responseAPDU = this.sendCommand(byArray3);
        byte[] byArray4 = responseAPDU.getData();
        return new FCI(byArray4);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public byte[] readFileBySelectingUnderActiveDF(byte[] FID) throws AkisException, CardException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = null;
        int n = this.selectEFUnderDF(FID).getFileLength();
        if (n > 0) {
            byArray = new byte[n];
            int n2 = n;
            int n3 = 0;
            boolean bl2 = true;
            do {
                if (bl2 && !(bl2 = false) && !bl) continue;
                byte by = (byte)((n3 & 0xFF00) >> 8);
                byte by2 = (byte)(n3 & 0xFF);
                byte[] byArray2 = new byte[5];
                byArray2[1] = -80;
                byArray2[2] = by;
                byArray2[3] = by2;
                byte[] byArray3 = byArray2;
                ResponseAPDU responseAPDU = this.sendCommand(byArray3);
                int n4 = responseAPDU.getData().length;
                byte[] byArray4 = responseAPDU.getData();
                System.arraycopy(byArray4, 0, byArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            } while (n2 > 0);
        }
        return byArray;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public void updateBinaryFile(byte[] data) throws AkisException, CardException {
        boolean bl = AbstractAkisCommands.b;
        int n = 0;
        int n2 = data.length;
        boolean bl2 = true;
        do {
            int n3;
            byte[] byArray;
            block4: {
                block3: {
                    if (bl2 && !(bl2 = false) && !bl) continue;
                    byte by = (byte)((n & 0xFF00) >> 8);
                    byte by2 = (byte)(n & 0xFF);
                    byte[] byArray2 = new byte[5];
                    byArray2[1] = -42;
                    byArray2[2] = by;
                    byArray2[3] = by2;
                    byArray = byArray2;
                    n3 = 0;
                    if (n2 <= 196) break block3;
                    n3 = 196;
                    if (!bl) break block4;
                }
                n3 = n2;
            }
            byArray[4] = (byte)n3;
            byte[] byArray3 = new byte[byArray.length + n3];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(data, n, byArray3, byArray.length, n3);
            this.sendCommand(byArray3);
            n += n3;
            n2 -= n3;
        } while (n2 > 0);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public AkisKey[] getKeyInfos() throws AkisException, CardException, UnsupportedVersionException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 31;
        byte[] byArray2 = byArray;
        byte[] byArray3 = this.sendCommand(byArray2).getData();
        int n = byArray3[2];
        int n2 = 5;
        AkisKey[] akisKeyArray = new AkisKey[n];
        int n3 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            byte by = byArray3[n2 + 4 * n3];
            byte by2 = byArray3[n2 + 2 + 4 * n3];
            KeyType keyType = null;
            keyType = (by2 & 0x1F) == 31 ? KeyType.PRIVATE_RSA : ((by2 & 0x60) == 96 ? KeyType.PUBLIC_RSA : KeyType.UNKNOWN);
            akisKeyArray[n3] = new AkisKey(by, keyType);
            ++n3;
        } while (n3 < n);
        return akisKeyArray;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getMaxKeyID() throws AkisException, CardException, UnsupportedVersionException {
        boolean bl = AbstractAkisCommands.b;
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 31;
        byte[] byArray2 = byArray;
        byte by = 0;
        ResponseAPDU responseAPDU = null;
        try {
            responseAPDU = this.sendCommand(byArray2);
        }
        catch (AkisException akisException) {
            if (akisException.getErrorCode() == 25625L) {
                return 0;
            }
            throw akisException;
        }
        byte[] byArray3 = responseAPDU.getData();
        int n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            by = byArray3[n * 4 + 5] > by ? byArray3[n * 4 + 5] : by;
            ++n;
        } while (n < byArray3[2]);
        return by;
    }

    @Override
    public byte[] getPublicExponent(byte keyID) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 31;
        byArray[2] = 64;
        byArray[3] = keyID;
        byte[] byArray2 = byArray;
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        return responseAPDU.getData();
    }

    @Override
    public byte[] getModulus(byte keyID) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 31;
        byArray[2] = 32;
        byArray[3] = keyID;
        byte[] byArray2 = byArray;
        ResponseAPDU responseAPDU = this.sendCommand(byArray2);
        return responseAPDU.getData();
    }

    @Override
    public void writePrivateKey(RSAKeyFields fields, int keyID) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[fields.prime_1.length + 2];
        byArray[0] = -47;
        byArray[1] = (byte)fields.prime_1.length;
        System.arraycopy(fields.prime_1, 0, byArray, 2, fields.prime_1.length);
        this.writeKey(byArray, (byte)-16, keyID);
        byArray = new byte[fields.prime_2.length + 2];
        byArray[0] = -46;
        byArray[1] = (byte)fields.prime_2.length;
        System.arraycopy(fields.prime_2, 0, byArray, 2, fields.prime_2.length);
        this.writeKey(byArray, (byte)-16, keyID);
        byArray = new byte[fields.exponent_1.length + 2];
        byArray[0] = -45;
        byArray[1] = (byte)fields.exponent_1.length;
        System.arraycopy(fields.exponent_1, 0, byArray, 2, fields.exponent_1.length);
        this.writeKey(byArray, (byte)-16, keyID);
        byArray = new byte[fields.exponent_2.length + 2];
        byArray[0] = -44;
        byArray[1] = (byte)fields.exponent_2.length;
        System.arraycopy(fields.exponent_2, 0, byArray, 2, fields.exponent_1.length);
        this.writeKey(byArray, (byte)-16, keyID);
        byArray = new byte[fields.coefficient.length + 2];
        byArray[0] = -43;
        byArray[1] = (byte)fields.coefficient.length;
        System.arraycopy(fields.coefficient, 0, byArray, 2, fields.coefficient.length);
        this.writeKey(byArray, (byte)-16, keyID);
        byArray = new byte[fields.modBytes.length + 2];
        byArray[0] = -41;
        byte[] byArray2 = byArray;
        int n = 1;
        int n2 = fields.modBytes.length > 256 ? 0 : fields.modBytes.length;
        byArray2[n] = (byte)n2;
        System.arraycopy(fields.modBytes, 0, byArray, 2, fields.modBytes.length);
        this.writeKey(byArray, (byte)-16, keyID);
    }

    @Override
    public void writePublicKey(RSAKeyFields fields, int keyID) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray = new byte[fields.public_Exponent.length + 2];
        byArray[0] = -42;
        byte[] byArray2 = byArray;
        int n = 1;
        int n2 = fields.public_Exponent.length == 256 ? 0 : fields.public_Exponent.length;
        byArray2[n] = (byte)n2;
        System.arraycopy(fields.public_Exponent, 0, byArray, 2, fields.public_Exponent.length);
        this.writeKey(byArray, (byte)-16, keyID);
        byArray = new byte[fields.modBytes.length + 2];
        byArray[0] = -41;
        byte[] byArray3 = byArray;
        int n3 = 1;
        int n4 = fields.modBytes.length == 256 ? 0 : fields.modBytes.length;
        byArray3[n3] = (byte)n4;
        System.arraycopy(fields.modBytes, 0, byArray, 2, fields.modBytes.length);
        this.writeKey(byArray, (byte)-16, keyID);
    }

    protected void writeKey(byte[] data, byte type, int keyID) throws AkisException, CardException {
        block9: {
            byte[] byArray;
            block8: {
                boolean bl = AbstractAkisCommands.b;
                byArray = new byte[]{-128, 30, (byte)(keyID | 0x80), type};
                if (data.length <= 230) break block8;
                int n = data.length;
                int n2 = 0;
                do {
                    int n3 = n > 230 ? 230 : n;
                    byte[] byArray2 = new byte[byArray.length + 1 + n3];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    byArray2[byArray.length] = (byte)n3;
                    System.arraycopy(data, n2, byArray2, byArray.length + 1, n3);
                    if (n > 230) {
                        byArray2[0] = (byte)(byArray2[0] | 0x10);
                    }
                    this.sendCommand(byArray2);
                    n2 += n3;
                } while ((n -= 230) > 0);
                if (!bl) break block9;
            }
            byte[] byArray3 = new byte[byArray.length + 1 + data.length];
            byArray3[byArray.length] = (byte)data.length;
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(data, 0, byArray3, byArray.length + 1, data.length);
            this.sendCommand(byArray3);
        }
    }

    @Override
    public void writeBACKey(byte[] key, byte passportKeyProp, byte passportKeyId) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteKey(int keyID) throws AkisException, CardException {
        byte[] byArray = new byte[4];
        byArray[0] = -128;
        byArray[1] = 30;
        byArray[2] = (byte)keyID;
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public void putData(P1P2 params, byte[] data) throws CardException {
        throw new RuntimeException(a[7]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getData(byte mode) throws AkisException, CardException {
        int n;
        byte[] byArray;
        block11: {
            block16: {
                boolean bl;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    bl = AbstractAkisCommands.b;
                                    byte[] byArray2 = new byte[5];
                                    byArray2[1] = -54;
                                    byArray2[2] = 1;
                                    byArray = byArray2;
                                    n = 0;
                                    if (mode != GetDataModes.copyright) break block10;
                                    n = 23;
                                    if (!bl) break block11;
                                }
                                if (mode != GetDataModes.chip) break block12;
                                n = 2;
                                if (!bl) break block11;
                            }
                            if (mode != GetDataModes.atr) break block13;
                            n = 18;
                            if (!bl) break block11;
                        }
                        if (mode != GetDataModes.memory) break block14;
                        n = 11;
                        if (!bl) break block11;
                    }
                    if (mode != GetDataModes.cardType) break block15;
                    n = 1;
                    if (!bl) break block11;
                }
                if (mode != GetDataModes.system) break block16;
                n = 81;
                if (!bl) break block11;
            }
            if (mode == GetDataModes.romCheckSum) {
                n = 2;
            }
        }
        byArray[3] = mode;
        byArray[byArray.length - 1] = n;
        ResponseAPDU responseAPDU = this.sendCommand(byArray);
        return responseAPDU.getData();
    }

    @Override
    protected byte[] getSerialGetData() throws AkisException, CardException {
        byte[] byArray = this.getData(GetDataModes.system);
        byte[] byArray2 = new byte[8];
        if (byArray.length < 69) {
            throw new RuntimeException(a[5]);
        }
        System.arraycopy(byArray, 57, byArray2, 0, 8);
        return byArray2;
    }

    @Override
    protected byte[] getSerialGetDataForActivation() throws AkisException, CardException {
        byte[] byArray;
        block8: {
            byte[] byArray2;
            block7: {
                byArray2 = this.getData(GetDataModes.system);
                byArray = new byte[8];
                if (byArray2.length < 69) {
                    throw new RuntimeException(a[6]);
                }
                if (!this.manufacturer.equals((Object)Manufacturer.INF)) break block7;
                System.arraycopy(byArray2, 59, byArray, 0, 2);
                System.arraycopy(byArray2, 63, byArray, 2, 6);
                if (!AbstractAkisCommands.b) break block8;
            }
            System.arraycopy(byArray2, 61, byArray, 0, 8);
        }
        return byArray;
    }

    @Override
    public int getEmptyMemory() throws AkisException, CardException {
        int n = 0;
        byte[] byArray = this.getData(GetDataModes.system);
        n = 0xFF & byArray[76];
        n <<= 8;
        n += 0xFF & byArray[77];
        n <<= 8;
        return n += 0xFF & byArray[78];
    }

    @Override
    protected byte[] exchangeChallenge(byte[] encryptedRandomNumber) throws AkisException, CardException {
        byte[] byArray = new byte[encryptedRandomNumber.length + 6];
        byArray[0] = -128;
        byArray[1] = -122;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = -128;
        byArray[133] = 16;
        System.arraycopy(encryptedRandomNumber, 0, byArray, 5, encryptedRandomNumber.length);
        ResponseAPDU responseAPDU = this.sendCommand(byArray);
        return responseAPDU.getData();
    }

    @Override
    public void activate(byte[] data) throws CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyInit(byte[] initKey) throws CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyPerso(byte[] persoKey) throws CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void externalAuthenticatePure(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) throws Exception {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] generateMseData(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, AuthenticationType authType) throws Exception {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] getChallenge(int len) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verify(byte[] pin, boolean isMF) throws AkisException, CardException {
        byte[] byArray = new byte[5];
        byArray[1] = 32;
        byArray[3] = -127;
        byte[] byArray2 = byArray;
        if (isMF) {
            byArray2[3] = 1;
        }
        byArray2[4] = (byte)pin.length;
        byte[] byArray3 = new byte[byArray2.length + pin.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(pin, 0, byArray3, byArray2.length, pin.length);
        this.sendCommand(byArray3);
    }

    @Override
    public void verify(byte pinNo, byte[] pin, boolean isMF) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyWithPinPad(byte pinNo, boolean isMF) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    private void a(byte[] byArray, boolean bl, byte[] byArray2, byte[] byArray3) throws AkisException, CardException {
        byte[] byArray4 = new byte[7 + byArray2.length + byArray3.length];
        byte[] byArray5 = new byte[4];
        byArray5[1] = 36;
        byArray5[3] = -127;
        byte[] byArray6 = byArray5;
        if (bl) {
            byArray6[3] = -126;
        }
        byte[] byArray7 = new byte[]{(byte)(byArray3.length + byArray2.length + 2)};
        System.arraycopy(byArray6, 0, byArray4, 0, 4);
        System.arraycopy(byArray7, 0, byArray4, 4, 1);
        byte[] byArray8 = new byte[2];
        byArray8[0] = (byte)byArray2.length;
        System.arraycopy(byArray8, 0, byArray4, 5, 1);
        System.arraycopy(byArray2, 0, byArray4, 6, byArray8[0]);
        byArray8[1] = (byte)byArray3.length;
        System.arraycopy(byArray8, 1, byArray4, 6 + byArray8[0], 1);
        System.arraycopy(byArray3, 0, byArray4, 7 + byArray8[0], byArray8[1]);
        this.selectMF();
        this.selectFileUnderMF(byArray);
        this.sendCommand(byArray4);
    }

    @Override
    public void unlockDFPIN(byte[] fid, byte[] PUK, byte[] newPIN) throws AkisException, CardException {
        byte[] byArray = new byte[7 + newPIN.length + PUK.length];
        byte[] byArray2 = new byte[4];
        byArray2[1] = 44;
        byArray2[3] = -127;
        byte[] byArray3 = byArray2;
        byArray[4] = (byte)(newPIN.length + PUK.length + 2);
        System.arraycopy(byArray3, 0, byArray, 0, 4);
        byte[] byArray4 = new byte[2];
        byArray4[0] = (byte)PUK.length;
        System.arraycopy(byArray4, 0, byArray, 5, 1);
        System.arraycopy(PUK, 0, byArray, 6, byArray4[0]);
        byArray4[1] = (byte)newPIN.length;
        System.arraycopy(byArray4, 1, byArray, 6 + byArray4[0], 1);
        System.arraycopy(newPIN, 0, byArray, 7 + byArray4[0], byArray4[1]);
        this.selectMF();
        this.selectFileUnderMF(fid);
        this.sendCommand(byArray);
    }

    private void a(boolean bl, byte[] byArray, byte[] byArray2, byte[] byArray3) throws AkisException, CardException, UnsupportedVersionException {
        byte[] byArray4 = new byte[7 + byArray2.length + byArray3.length];
        byte[] byArray5 = new byte[4];
        byArray5[1] = 36;
        byArray5[3] = 1;
        byte[] byArray6 = byArray5;
        if (bl) {
            byArray6[3] = 2;
        }
        byte[] byArray7 = new byte[]{(byte)(byArray3.length + byArray2.length + 2)};
        System.arraycopy(byArray6, 0, byArray4, 0, 4);
        System.arraycopy(byArray7, 0, byArray4, 4, 1);
        byte[] byArray8 = new byte[2];
        byArray8[0] = (byte)byArray2.length;
        System.arraycopy(byArray8, 0, byArray4, 5, 1);
        System.arraycopy(byArray2, 0, byArray4, 6, byArray8[0]);
        byArray8[1] = (byte)byArray3.length;
        System.arraycopy(byArray8, 1, byArray4, 6 + byArray8[0], 1);
        System.arraycopy(byArray3, 0, byArray4, 7 + byArray8[0], byArray8[1]);
        this.selectMF();
        this.changePhaseToAdmin(byArray);
        this.sendCommand(byArray4);
    }

    @Override
    public void unlockMFPIN(byte[] PUK, byte[] newPIN) throws AkisException, CardException {
        byte[] byArray = new byte[7 + newPIN.length + PUK.length];
        byte[] byArray2 = new byte[4];
        byArray2[1] = 44;
        byArray2[3] = 1;
        byte[] byArray3 = byArray2;
        byArray[4] = (byte)(newPIN.length + PUK.length + 2);
        System.arraycopy(byArray3, 0, byArray, 0, 4);
        byte[] byArray4 = new byte[2];
        byArray4[0] = (byte)PUK.length;
        System.arraycopy(byArray4, 0, byArray, 5, 1);
        System.arraycopy(PUK, 0, byArray, 6, byArray4[0]);
        byArray4[1] = (byte)newPIN.length;
        System.arraycopy(byArray4, 1, byArray, 6 + byArray4[0], 1);
        System.arraycopy(newPIN, 0, byArray, 7 + byArray4[0], byArray4[1]);
        this.selectMF();
        this.sendCommand(byArray);
    }

    @Override
    public void changeDFPIN(byte[] fid, byte[] oldPIN, byte[] newPIN) throws AkisException, CardException {
        this.a(fid, false, oldPIN, newPIN);
    }

    @Override
    public void changeDFPUK(byte[] fid, byte[] oldPIN, byte[] newPIN) throws AkisException, CardException {
        this.a(fid, true, oldPIN, newPIN);
    }

    @Override
    public void changeMFPIN(byte[] oldPIN, byte[] newPIN) throws AkisException, CardException, UnsupportedVersionException {
        this.a(false, oldPIN, oldPIN, newPIN);
    }

    @Override
    public void changeMFPUK(byte[] mfPIN, byte[] oldPUK, byte[] newPUK) throws AkisException, CardException, UnsupportedVersionException {
        this.a(true, mfPIN, oldPUK, newPUK);
    }

    @Override
    public void mse(byte keyID) throws AkisException, CardException {
        byte[] byArray = new byte[4];
        byArray[1] = 34;
        byArray[2] = -61;
        byArray[3] = keyID;
        byte[] byArray2 = byArray;
        this.sendCommand(byArray2);
    }

    @Override
    public byte[] pso(P1P2 psoMode, byte[] data) throws AkisException, CardException {
        byte[] byArray = new byte[4];
        byArray[1] = 42;
        byArray[2] = psoMode.getp1();
        byArray[3] = psoMode.getp2();
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[byArray2.length + data.length + 2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byArray3[byArray2.length] = (byte)data.length;
        System.arraycopy(data, 0, byArray3, byArray2.length + 1, data.length);
        byArray3[byArray3.length - 1] = 0;
        return this.sendCommand(byArray3).getData();
    }

    @Override
    public byte[] sign(byte[] data, byte keyID) throws AkisException, CardException {
        this.mse(keyID);
        return this.pso(this.pso_param.cds, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decideSecureMessageKeyGeneratingKey() throws AkisException, UnsupportedVersionException {
        byte[] byArray = null;
        if (this.version == Version.V11_UEKAE_INF || this.version == Version.V12_UEKAE_INF || this.version == Version.V12_UEKAE_NXP) {
            byArray = PublicKeys.RSAPubKey1024_Akis12;
        } else if (this.version == Version.V121_UEKAE_INF || this.version == Version.V121_UEKAE_NXP) {
            byArray = PublicKeys.RSAPubKey1024_Akis121;
        } else if (this.version == Version.V122_UEKAE_INF || this.version == Version.V122_UEKAE_NXP) {
            byArray = PublicKeys.RSAPubKey1024_Akis122;
        } else {
            if (this.version != Version.V13_UEKAE_INF) throw new UnsupportedVersionException();
            byArray = PublicKeys.RSAPubKey1024_Akis13;
        }
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(a[1]);
            this.currentSecureMessagingGeneratingKey = keyFactory.generatePublic(x509EncodedKeySpec);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(a[0] + exception.toString());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void generateSecureMessagingKey() throws AkisException, CardException, UnsupportedVersionException {
        boolean bl = AbstractAkisCommands.b;
        Random random = new Random();
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        Cipher cipher = null;
        byte[] byArray2 = new byte[128];
        try {
            cipher = Cipher.getInstance(a[4]);
            cipher.init(1, this.currentSecureMessagingGeneratingKey);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(a[2] + exception.toString());
        }
        byte[] byArray3 = new byte[16];
        byArray3 = this.exchangeChallenge(byArray2);
        if (byArray3 == null) {
            throw new RuntimeException(a[3]);
        }
        int n = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            this.secureMessagingKey_ABA[n] = (byte)(byArray[n] ^ byArray3[n]);
            ++n;
        } while (n < 16);
        n = 0;
        boolean bl3 = true;
        do {
            if (bl3 && !(bl3 = false) && !bl) continue;
            this.secureMessagingKey_ABA[n + 16] = (byte)(byArray[n] ^ byArray3[n]);
            ++n;
        } while (n < 8);
    }

    @Override
    public void generateSecureMessagingKey(String documentNumber, String dateOfBirth, String expireDate) throws AkisException, CardException, UnsupportedVersionException {
        throw new UnsupportedVersionException();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] createEncryptedCommand(byte[] command) throws AkisException {
        int n;
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        boolean bl;
        block47: {
            int n5;
            int n6;
            block53: {
                block52: {
                    int n7;
                    block49: {
                        block51: {
                            block50: {
                                block48: {
                                    block46: {
                                        block43: {
                                            block45: {
                                                block44: {
                                                    block42: {
                                                        block40: {
                                                            block41: {
                                                                bl = AbstractAkisCommands.b;
                                                                n7 = 0;
                                                                n4 = 0;
                                                                n3 = 0;
                                                                n6 = 0;
                                                                n5 = -1;
                                                                if (command.length < 5) break block40;
                                                                if (command.length != 5) break block41;
                                                                n5 = command[command.length - 1];
                                                                if (!bl) break block40;
                                                            }
                                                            if (command.length > 5 && command[4] < command.length - 5) {
                                                                n5 = command[command.length - 1];
                                                            }
                                                        }
                                                        if (command.length > 5 || n5 >= 0) break block42;
                                                        n7 = 0;
                                                        if (!bl) break block43;
                                                    }
                                                    if (command.length > 5 || n5 < 0) break block44;
                                                    n7 = 1;
                                                    if (!bl) break block43;
                                                }
                                                if (command.length <= 5 || n5 >= 0) break block45;
                                                n7 = 2;
                                                if (!bl) break block43;
                                            }
                                            if (command.length > 5 && n5 >= 0) {
                                                n7 = 3;
                                            }
                                        }
                                        byArray = new byte[256];
                                        System.arraycopy(command, 0, byArray, 0, command.length);
                                        byArray[0] = (byte)(byArray[0] | 4);
                                        n2 = 0;
                                        if (n7 != 0) break block46;
                                        n4 = 5;
                                        n2 = command.length;
                                        if (!bl) break block47;
                                    }
                                    if (n7 != 1) break block48;
                                    n4 = 4;
                                    byArray[n4++] = 8;
                                    byArray[n4++] = -106;
                                    byArray[n4++] = 1;
                                    byArray[n4++] = (byte)n5;
                                    n3 = 8;
                                    byArray[n3 + 5] = 0;
                                    n2 = n3 + 6;
                                    if (!bl) break block47;
                                }
                                if (n7 != 2) break block49;
                                n6 = command.length - 5;
                                if ((n6 + 2) % 8 <= 0) break block50;
                                n3 = n6 + 2 + (8 - (n6 + 2) % 8);
                                if (!bl) break block51;
                            }
                            n3 = n6 + 2;
                        }
                        n4 = 4;
                        byArray[n4++] = (byte)n3;
                        byArray[n4++] = -122;
                        byArray[n4++] = (byte)n6;
                        n = 0;
                        boolean bl2 = true;
                        do {
                            if (bl2 && !(bl2 = false) && !bl) continue;
                            byArray[n4 + n] = command[n + 5];
                            ++n;
                        } while (n < n6);
                        n4 += n6;
                        n2 = n3 + 5;
                        if (!bl) break block47;
                    }
                    if (n7 != 3) break block47;
                    n6 = command.length - 6;
                    if ((n6 + 5) % 8 <= 0) break block52;
                    n3 = n6 + 5 + (8 - (n6 + 5) % 8);
                    if (!bl) break block53;
                }
                n3 = n6 + 5;
            }
            n4 = 4;
            byArray[n4++] = (byte)n3;
            byArray[n4++] = -122;
            byArray[n4++] = (byte)n6;
            n = 0;
            boolean bl3 = true;
            do {
                if (bl3 && !(bl3 = false) && !bl) continue;
                byArray[n4 + n] = command[n + 5];
                ++n;
            } while (n < n6);
            n4 += n6;
            byArray[n4++] = -106;
            byArray[n4++] = 1;
            byArray[n4++] = (byte)n5;
            byArray[n4++] = 0;
            n2 = n3 + 6;
        }
        if (n3 > 0) {
            n = n4;
            boolean bl4 = true;
            do {
                if (bl4 && !(bl4 = false) && !bl) continue;
                byArray[n] = 0;
                ++n;
            } while (n < n3 + 5);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 5, byArray2, 0, n3);
            byte[] byArray3 = Crypto.triDes(this.secureMessagingKey_ABA, byArray2, true);
            if (byArray3 == null) {
                return null;
            }
            System.arraycopy(byArray3, 0, byArray, 5, byArray3.length);
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        return byArray4;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] createDecryptedCommand(byte[] response) throws AkisException {
        block27: {
            block26: {
                block29: {
                    block28: {
                        var7_2 = AbstractAkisCommands.b;
                        if (response.length < 3) {
                            return response;
                        }
                        if (response.length % 8 > 2) break block27;
                        var3_3 = new byte[256];
                        var4_4 = null;
                        if (response.length % 8 >= 2) break block28;
                        var2_5 = new byte[response.length - response.length % 8];
                        System.arraycopy(response, 0, var2_5, 0, var2_5.length);
                        var3_3 = Crypto.triDes(this.secureMessagingKey_ABA, var2_5, false);
                        if (!var7_2) break block29;
                    }
                    var2_5 = new byte[response.length - 2];
                    System.arraycopy(response, 0, var2_5, 0, var2_5.length);
                    var3_3 = Crypto.triDes(this.secureMessagingKey_ABA, var2_5, false);
                }
                if (var3_3 != null && var3_3.length != 0) break block26;
                return null;
            }
            var5_7 = 0;
            if (var3_3[0] == -122) {
                var6_8 = var3_3[1] & 255;
                var4_4 = new byte[var6_8 + 2];
                var5_7 = 0;
                if (var7_2) {
                    while (true) {
                        var4_4[var5_7] = var3_3[var5_7 + 2];
                        ++var5_7;
                        continue;
                        break;
                    }
                }
                if (var5_7 < var4_4.length - 2) ** continue;
                if (var3_3[var5_7 + 2] != -103) ** GOTO lbl69
                var4_4[var5_7] = var3_3[var5_7 + 4];
                var4_4[var5_7 + 1] = var3_3[var5_7 + 5];
            } else if (var3_3[0] == -103) {
                var4_4 = new byte[2];
                var5_7 = 0;
                if (var7_2) {
                    while (true) {
                        var4_4[var5_7] = var3_3[var5_7 + 2];
                        ++var5_7;
                        continue;
                        break;
                    }
                }
                if (var5_7 < var4_4.length) ** continue;
            } else {
                var4_4 = new byte[var3_3.length];
                var4_4 = var3_3;
            }
lbl69:
            // 4 sources

            return var4_4;
        }
        var2_6 = new byte[]{response[response.length - 2], response[response.length - 1]};
        return var2_6;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "r^y\u0014mo\u0005*B)C\u0005.\r\u000bK\u0002%H)\u0010K";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 42;
                                break;
                            }
                            case 1: {
                                n8 = 107;
                                break;
                            }
                            case 2: {
                                n8 = 73;
                                break;
                            }
                            case 3: {
                                n8 = 45;
                                break;
                            }
                            default: {
                                n8 = 77;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "x8\b";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "o\u0005*_4Z\u001f B#\n-(D!O\u000fs\r";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "o\u0013*E,D\f,\r\u000eB\n%A,D\f,\r?O\u001f<_#YK\u0007x\u0001f";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "x8\b";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "y\u000e;D,FK'X H\u000e;\r.K\u0005iC\"^K+HmX\u000e(Ic\n,,Ymn\n=LmI\u0004$@,D\u000fi_(^\u001e;C(NK C>_\r/D.C\u000e'YmF\u000e'J9BK-L9KE";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "y\u000e;D,FK'X H\u000e;\r.K\u0005iC\"^K+HmX\u000e(Ic\n,,Ymn\n=LmI\u0004$@,D\u000fi_(^\u001e;C(NK C>_\r/D.C\u000e'YmF\u000e'J9BK-L9KE";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "d\u0004=\r$G\u001b%H O\u0005=H)\n\u0012,Y";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

