/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SILTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSIL;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CRLSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreCRLOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;

    public CertStoreCRLOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(c[12], (Throwable)lE);
            throw new ESYARuntimeException(c[11] + lE.getMessage(), (Throwable)lE);
        }
        this.b = aDepo;
    }

    public DepoSIL readStoreCRL(Long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(c[8]);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            DepoSIL depoSIL = depoVEN.sILOku(aSILNo);
            return depoSIL;
        }
        catch (NotFoundException notFoundException) {
            throw new CertStoreException(aSILNo + c[9], notFoundException);
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + c[7], certStoreException);
        }
    }

    public void writeCRL(ECRL aCRL, Long aDizinNo) throws CertStoreException {
        this.writeCRL(aCRL.getEncoded(), aDizinNo);
    }

    public void writeCRL(byte[] aCRL, Long aDizinNo) throws CertStoreException {
        DepoSIL depoSIL = null;
        try {
            depoSIL = CertStoreUtil.asnCRLTODepoSIL(aCRL);
        }
        catch (Exception exception) {
            throw new CertStoreException(c[42], exception);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoSIL.getValue(), OzneTipi.SIL);
            depoVEN.sILYaz(depoSIL, list, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(c[41], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL() throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            itemSource2 = itemSource = depoVEN.sILListele();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(c[2], certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(c[1], certStoreException2);
                }
            }
        }
        try {
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(c[0], certStoreException);
        }
    }

    public List<ECRL> listCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        int n = CertStoreRootCertificateOps.c;
        ItemSource<DepoSIL> itemSource = this.listStoreCRL(aSAS, aTipler);
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        try {
            DepoSIL depoSIL = (DepoSIL)itemSource.nextItem();
            while (depoSIL != null) {
                arrayList.add(new ECRL(depoSIL.getValue()));
                depoSIL = (DepoSIL)itemSource.nextItem();
                if (n == 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new CertStoreException(exception);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler);
            String string = (String)pair.first();
            List list = (List)pair.second();
            itemSource2 = itemSource = depoVEN.sILListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(c[14], certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(c[13], certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(c[15], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listCRLDirectories(long aSILNo) throws CertStoreException {
        List<DepoDizin> list2;
        if (aSILNo <= 0L) {
            throw new CertStoreException(c[6]);
        }
        try {
            List<DepoDizin> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            list2 = list = ((RsItemSource)depoVEN.sILDizinleriniListele(aSILNo)).toList();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(aSILNo + c[5], certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(aSILNo + c[4], certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + c[3], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCRLFromDirectory(long aSILNo, long aDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(c[16]);
        if (aDizinNo <= 0L) {
            throw new CertStoreException(c[16]);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizindenSILSil(aSILNo, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + c[17] + aDizinNo + c[18], certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + c[17] + aDizinNo + c[18], certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveCRL(long aSILNo, long aEskiDizinNo, long aYeniDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(c[22]);
        if (aEskiDizinNo <= 0L) throw new CertStoreException(c[22]);
        if (aYeniDizinNo <= 0L) {
            throw new CertStoreException(c[22]);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILTasi(aSILNo, aEskiDizinNo, aYeniDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + c[19] + aEskiDizinNo + c[20] + aYeniDizinNo + c[21], certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + c[19] + aEskiDizinNo + c[20] + aYeniDizinNo + c[21], certStoreException);
        }
    }

    public void deleteCRL(long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(c[24]);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILSil(aSILNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aSILNo + c[23], certStoreException);
        }
    }

    public int deleteCRL(CRLSearchTemplate aSAS) throws CertStoreException {
        int n = CertStoreRootCertificateOps.c;
        Long l = aSAS.getDizinNo();
        SILTipi[] sILTipiArray = new SILTipi[]{SILTipi.BASE, SILTipi.DELTA};
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, sILTipiArray);
            String string = (String)pair.first();
            List list = (List)pair.second();
            ItemSource<DepoSIL> itemSource = depoVEN.sILListele(string, list.toArray());
            int n2 = 0;
            DepoSIL depoSIL = (DepoSIL)itemSource.nextItem();
            while (depoSIL != null) {
                block12: {
                    block11: {
                        if (l != null) break block11;
                        n2 += depoVEN.sILSil(depoSIL.getSILNo());
                        if (n == 0) break block12;
                    }
                    n2 += depoVEN.dizindenSILSil(depoSIL.getSILNo(), l);
                }
                depoSIL = (DepoSIL)itemSource.nextItem();
                if (n == 0) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            if (CertStoreException.b) {
                CertStoreRootCertificateOps.c = ++n;
            }
            return n2;
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(c[10], exception);
        }
    }

    private Pair<String, List<Object>> a(CRLSearchTemplate cRLSearchTemplate, SILTipi[] sILTipiArray) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        int n;
        block38: {
            n = CertStoreRootCertificateOps.c;
            stringBuffer = new StringBuffer("");
            arrayList = new ArrayList<Object>();
            stringBuffer.append(c[25]);
            if (sILTipiArray == null || sILTipiArray.length == 0) break block38;
            stringBuffer.append(c[39]);
            stringBuffer.append(c[30]);
            stringBuffer.append("(");
            for (int i = 0; i < sILTipiArray.length - 1; ++i) {
                stringBuffer.append(sILTipiArray[i].getIntValue() + c[29]);
                if (n == 0) continue;
            }
            stringBuffer.append(sILTipiArray[sILTipiArray.length - 1].getIntValue());
            stringBuffer.append(")");
        }
        if (cRLSearchTemplate != null) {
            block41: {
                OzetTipi ozetTipi;
                block39: {
                    block40: {
                        Long l = cRLSearchTemplate.getDizinNo();
                        if (l != null) {
                            stringBuffer.append(c[36]);
                            arrayList.add(l);
                        }
                        byte[] byArray = cRLSearchTemplate.getValue();
                        if (byArray != null) {
                            stringBuffer.append(c[33]);
                            arrayList.add(byArray);
                        }
                        byte[] byArray2 = cRLSearchTemplate.getHash();
                        ozetTipi = cRLSearchTemplate.getHashType();
                        if (byArray2 == null) break block39;
                        stringBuffer.append(c[34]);
                        arrayList.add(OzneTipi.SIL.getIntValue());
                        arrayList.add(byArray2);
                        if (ozetTipi == null) break block40;
                        stringBuffer.append(c[31]);
                        arrayList.add(ozetTipi.getIntValue());
                        if (n == 0) break block41;
                    }
                    stringBuffer.append(c[37]);
                    if (n == 0) break block41;
                }
                if (ozetTipi == null) break block41;
                stringBuffer.append(c[28]);
                arrayList.add(OzneTipi.SIL.getIntValue());
                arrayList.add(ozetTipi.getIntValue());
            }
            byte[] byArray = cRLSearchTemplate.getIssuer();
            if (byArray != null) {
                stringBuffer.append(c[40]);
                arrayList.add(byArray);
            }
            byte[] byArray3 = cRLSearchTemplate.getSILNumber();
            if (byArray3 != null) {
                stringBuffer.append(c[27]);
                arrayList.add(byArray3);
            }
            Date date = cRLSearchTemplate.getPublishedBefore();
            if (date != null) {
                stringBuffer.append(c[38]);
                arrayList.add(date);
            }
            Date date2 = cRLSearchTemplate.getPublishedAfter();
            if (date2 != null) {
                stringBuffer.append(c[26]);
                arrayList.add(date2);
            }
            Date date3 = cRLSearchTemplate.getValidAt();
            if (date3 != null) {
                stringBuffer.append(c[35]);
                arrayList.add(date3);
                arrayList.add(date3);
            }
            byte[] byArray4 = cRLSearchTemplate.getBaseSILNumber();
            if (byArray4 != null) {
                stringBuffer.append(c[32]);
                arrayList.add(byArray4);
            }
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[43];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "R-\t{gO\u0014D7Qtx\b2Gr=\b>Zo*\u000f>Z&\u000e0{\\g,\u0005(]&7\b.Gr-";
        int n2 = -1;
        block50: while (true) {
            char[] cArray;
            block55: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block54: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block54;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block55;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 6;
                                break;
                            }
                            case 1: {
                                n8 = 88;
                                break;
                            }
                            case 2: {
                                n8 = 100;
                                break;
                            }
                            case 3: {
                                n8 = 91;
                                break;
                            }
                            default: {
                                n8 = 52;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "R-\t{gO\u0014D7Qtx\b2Gr=\b>Zo*\u000f>Z&\u000e0{\\g,\u0005(]&7\b.Gr-";
                    n2 = 0;
                    continue block50;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "R-\t{gO\u0014D7Qtx\b2Gr=\b>Zo*\u000f>Z&\u000e0{\\g,\u0005(]&7\b.Gr-";
                    n2 = 1;
                    continue block50;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0014o6D?]|1\n7Qt1D7]u,\u00017Qh1\u00160Qhx2\u000f\u0014n9\u0010:Gox\u000b7Au,\u0011u";
                    n2 = 2;
                    continue block50;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0014o6D?]|1\n7Qt1D7]u,\u00017Qh1\u00160Qhx2\u000f\u0014n9\u0010:Gox\u000b7Au,\u0011u";
                    n2 = 3;
                    continue block50;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0014o6D?]|1\n7Qt1D7]u,\u00017Qh1\u00160Qhx2\u000f\u0014n9\u0010:Gox\u000b7Au,\u0011u";
                    n2 = 4;
                    continue block50;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "H=\u00175Q&\u0011 {Xc*\r{\u0004&<\u00055\u0014d-\u001d._&7\b6Umx\u001e4Fs6\u0000:Po*";
                    n2 = 5;
                    continue block50;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0014i3\u00115At3\u00015\u0014p=\u00162@g:\u00055]&0\u0005/Uu1D4Xs+\u0010.\u001a";
                    n2 = 6;
                    continue block50;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "H=\u00175Q&\u0011 {Xc*\r{\u0004&<\u00055\u0014d-\u001d._&7\b6Umx\u001e4Fs6\u0000:Po*";
                    n2 = 7;
                    continue block50;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0014p=\u00162@g:\u00055]h<\u0005{Vs4\u00115Uk9\u00002\u001a";
                    n2 = 8;
                    continue block50;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "U9\u00067[h9D<[t=D\b}Jx\u00172Xk=D2Gj=\t2Zb=D3Ur9D4Xs+\u0010.\u001a";
                    n2 = 9;
                    continue block50;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "J1\u0017:Zux\u000f4Zr*\u000b7A&:\u0005(Ut1\u00172N(x";
                    n2 = 10;
                    continue block50;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "J1\u0017:Zux\u000f4Zr*\u000b7A&:\u0005(Ut1\u00172N(";
                    n2 = 11;
                    continue block50;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "U9\u00067[h9D<[t=D\b}Jx\u0005)Uk9D(]t9\u00172Zb9D\r`&0\u0005/Uu1D4Xs+\u0010.\u001a";
                    n2 = 12;
                    continue block50;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "U9\u00067[h9D<[t=D\b}Jx\u0005)Uk9D(]t9\u00172Zb9D\r`&0\u0005/Uu1D4Xs+\u0010.\u001a";
                    n2 = 13;
                    continue block50;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "U9\u00067[h9D<[t=D\b}Jx\u0005)Uk9D(]t9\u00172Zb9D\r`&0\u0005/Uu1D4Xs+\u0010.\u001a";
                    n2 = 14;
                    continue block50;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "H=\u00175Q&\u0011 {Xc*\r{\u0004&<\u00055\u0014d-\u001d._&7\b6Umx\u001e4Fs6\u0000:Po*";
                    n2 = 15;
                    continue block50;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0014";
                    n2 = 16;
                    continue block50;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "&6\u000b7A&<\r!]h<\u00015\u0014u1\b2Zo*\u000f>Z&\u000e0{\\g,\u0005(]&7\b.Gr-J\u0002Uv1\b:Z&\u000e0{]u4\u00016Xc*\r{Sc*\r{Uj1\n:Wg3J";
                    n2 = 17;
                    continue block50;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0018&";
                    n2 = 18;
                    continue block50;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "&6\u000b7A&<\r!]h<\u00015\u0014";
                    n2 = 19;
                    continue block50;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "&6\u000b7A&<\r!]h=D/Uu1\n2Fm=\n{bRx\f:@g+\r{[j-\u0017/A(\u0001\u0005+]j9\n{bRx\r(Xc5\b>Fox\u0003>Fox\u00057]h<\ru";
                    n2 = 20;
                    continue block50;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "H=\u00175Q&\u0011 {Xc*\r{\u0004&<\u00055\u0014d-\u001d._&7\b6Umx\u001e4Fs6\u0000:Po*";
                    n2 = 21;
                    continue block50;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "&6\u000b7A&\u000b-\u0017\u0014u1\b2Zo*\u000f>Z&\u000e0{\\g,\u0005(]&7\b.Gr-J\u0002Uv1\b:Z&\u000e0{]u4\u00016Xc*\r{Sc*\r{Uj1\n?](";
                    n2 = 22;
                    continue block50;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "H=\u00175Q&\u0011 {Xc*\r{\u0004&<\u00055\u0014d-\u001d._&7\b6Umx\u001e4Fs6\u0000:Po*";
                    n2 = 23;
                    continue block50;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "7eU";
                    n2 = 24;
                    continue block50;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "&\u0019*\u001f\u0014R0\r(av<\u0005/Q&fY{\u000b&";
                    n2 = 25;
                    continue block50;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "&\u0019*\u001f\u0014U\u0011(\u0015Ak:\u0001)\u0014;x[";
                    n2 = 26;
                    continue block50;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "&\u0019*\u001f\u0014U\u0011(\u0015[&\u0011*{\u001cU\u001d(\u001ewRx+9^c;\u0010\u0015[&\u001e6\u0014y&\u0010%\b|&\u000f,\u001efCxL{{d2\u00018@R!\u0014>\u0014;x[{uH\u001cD\u0013Uu00\"DcxY{\u000b&qM";
                    n2 = 27;
                    continue block50;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "&tD";
                    n2 = 28;
                    continue block50;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "U\u0011(\u000f]v1D\u0012z&";
                    n2 = 29;
                    continue block50;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "&\u0019*\u001f\u0014N9\u00173`\u007f(\u0001{\t&gDr\u001d";
                    n2 = 30;
                    continue block50;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "&\u0019*\u001f\u0014D9\u0017>gO\u0014*.Yd=\u0016{\t&gD";
                    n2 = 31;
                    continue block50;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "&\u0019*\u001f\u0014U\u0011(\rUj-\u0001{\t&gD";
                    n2 = 32;
                    continue block50;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "&\u0019*\u001f\u0014U\u0011(\u0015[&\u0011*{\u001cU\u001d(\u001ewRx+9^c;\u0010\u0015[&\u001e6\u0014y&\u0010%\b|&\u000f,\u001efCxL{{d2\u00018@R!\u0014>\u0014;x[{uH\u001cD\u0013Uu02:Xs=Df\u00149x";
                    n2 = 33;
                    continue block50;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "&\u0019*\u001f\u0014R0\r(av<\u0005/Q&dY{\u000b&\u0019*\u001f\u00149xXf\u0014H=\u001c/av<\u0005/Q&";
                    n2 = 34;
                    continue block50;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "&\u0019*\u001f\u0014U\u0011(\u0015[&\u0011*{\u001cU\u001d(\u001ewRx7\u0012xH7D\u001dfI\u0015D\u001f}\\\u0011*\b}Jx3\u0013qT\u001dD\u001f]|1\n\u0015[&eDd\u0014/";
                    n2 = 35;
                    continue block50;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = "&qM";
                    n2 = 36;
                    continue block50;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = "&\u0019*\u001f\u0014R0\r(av<\u0005/Q&dDd\u0014";
                    n2 = 37;
                    continue block50;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = "&\u0019*\u001f\u0014";
                    n2 = 38;
                    continue block50;
                }
                case 38: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 40;
                    string2 = "&\u0019*\u001f\u0014O+\u0017.Qt\u0016\u00056Q&eDd\u0014";
                    n2 = 39;
                    continue block50;
                }
                case 39: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 41;
                    string2 = "U\u0011({Mg\"\r7]t3\u00015\u0014P\fD3Ur9\u00172\u0014i4\u0011(@sv=:Do4\u00055\u0014P\fD2Gj=\t7Qt1D<Qt1D:Xo6\u00002\u001a";
                    n2 = 40;
                    continue block50;
                }
                case 40: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 42;
                    string2 = "G+\n{Go4D\"Uv1\u00172Zb9\n{Bc*\r/Ud9\n2\u0014\u007f9\u00142Go6\u0005{Wc.\r)]kx\u00172Fg+\r5Pgx\f:@gx\u000b7Au,\u0011";
                    n2 = 41;
                    continue block50;
                }
                case 41: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
        a = LoggerFactory.getLogger(CertStoreCRLOps.class);
    }
}

