/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.attrcert.EAttributeCertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoNitelikSertifikasi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.AttributeCertificateSearchTemplate;

public class CertStoreAttributeCertificateOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;

    public CertStoreAttributeCertificateOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(c[13], (Throwable)lE);
            throw new ESYARuntimeException(c[12], (Throwable)lE);
        }
        this.b = aDepo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Pair<DepoNitelikSertifikasi, DepoSertifika>> listAttributeAndPKICertificates(AttributeCertificateSearchTemplate aTemplate) throws CertStoreException {
        Object object;
        int n = CertStoreRootCertificateOps.c;
        try {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aTemplate);
            String string = (String)pair.first();
            List list = (List)pair.second();
            ItemSource<DepoNitelikSertifikasi> itemSource = depoVEN.nitelikSertifikasiListele(string, list.toArray());
            DepoNitelikSertifikasi depoNitelikSertifikasi = (DepoNitelikSertifikasi)itemSource.nextItem();
            while (depoNitelikSertifikasi != null) {
                object = depoVEN.sertifikaOku(depoNitelikSertifikasi.getSertifikaNo());
                arrayList.add(new Pair((Object)depoNitelikSertifikasi, object));
                depoNitelikSertifikasi = (DepoNitelikSertifikasi)itemSource.nextItem();
                if (n == 0) continue;
            }
            object = arrayList;
            if (this.b.getConn() == null) return object;
        }
        catch (Exception exception) {
            try {
                throw new CertStoreException(c[10], exception);
            }
            catch (Throwable throwable) {
                if (this.b.getConn() == null) throw throwable;
                JDBCUtil.commit(this.b.getConn());
                throw throwable;
            }
        }
        JDBCUtil.commit(this.b.getConn());
        return object;
    }

    public int deleteAttributeCertificates(AttributeCertificateSearchTemplate aTemplate) throws CertStoreException {
        int n = CertStoreRootCertificateOps.c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aTemplate);
            String string = (String)pair.first();
            List list = (List)pair.second();
            ItemSource<DepoNitelikSertifikasi> itemSource = depoVEN.nitelikSertifikasiListele(string, list.toArray());
            int n2 = 0;
            DepoNitelikSertifikasi depoNitelikSertifikasi = (DepoNitelikSertifikasi)itemSource.nextItem();
            while (depoNitelikSertifikasi != null) {
                n2 += depoVEN.nitelikSertifikasiSil(depoNitelikSertifikasi.getNitelikSertifikaNo());
                depoNitelikSertifikasi = (DepoNitelikSertifikasi)itemSource.nextItem();
                if (n == 0) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return n2;
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(c[9], exception);
        }
    }

    public void writeAttributeAndPKICertificate(ECertificate aCer, List<EAttributeCertificate> aAttrCerts, String aX400Name, long aDizinNo) throws CertStoreException {
        int n = CertStoreRootCertificateOps.c;
        DepoSertifika depoSertifika = CertStoreUtil.eSYASertifikaTODepoSertifika(aCer);
        depoSertifika.setX400Address(aX400Name);
        ArrayList<DepoNitelikSertifikasi> arrayList = new ArrayList<DepoNitelikSertifikasi>();
        for (Object object : aAttrCerts) {
            arrayList.add(CertStoreUtil.asnAttributeCertToDepoNitelikSertifikasi(object));
            if (n == 0) continue;
        }
        try {
            Object object;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            object = CertStoreUtil.convertToDepoOzet(aCer.getEncoded(), OzneTipi.SERTIFIKA);
            depoVEN.attributeAndPKICertYaz(depoSertifika, (List<DepoOzet>)object, arrayList, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(c[11], certStoreException);
        }
    }

    private Pair<String, List<Object>> a(AttributeCertificateSearchTemplate attributeCertificateSearchTemplate) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block17: {
            ECertificate eCertificate;
            String string;
            String string2;
            block16: {
                stringBuffer = new StringBuffer("");
                arrayList = new ArrayList<Object>();
                stringBuffer.append(c[8]);
                String string3 = attributeCertificateSearchTemplate.getX500Name();
                if (string3 != null) {
                    stringBuffer.append(c[0]);
                    arrayList.add(string3);
                }
                string2 = attributeCertificateSearchTemplate.getRfc822Name();
                string = attributeCertificateSearchTemplate.getX400Address();
                eCertificate = attributeCertificateSearchTemplate.getCertificate();
                if (string2 != null || string != null) break block16;
                if (eCertificate == null) break block17;
            }
            StringBuffer stringBuffer2 = new StringBuffer("");
            stringBuffer2.append(c[6]);
            stringBuffer2.append(c[5]);
            stringBuffer2.append(c[7]);
            if (string2 != null) {
                stringBuffer2.append(c[1]);
                arrayList.add(string2);
            }
            if (string != null) {
                stringBuffer2.append(c[3]);
                arrayList.add(string);
            }
            if (eCertificate != null) {
                stringBuffer2.append(c[2]);
                arrayList.add(eCertificate.getExtensions().getSubjectKeyIdentifier().getValue());
            }
            stringBuffer2.append(c[4]);
            stringBuffer.append(stringBuffer2);
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "&\u0011l\nsN?N*6t\u0014l\u00002k5\u0002ss9p";
        int n2 = -1;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block25;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 6;
                                break;
                            }
                            case 1: {
                                n8 = 80;
                                break;
                            }
                            case 2: {
                                n8 = 34;
                                break;
                            }
                            case 3: {
                                n8 = 78;
                                break;
                            }
                            default: {
                                n8 = 83;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "&\u0011l\nsC\u0000M='gpn\u0007\u0018Cp\u001dn";
                    n2 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "&\u0011l\nsU%@$6e$i+*O4G 'o6K+!&m\u0002qs";
                    n2 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "&\u0011l\ns^d\u0012~\u0012b4P+ upn\u0007\u0018Cp\u001dn";
                    n2 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "&y";
                    n2 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "U\u0015n\u000b\u0010Rpq+!r9D'8g\u001eMn\u0015T\u001fon\u0000C\u0002v\u0007\u0015O\u001bcn\u0004N\u0015p\u000bs";
                    n2 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "&\u0011l\nsU5P::`9I/\u001dipk\u0000s.";
                    n2 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "7m\u0013";
                    n2 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "7m\u0013";
                    n2 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "U1@\"<h1\u0002)<t5\u0002=6t$K(:m1\u0002=:j9L'!m5Ln\u0005RpJ/'g#Kn<j%Q:&(\tC>:j1Ln\u0005RpK=?c=N+!opE+!opC\":h4K`";
                    n2 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "H9V+?o;\u0002=6t$K(:m1N/!opN' r5N+=o\"I+=&8C:2&?N; r%\f";
                    n2 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "H9V+?o;\u0002=6t$K(:m1Q's\u007f1X'?o\"I+=&\u0006vn;g$C=:&?N; r%\f\u00172v9N/=&\u0006vn:u<G#?c\"Kn4c\"Kn2j9L*:(";
                    n2 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "J9Q/=upI!=r\"M\"&&2C=2t9Q')(";
                    n2 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "J9Q/=upI!=r\"M\"&&2C=2t9Q')(";
                    n2 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
        a = LoggerFactory.getLogger(CertStoreAttributeCertificateOps.class);
    }
}

