/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.util;

import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;

public class ConstantsUtil {
    private static final String[] a;

    public static long convertHashAlgToPKCS11Constant(String aDigestAlg) throws SmartCardException {
        if (aDigestAlg.equals(Algorithms.DIGEST_MD5)) {
            return 528L;
        }
        if (aDigestAlg.equals(Algorithms.DIGEST_RIPEMD160)) {
            return 576L;
        }
        if (aDigestAlg.equals(Algorithms.DIGEST_SHA1)) {
            return 544L;
        }
        if (aDigestAlg.equals(Algorithms.DIGEST_SHA224)) {
            return 597L;
        }
        if (aDigestAlg.equals(Algorithms.DIGEST_SHA256)) {
            return 592L;
        }
        if (aDigestAlg.equals(Algorithms.DIGEST_SHA384)) {
            return 608L;
        }
        if (aDigestAlg.equals(Algorithms.DIGEST_SHA512)) {
            return 624L;
        }
        throw new SmartCardException(a[1] + aDigestAlg);
    }

    public static long convertSymmetricAlgToPKCS11Constant(String aCipherAlg) throws ESYAException {
        block15: {
            block14: {
                block13: {
                    block12: {
                        if (aCipherAlg.equals(Algorithms.CIPHER_AES128_CBC) || aCipherAlg.equals(Algorithms.CIPHER_AES192_CBC)) break block12;
                        if (!aCipherAlg.equals(Algorithms.CIPHER_AES256_CBC)) break block13;
                    }
                    return 4229L;
                }
                if (aCipherAlg.equals(Algorithms.CIPHER_AES128_ECB) || aCipherAlg.equals(Algorithms.CIPHER_AES192_ECB)) break block14;
                if (!aCipherAlg.equals(Algorithms.CIPHER_AES256_ECB)) break block15;
            }
            return 4225L;
        }
        throw new ESYAException(a[0]);
    }

    public static long getMGFAlgorithm(long aHashAlgorithm) throws SmartCardException {
        if (aHashAlgorithm == 544L) {
            return 1L;
        }
        if (aHashAlgorithm == 597L) {
            return 5L;
        }
        if (aHashAlgorithm == 592L) {
            return 2L;
        }
        if (aHashAlgorithm == 608L) {
            return 3L;
        }
        if (aHashAlgorithm == 624L) {
            return 4L;
        }
        throw new SmartCardException(a[2]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "w\u0017y\u0011 U\u00172\f6O\u0014w\u000b=K\u001a2\u001e#E\u0016`\u0016;J\u0014";
        int n2 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block14;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 34;
                                break;
                            }
                            case 1: {
                                n8 = 121;
                                break;
                            }
                            case 2: {
                                n8 = 18;
                                break;
                            }
                            case 3: {
                                n8 = 127;
                                break;
                            }
                            default: {
                                n8 = 79;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "w\u0017y\u0011 U\u00172\u001b&E\u001ca\u000boC\u0015u\u0010=K\rz\u0012u\u0002";
                    n2 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "w\u0017y\u0011 U\u001722\bdYs\u0013(M\u000b{\u000b'O";
                    n2 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

