/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.List;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.SafeSignOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardTemplate;

public class SafeSignTemplate
extends CardTemplate {
    private static List<String> c;

    public SafeSignTemplate() {
        super(CardType.SAFESIGN);
    }

    @Override
    public IPKCS11Ops getPKCS11Ops() {
        if (this.mIslem == null) {
            this.mIslem = new SafeSignOps();
        }
        return this.mIslem;
    }

    @Override
    public List<CK_ATTRIBUTE> getRSAPrivateKeyCreateTemplate(String aKeyLabel, boolean aIsSign, boolean aIsEncrypt) {
        List<CK_ATTRIBUTE> list = super.getRSAPrivateKeyCreateTemplate(aKeyLabel, aIsSign, aIsEncrypt);
        list.add(new CK_ATTRIBUTE(263L, true));
        list.add(new CK_ATTRIBUTE(265L, aIsSign));
        list.add(new CK_ATTRIBUTE(259L, true));
        list.add(new CK_ATTRIBUTE(355L, true));
        list.add(new CK_ATTRIBUTE(357L, true));
        list.add(new CK_ATTRIBUTE(356L, true));
        return list;
    }

    @Override
    public List<CK_ATTRIBUTE> getRSAPublicKeyCreateTemplate(String aKeyLabel, int aModulusBits, BigInteger aPublicExponent, boolean aIsSign, boolean aIsEncrypt) {
        List<CK_ATTRIBUTE> list = super.getRSAPublicKeyCreateTemplate(aKeyLabel, aModulusBits, aPublicExponent, aIsSign, aIsEncrypt);
        list.add(new CK_ATTRIBUTE(262L, true));
        list.add(new CK_ATTRIBUTE(267L, aIsSign));
        list.add(new CK_ATTRIBUTE(355L, true));
        list.add(new CK_ATTRIBUTE(357L, true));
        list.add(new CK_ATTRIBUTE(356L, true));
        return list;
    }

    @Override
    public List<CK_ATTRIBUTE> getRSAPublicKeyImportTemplate(String aLabel, RSAPrivateCrtKey aPrivKey, X509Certificate aCert, boolean aIsSign, boolean aIsEncrypt) {
        byte[] byArray = SafeSignTemplate.toByteArray(aPrivKey.getModulus());
        List<CK_ATTRIBUTE> list = super.getRSAPublicKeyImportTemplate(aLabel, aPrivKey, aCert, aIsSign, aIsEncrypt);
        list.add(new CK_ATTRIBUTE(355L, true));
        list.add(new CK_ATTRIBUTE(357L, true));
        list.add(new CK_ATTRIBUTE(356L, true));
        list.add(new CK_ATTRIBUTE(289L, byArray.length * 8));
        return list;
    }

    @Override
    public List<CK_ATTRIBUTE> getRSAPrivateKeyImportTemplate(String aLabel, RSAPrivateCrtKey aPrivKey, X509Certificate aCert, boolean aIsSign, boolean aIsEncrypt) {
        List<CK_ATTRIBUTE> list = super.getRSAPrivateKeyImportTemplate(aLabel, aPrivKey, aCert, aIsSign, aIsEncrypt);
        list.add(new CK_ATTRIBUTE(355L, true));
        list.add(new CK_ATTRIBUTE(357L, true));
        list.add(new CK_ATTRIBUTE(356L, true));
        return list;
    }

    @Override
    public String[] getATRHashes() {
        return c.toArray(new String[0]);
    }

    public static void addATR(String aATR) {
        c.add(aATR);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        List<String> list = c = new ArrayList<String>();
        String string2 = "\u0018\u0001j2u\u0013s\u00183t\u001as\u001bA\u0002nw\u001dHt\u001dt\u0018Du\u0019\u0001\u0018@w\u001bp\u0018@t\u001b{\u0019@q\u0018\u0000";
        int n = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block15;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 43;
                                break;
                            }
                            case 1: {
                                n7 = 67;
                                break;
                            }
                            case 2: {
                                n7 = 40;
                                break;
                            }
                            case 3: {
                                n7 = 112;
                                break;
                            }
                            default: {
                                n7 = 68;
                            }
                        }
                        cArray4[n6] = (char)(c ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            string = new String(cArray).intern();
            switch (n) {
                default: {
                    list.add(string);
                    list = c;
                    string2 = "\u0018\u0001n1u\u0013s\u00186\u0002\u0013r\u001bA\u0002nw\u001dD\u0005\u001fp\u001c6q\u001bp\u001aCu\u001eu\u001bBw\u0018p\u0019Fq";
                    n = 0;
                    continue block11;
                }
                case 0: {
                    list.add(string);
                    list = c;
                    string2 = "\u0018\u0001jG}\u001fs\u00183t\u0018\u0006\u001bA\u0002nu\u001dEw\u001es\u001c2w\u0019p\u001bIt\u001bsi5";
                    n = 1;
                    continue block11;
                }
                case 1: {
                    list.add(string);
                    list = c;
                    string2 = "\u0018\u0001nHu\u0013s\u00186\u0002\u0013r\u001bA\u0002nw\u001dD\u0005\u001fp\u001c6q\u001bt\u001eCv\u0018w\u001bAp\u0018";
                    n = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        list.add(string);
    }
}

