/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.ISmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SlotInfo;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.PKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.ECSignatureTLVUtil;

public class SmartCard
implements ISmartCard {
    private static Logger a;
    protected CardType mCardType;
    protected Application mApplication;
    protected boolean isFipsEnabled = false;
    protected long mSlotID = -1L;
    protected long mSessionID = -1L;
    private static final String[] b;

    private SmartCard() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
            this.mApplication = Application.ESIGNATURE;
        }
        catch (LE lE) {
            throw new ESYARuntimeException(b[5] + lE.getMessage(), (Throwable)lE);
        }
    }

    public SmartCard(CardType aCardType) throws PKCS11Exception, IOException {
        this(aCardType, Application.ESIGNATURE);
    }

    public SmartCard(CardType aCardType, Application aApplication) throws PKCS11Exception, IOException {
        this();
        a.debug(b[3] + aCardType.getName());
        this.mCardType = aCardType;
        this.mCardType.getCardTemplate().getPKCS11Ops().initialize();
        this.mApplication = aApplication;
    }

    public SmartCard(String aCardTypeName, String smartCardDllName) throws PKCS11Exception, IOException {
        this();
        this.mCardType = CardType.getCardTypeFromName(aCardTypeName);
        if (this.mCardType == CardType.UNKNOWN) {
            this.mCardType = CardType.getCardType(smartCardDllName);
        }
        this.mCardType.getCardTemplate().getPKCS11Ops().initialize();
    }

    public SmartCard(String aCardType) throws PKCS11Exception, IOException {
        this(CardType.getCardType(aCardType));
    }

    public void setFipsMode(boolean mode) {
        this.isFipsEnabled = mode;
    }

    public boolean isFipsModeEnable() {
        return this.isFipsEnabled;
    }

    public void setApplication(Application aApplication) {
        this.mApplication = aApplication;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenPresentSlotList();
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenPresentSlotListWithDescription();
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSlotList();
    }

    public List<SlotInfo> getSlotInfoList() throws PKCS11Exception {
        int n = CardType.b;
        long[] lArray = this.getSlotList();
        ArrayList<SlotInfo> arrayList = new ArrayList<SlotInfo>();
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            CK_TOKEN_INFO cK_TOKEN_INFO = this.getTokenInfo(l);
            SlotInfo slotInfo = new SlotInfo();
            slotInfo.setSlotId(l);
            slotInfo.setSlotLabel(new String(cK_TOKEN_INFO.label).trim());
            arrayList.add(slotInfo);
            if (n == 0) continue;
        }
        return arrayList;
    }

    public long getLatestSlotID() {
        return this.mSlotID;
    }

    public long getLatestSessionID() {
        return this.mSessionID;
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isTokenPresent(aSlotID);
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getMechanismList(aSlotID);
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        long l = this.mCardType.getCardTemplate().getPKCS11Ops().openSession(aSlotID);
        if (l > 0L) {
            this.mSessionID = l;
            this.mSlotID = aSlotID;
        }
        return l;
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().closeSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().login(aSessionID, aCardPIN);
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isAnyObjectExist(aSessionID);
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().importCertificate(aSessionID, aCertLabel, aSertifika);
    }

    @Override
    public void createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        this.mCardType.getCardTemplate().getPKCS11Ops().createKeyPair(aSessionID, aKeyLabel, aParamSpec, aIsSign, aIsEncrypt);
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException, IOException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().createKeyPair(aSessionID, template);
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().generateRSAPrivateKey(aSessionID, keySize);
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().generateECKeyPair(aSessionID, ecParameterSpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] a(CK_MECHANISM cK_MECHANISM, byte[] byArray) throws SmartCardException {
        byte[] byArray2;
        int n = CardType.b;
        if (this.mApplication == Application.EPASSPORT) {
            return byArray;
        }
        if (this.mApplication != Application.ESIGNATURE) {
            throw new SmartCardException(b[4]);
        }
        if (cK_MECHANISM.mechanism != 4161L && cK_MECHANISM.mechanism != 4162L) {
            return byArray;
        }
        if (this.mCardType == CardType.AKIS) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
            if (n == 0) return byArray2;
        }
        if (this.mCardType == CardType.UTIMACO) {
            byArray2 = byArray;
            if (n == 0) return byArray2;
        }
        if (this.mCardType == CardType.NCIPHER) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
            if (n == 0) return byArray2;
        }
        if (this.mCardType == CardType.DIRAKHSM) {
            byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
            if (n == 0) return byArray2;
        }
        if (ECSignatureTLVUtil.isSignatureInTLVFormat(byArray)) return byArray;
        byArray2 = ECSignatureTLVUtil.addTLVToSignature(byArray);
        if (n == 0) return byArray2;
        return byArray;
    }

    @Override
    @Deprecated
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, long aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithCertSerialNo(aSessionID, aSerialNumber, cK_MECHANISM, aToBeSigned);
        byArray = this.a(cK_MECHANISM, byArray);
        return byArray;
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithKeyID(aSessionID, aKeyID, aMechanism, aToBeSigned);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aToBeSigned) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signDataWithCertSerialNo(aSessionID, aSerialNumber, aMechanism, aToBeSigned);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    @Deprecated
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, long aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptDataWithCertSerialNo(aSessionID, aSerialNumber, cK_MECHANISM, aData);
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptDataWithCertSerialNo(aSessionID, aSerialNumber, aMechanism, aData);
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().getCertificates(aSessionID);
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSignatureCertificates(aSessionID);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getEncryptionCertificates(aSessionID);
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getSignatureKeyLabels(aSessionID);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
    }

    @Override
    public long getPrivateKeyObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getObjIDFromPrivateKeyLabel(aSessionID, aLabel);
    }

    @Override
    public long getPublicKeyObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getObjIDFromPublicKeyLabel(aSessionID, aLabel);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getEncryptionKeyLabels(aSessionID);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getWrapperKeyLabels(aSessionID);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getUnwrapperKeyLabels(aSessionID);
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isObjectExist(aSessionID, aLabel);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().writePrivateData(aSessionID, aLabel, aData);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().writePublicData(aSessionID, aLabel, aData);
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPrivateData(aSessionID, aLabel);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicData(aSessionID, aLabel);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isPublicKeyExist(aSessionID, aLabel);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isPrivateKeyExist(aSessionID, aLabel);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().isCertificateExist(aSessionID, aLabel);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readCertificate(aSessionID, aLabel);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readCertificate(aSessionID, aCertSerialNo);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicKeySpec(aSessionID, aLabel);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().readPublicKeySpec(aSessionID, aCertSerialNo);
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().updatePrivateData(aSessionID, aLabel, aValue);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().updatePublicData(aSessionID, aLabel, aValue);
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePrivateObject(aSessionID, aLabel);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePublicObject(aSessionID, aLabel);
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePrivateData(aSessionID, aLabel);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().deletePublicData(aSessionID, aLabel);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getRandomData(aSessionID, aDataLength);
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getTokenSerialNo(aSlotID);
    }

    @Override
    @Deprecated
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, long aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signData(aSessionID, aKeyLabel, aToBeSigned, cK_MECHANISM);
        byArray = this.a(cK_MECHANISM, byArray);
        return byArray;
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signData(aSessionID, aKeyLabel, aToBeSigned, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aToBeSigned, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().signAndRecoverData(aSessionID, aKeyLabel, aToBeSigned, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignedData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        byte[] byArray = this.mCardType.getCardTemplate().getPKCS11Ops().verifyAndRecoverData(aSessionID, aKeyLabel, aSignedData, aMechanism);
        byArray = this.a(aMechanism, byArray);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aSignature, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        byte[] byArray = this.decodeSignatureIfItIsEC(aSessionID, aKeyLabel, cK_MECHANISM, aSignature);
        this.mCardType.getCardTemplate().getPKCS11Ops().verifyData(aSessionID, aKeyLabel, aData, byArray, aMechanism);
    }

    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.decodeSignatureIfItIsEC(aSessionID, aKeyLabel, aMechanism, aSignature);
        this.mCardType.getCardTemplate().getPKCS11Ops().verifyData(aSessionID, aKeyLabel, aData, byArray, aMechanism);
    }

    public byte[] decodeSignatureIfItIsEC(long aSessionID, String aKeyLabel, CK_MECHANISM mech, byte[] aSignature) {
        block5: {
            if (mech.mechanism != 4161L && mech.mechanism != 4162L) break block5;
            try {
                if (ECSignatureTLVUtil.isSignatureInTLVFormat(aSignature)) {
                    ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)this.readPublicKeySpec(aSessionID, aKeyLabel);
                    int n = eCPublicKeySpec.getParams().getOrder().bitLength();
                    return ECSignatureTLVUtil.removeTLVFromSignature(aSignature, n);
                }
                return aSignature;
            }
            catch (Exception exception) {
                a.error(exception.toString(), (Throwable)exception);
                return aSignature;
            }
        }
        return aSignature;
    }

    @Override
    @Deprecated
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyLabel, aData, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().encryptData(aSessionID, aKeyLabel, aData, aMechanism);
    }

    @Override
    @Deprecated
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, long aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyLabel, aData, cK_MECHANISM);
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        SmartCard.checkLicense();
        return this.mCardType.getCardTemplate().getPKCS11Ops().decryptData(aSessionID, aKeyLabel, aData, aMechanism);
    }

    @Override
    public void importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKey(aSessionID, aCertLabel, aKeyLabel, aPrivKey, aCert);
    }

    @Override
    @Deprecated
    public void importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importKeyPair(aSessionID, aLabel, aKeyPair, aSubject, aIsSign, aIsEncrypt);
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().changePassword(aOldPass, aNewPass, aSessionID);
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().formatToken(aSOpin, aNewPIN, aLabel, slotID);
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionHandle) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().setSOPin(aSOPin, aNewSOPin, aSessionHandle);
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionHandle) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().changeUserPin(aSOPin, aUserPin, aSessionHandle);
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionHandle) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().setContainer(aContainerLabel, aSessionHandle);
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertificate, aSignOrEnc);
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertificate, int aSignOrEnc) {
        return this.mCardType.getCardTemplate().getPKCS11Ops().importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertificate, aSignOrEnc);
    }

    @Override
    public void createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().createSecretKey(aSessionID, aKey);
    }

    @Override
    public void importSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().importSecretKey(aSessionID, aKey);
    }

    public void importSecretKey(long aSessionID, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importSecretKey(aSessionID, aKeyTemplate);
    }

    private void a(long l, List<String> list) throws PKCS11Exception, SmartCardException {
        this.deletePrivateObject(l, list.get(0));
        this.deletePrivateObject(l, list.get(1));
    }

    protected static CardType findCardType(String aATRHex, Application aApp) {
        return CardType.getCardTypeFromATR(aATRHex, aApp);
    }

    @Override
    public CardType getKartTipi() {
        return this.mCardType;
    }

    @Override
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().objeAra(aSessionID, aTemplate);
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mCardType.getCardTemplate().getPKCS11Ops().getAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().changeLabel(aSessionID, aOldLabel, aNewLabel);
    }

    public static void checkLicense() {
        try {
            boolean bl = LV.getInstance().isTL(LV.Urunler.AKILLIKART);
            if (bl) {
                a.debug(b[6]);
                Thread.sleep(2000L);
            }
        }
        catch (LE lE) {
            throw new ESYARuntimeException(b[7] + lE.getMessage(), (Throwable)lE);
        }
        catch (InterruptedException interruptedException) {
            throw new ESYARuntimeException(b[8], (Throwable)interruptedException);
        }
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws SmartCardException, PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().getModulusOfKey(aSessionID, aObjID);
    }

    @Override
    public byte[] wrapKey(long sessionID, CK_MECHANISM mechanism, String wrapperKeyLabel, String labelOfKeyToWrap) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().wrapKey(sessionID, mechanism, wrapperKeyLabel, labelOfKeyToWrap);
    }

    @Override
    public byte[] wrapKey(long sessionID, CK_MECHANISM mechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate wrappingKeyTemplate) throws PKCS11Exception, SmartCardException {
        return this.mCardType.getCardTemplate().getPKCS11Ops().wrapKey(sessionID, mechanism, wrapperKeyTemplate, wrappingKeyTemplate);
    }

    @Override
    public void unwrapKey(long sessionID, CK_MECHANISM mechanism, String unwrapperKeyLabel, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, unwrapperKeyLabel, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public void unwrapKey(long sessionID, CK_MECHANISM mechanism, KeyTemplate unwrapperKeyTemplate, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, unwrapperKeyTemplate, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public void unwrapKey(long sessionID, CK_MECHANISM mechanism, byte[] certSerialNumber, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().unwrapKey(sessionID, mechanism, certSerialNumber, wrappedKey, unwrappedKeyTemplate);
    }

    @Override
    public CardType getCardType() {
        return this.mCardType;
    }

    @Override
    public void importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().importKeyPair(sessionID, template);
    }

    @Override
    public void createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        this.mCardType.getCardTemplate().getPKCS11Ops().createSecretKey(sessionID, template);
    }

    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        return this.mCardType.getCardTemplate().getPKCS11Ops().deleteCertificate(aSessionID, aKeyLabel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSupportsWrapUnwrap(long sessionId) {
        PKCS11Ops pKCS11Ops;
        boolean bl;
        block5: {
            bl = true;
            pKCS11Ops = (PKCS11Ops)this.getCardType().getCardTemplate().getPKCS11Ops();
            try {
                pKCS11Ops.getmPKCS11().C_WrapKey(sessionId, new CK_MECHANISM(1L), -1L, -1L);
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.warn(b[0], (Throwable)pKCS11Exception);
                if (pKCS11Exception.getErrorCode() != 84L) break block5;
                bl = false;
            }
        }
        if (!bl) return bl;
        try {
            pKCS11Ops.getmPKCS11().C_UnwrapKey(sessionId, new CK_MECHANISM(1L), -1L, b[1].getBytes(), null);
            return bl;
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.warn(b[2], (Throwable)pKCS11Exception);
            if (pKCS11Exception.getErrorCode() != 84L) return bl;
            return false;
        }
    }

    public PKCS11 getPKCS11() {
        return ((PKCS11Ops)this.getCardType().getCardTemplate().getPKCS11Ops()).getmPKCS11();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0006>5>\u0000?8g9\u0007q\f*1\u001b%\u001c&\"\r";
        int n2 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block20;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 81;
                                break;
                            }
                            case 1: {
                                n8 = 95;
                                break;
                            }
                            case 2: {
                                n8 = 71;
                                break;
                            }
                            case 3: {
                                n8 = 80;
                                break;
                            }
                            default: {
                                n8 = 105;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "%:4$";
                    n2 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0006>5>\u0000?8g9\u0007q\f*1\u001b%\u001c&\"\r";
                    n2 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0012>54=(/\"jI";
                    n2 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u00041,>\u0006&1g\u0011\u0019!3.3\b%6(>I705p=\u001d\tg6\u0006#2&$";
                    n2 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u001d641\u0007\"\u007f,?\u0007%-(<\u001cq=&#\b#649\u0013\u007f\u007f";
                    n2 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0005:4$I=641\u0007\"\u016ekp\b:\u016e+<\u0158q4&\"\u001dq6\u0118<\f<3\"\"\u0000?;\"p\u000e4<.;\u00044\u007f>1\u013601&3\b:q";
                    n2 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u001d641\u0007\"\u007f,?\u0007%-(<\u001cq=&#\b#649\u0013\u007f\u007f";
                    n2 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u001d641\u0007\"\u007f,?\u0007%-(<\u001cq,.\"\b\"6)4\bq6)$\f#-2 I03.>\r8q";
                    n2 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        b = stringArray3;
        a = LoggerFactory.getLogger(SmartCard.class);
    }
}

