/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.BaseSmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.LoginException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.SCSignerWithCertSerialNo;

public class P11SmartCard
implements BaseSmartCard {
    private static Logger a;
    protected SmartCard sc;
    protected long slot;
    protected long session;
    private static final String[] b;

    public P11SmartCard(CardType aCardType) throws PKCS11Exception, IOException {
        this.sc = new SmartCard(aCardType);
    }

    @Override
    public void openSession(long aSlotID) throws SmartCardException {
        try {
            this.slot = aSlotID;
            this.session = this.sc.openSession(aSlotID);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception.getMessage(), pKCS11Exception);
        }
    }

    @Override
    public List<byte[]> getSignatureCertificates() throws SmartCardException {
        try {
            return this.sc.getSignatureCertificates(this.session);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception.getMessage(), pKCS11Exception);
        }
    }

    @Override
    public List<byte[]> getEncryptionCertificates() throws SmartCardException {
        try {
            return this.sc.getEncryptionCertificates(this.session);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception.getMessage(), pKCS11Exception);
        }
    }

    @Override
    public void login(String aCardPIN) throws SmartCardException, LoginException {
        try {
            this.sc.login(this.session, aCardPIN);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 160L) {
                try {
                    CK_TOKEN_INFO cK_TOKEN_INFO = this.sc.getTokenInfo(this.slot);
                    if ((cK_TOKEN_INFO.flags & 0x20000L) == 131072L) {
                        throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN_FINAL_TRY, new String[0]), pKCS11Exception, true, false);
                    }
                }
                catch (PKCS11Exception pKCS11Exception2) {
                    a.error(b[1], (Throwable)pKCS11Exception2);
                }
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN, new String[0]), pKCS11Exception, false, false);
            }
            if (pKCS11Exception.getErrorCode() == 164L) {
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.PIN_LOCKED, new String[0]), pKCS11Exception, false, true);
            }
            if (pKCS11Exception.getErrorCode() != 256L) {
                throw new SmartCardException(pKCS11Exception.getMessage(), pKCS11Exception);
            }
        }
    }

    @Override
    public void logout() throws SmartCardException {
        try {
            this.sc.logout(this.session);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception.getMessage(), pKCS11Exception);
        }
    }

    @Override
    public boolean isSessionActive() {
        try {
            this.getSignatureCertificates();
            return true;
        }
        catch (Exception exception) {
            a.warn(b[0], (Throwable)exception);
            return false;
        }
    }

    @Override
    public byte[] getSerial() throws SmartCardException {
        try {
            String string = new String(this.sc.getTokenInfo((long)this.slot).serialNumber).trim();
            return StringUtil.toByteArray((String)string);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception.getMessage(), pKCS11Exception);
        }
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg) throws SmartCardException {
        return new SCSignerWithCertSerialNo(this.sc, this.session, this.slot, aCert.getSerialNumber().toByteArray(), aSigningAlg);
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg, AlgorithmParameterSpec aParams) throws SmartCardException {
        return new SCSignerWithCertSerialNo(this.sc, this.session, this.slot, aCert.getSerialNumber().toByteArray(), aSigningAlg, aParams);
    }

    public SmartCard getSmartCard() {
        return this.sc;
    }

    @Override
    public void closeSession() throws SmartCardException {
        try {
            this.sc.closeSession(this.session);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception);
        }
    }

    @Override
    public byte[] getSerial(long aSlotID) throws SmartCardException {
        try {
            String string = new String(this.sc.getTokenInfo((long)aSlotID).serialNumber);
            return StringUtil.toByteArray((String)string);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception.getMessage(), pKCS11Exception);
        }
    }

    public long getSlotNo() {
        return this.slot;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u000fT|\u0018o6R.\u001fhxe?GU5T|\u0002E9Gj";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 88;
                                break;
                            }
                            case 1: {
                                n8 = 53;
                                break;
                            }
                            case 2: {
                                n8 = 14;
                                break;
                            }
                            case 3: {
                                n8 = 118;
                                break;
                            }
                            default: {
                                n8 = 6;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\fZe\u0013h\u0011[h\u0019&9Y\u013f\u0018g5Tj\u0147";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        b = stringArray3;
        a = LoggerFactory.getLogger(P11SmartCard.class);
    }
}

