/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.smartcard.config.CardTypeConfig;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AEPTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ATIKHSMTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AcsTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AkisTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AladdinTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.AtikKGTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardosTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.DataKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.DefaultCardTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.DirakHSMTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.GemPlusTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.KeyCorpTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.NCipherTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.SafeSignTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.SafenetTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.SefirotTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.TKartTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.UtimacoTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.UtimacoTemplateR2;

public class CardType
implements Serializable {
    protected static Map<String, CardType> cards;
    protected static Map<String, List<String>> cardATRs;
    public static final String JVM_BITSIZE;
    public static final CardType AKIS;
    public static final CardType AKIS_KK;
    public static final CardType CARDOS;
    public static final CardType ACS;
    public static final CardType ALADDIN;
    public static final CardType DATAKEY;
    public static final CardType GEMPLUS;
    public static final CardType KEYCORP;
    public static final CardType NCIPHER;
    public static final CardType SAFESIGN;
    public static final CardType SEFIROT;
    public static final CardType AEPKEYPER;
    public static final CardType UTIMACO;
    public static final CardType UTIMACO_R2;
    public static final CardType TKART;
    public static final CardType ATIKKG;
    public static final CardType SAFENET;
    public static final CardType ATIKHSM;
    public static final CardType DIRAKHSM;
    public static final CardType OPENDNSSOFTHSM;
    public static final CardType NETID;
    public static final CardType UNKNOWN;
    private static Logger a;
    protected String name;
    protected ICardTemplate template;
    protected String libName;
    protected String libNamex32;
    protected String libNamex64;
    protected boolean supportsWrapUnwrap;
    protected Class<? extends CardTemplate> templateClass;
    protected Application app;
    public static int b;
    private static final String[] c;

    public CardType(String aLibName, String aName) {
        this.libName = aLibName;
        this.libNamex32 = aLibName;
        this.libNamex64 = aLibName;
        this.name = aName;
        this.template = new DefaultCardTemplate(this);
        cards.put(this.name, this);
    }

    public CardType(String aLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp) {
        this.libNamex32 = aLibName;
        this.libNamex64 = aLibName;
        this.libName = aLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        cards.put(this.name, this);
    }

    public CardType(String a32BitLibName, String a64BitLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp) {
        this.libNamex32 = a32BitLibName;
        this.libNamex64 = a64BitLibName;
        this.libName = JVM_BITSIZE.equals(c[6]) ? a32BitLibName : a64BitLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        cards.put(this.name, this);
    }

    public CardType(String a32BitLibName, String a64BitLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp, boolean supportsWrapUnwrap) {
        this.libNamex32 = a32BitLibName;
        this.libNamex64 = a64BitLibName;
        this.libName = JVM_BITSIZE.equals(c[1]) ? a32BitLibName : a64BitLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        this.supportsWrapUnwrap = supportsWrapUnwrap;
        cards.put(this.name, this);
    }

    public CardType(String aLibName, Class<? extends CardTemplate> aTemplateClass, String aName, Application aApp, boolean supportsWrapUnwrap) {
        this.libNamex32 = aLibName;
        this.libNamex64 = aLibName;
        this.libName = aLibName;
        this.templateClass = aTemplateClass;
        this.name = aName;
        this.app = aApp;
        this.supportsWrapUnwrap = supportsWrapUnwrap;
        cards.put(this.name, this);
    }

    public String getLibNamex64() {
        return this.libNamex64;
    }

    private CardType(CardTypeConfig cardTypeConfig) {
        this.a(cardTypeConfig.getLib(), cardTypeConfig.getLib32(), cardTypeConfig.getLib64());
        this.templateClass = DefaultCardTemplate.class;
        this.name = cardTypeConfig.getName();
        this.app = Application.ESIGNATURE;
        cards.put(this.name, this);
    }

    private void a(String string, String string2, String string3) {
        block9: {
            block8: {
                this.libName = string;
                this.libNamex32 = string2;
                this.libNamex64 = string3;
                if (string2 == null || !JVM_BITSIZE.equals(c[3])) break block8;
                this.libName = string2;
            }
            if (string3 == null || !JVM_BITSIZE.equals(c[4])) break block9;
            this.libName = string3;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLibName() {
        return this.libName;
    }

    public boolean isSupportsWrapUnwrap() {
        return this.supportsWrapUnwrap;
    }

    public void setSupportsWrapUnwrap(boolean supportsWrapUnwrap) {
        this.supportsWrapUnwrap = supportsWrapUnwrap;
    }

    public synchronized ICardTemplate getCardTemplate() {
        if (this.template == null) {
            try {
                Constructor<? extends CardTemplate> constructor = this.templateClass.getConstructor(null);
                this.template = constructor.newInstance(null);
            }
            catch (Exception exception) {
                a.debug(c[5], (Throwable)exception);
                try {
                    Constructor<? extends CardTemplate> constructor = this.templateClass.getConstructor(CardType.class);
                    this.template = constructor.newInstance(this);
                }
                catch (Exception exception2) {
                    throw new ESYARuntimeException((Throwable)exception2);
                }
            }
        }
        return this.template;
    }

    public static CardType[] getCardTypes() {
        return cards.values().toArray(new CardType[cards.size()]);
    }

    public static CardType getCardTypeFromATR(String aATRHex, Application aApp) {
        block19: {
            block20: {
                int n = b;
                for (CardType cardType : cards.values()) {
                    if (cardType.getApplication().equals((Object)aApp)) {
                        List<String> list = cardATRs.get(cardType.getName());
                        if (list != null) {
                            for (String runtimeException : list) {
                                if (runtimeException.equalsIgnoreCase(aATRHex)) {
                                    return cardType;
                                }
                                if (n == 0) continue;
                            }
                        }
                        String[] stringArray = null;
                        try {
                            stringArray = cardType.getCardTemplate().getATRHashes();
                        }
                        catch (RuntimeException runtimeException) {
                            a.error(c[0], (Throwable)runtimeException);
                        }
                        if (stringArray == null) {
                            continue;
                        }
                        for (String string : stringArray) {
                            if (!string.equalsIgnoreCase(aATRHex)) continue;
                            return cardType;
                        }
                    }
                    if (n == 0) continue;
                }
                if (!AkisTemplate.isAkisATR(aATRHex)) break block19;
                if (aApp != Application.TCKK) break block20;
                return AKIS_KK;
            }
            return AKIS;
        }
        return UNKNOWN;
    }

    public static CardType getCardType(String aLibName) {
        int n = b;
        for (CardType cardType : cards.values()) {
            block15: {
                block14: {
                    block13: {
                        if (cardType.getLibName() == null || !cardType.getLibName().equals(aLibName)) break block13;
                        return cardType;
                    }
                    if (cardType.getLibNamex64() == null || !cardType.getLibNamex64().equals(aLibName)) break block14;
                    return cardType;
                }
                if (cardType.getLibNamex32() == null || !cardType.getLibNamex32().equals(aLibName)) break block15;
                return cardType;
            }
            if (n == 0) continue;
        }
        return UNKNOWN;
    }

    public static CardType getCardTypeFromName(String aCardName) {
        int n = b;
        for (CardType cardType : cards.values()) {
            if (cardType.getName().equals(aCardName)) {
                return cardType;
            }
            if (n == 0) continue;
        }
        return UNKNOWN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void applyCardTypeConfig(List<CardTypeConfig> config) {
        int n = b;
        for (CardTypeConfig cardTypeConfig : config) {
            block5: {
                block4: {
                    if (!cards.containsKey(cardTypeConfig.getName())) break block4;
                    CardType cardType = cards.get(cardTypeConfig.getName());
                    cardType.a(cardTypeConfig.getLib(), cardTypeConfig.getLib32(), cardTypeConfig.getLib64());
                    cardType.getCardTemplate().getATRHashes();
                    cardATRs.put(cardType.getName(), cardTypeConfig.getAtrs());
                    if (n == 0) break block5;
                }
                new CardType(cardTypeConfig);
            }
            if (n == 0) continue;
        }
    }

    public String toString() {
        return this.getName();
    }

    public Application getApplication() {
        return this.app;
    }

    public static void main(String[] args) {
        CardType[] cardTypeArray;
        int n = b;
        for (CardType cardType : cardTypeArray = CardType.getCardTypes()) {
            if (n == 0) continue;
        }
        System.out.println(CardType.getCardType(c[2]));
    }

    public String getLibNamex32() {
        return this.libNamex32;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block77: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block76: {
                String string;
                String[] stringArray = new String[54];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n4 = 0;
                String string2 = "f9t+hJ,:ht@9nn&F9ho&Q=w{jD,\u007f";
                int n5 = -1;
                block67: while (true) {
                    char[] cArray3;
                    block75: {
                        int n6;
                        int n7;
                        char[] cArray4;
                        block74: {
                            char[] cArray5 = string2.toCharArray();
                            n3 = 0;
                            int n8 = cArray5.length;
                            cArray4 = cArray5;
                            n7 = n8;
                            if (n8 <= 1) break block74;
                            cArray3 = cArray4;
                            n6 = n7;
                            if (n7 <= n3) break block75;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n9 = n3;
                            while (true) {
                                int n10;
                                char c = cArray6[n9];
                                switch (n3 % 5) {
                                    case 0: {
                                        n10 = 37;
                                        break;
                                    }
                                    case 1: {
                                        n10 = 88;
                                        break;
                                    }
                                    case 2: {
                                        n10 = 26;
                                        break;
                                    }
                                    case 3: {
                                        n10 = 11;
                                        break;
                                    }
                                    default: {
                                        n10 = 6;
                                    }
                                }
                                cArray6[n9] = (char)(c ^ n10);
                                ++n3;
                                cArray4 = cArray7;
                                n7 = n7;
                                if (n7 != 0) break;
                                cArray7 = cArray4;
                                n6 = n7;
                                n9 = n7;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n6 = n7;
                        } while (n7 > n3);
                    }
                    string = new String(cArray3);
                    switch (n5) {
                        default: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 1;
                            string2 = "\u0016j";
                            n5 = 0;
                            continue block67;
                        }
                        case 0: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 2;
                            string2 = "F+(TvN;i:7";
                            n5 = 1;
                            continue block67;
                        }
                        case 1: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 3;
                            string2 = "\u0016j";
                            n5 = 2;
                            continue block67;
                        }
                        case 2: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 4;
                            string2 = "\u0013l";
                            n5 = 3;
                            continue block67;
                        }
                        case 3: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 5;
                            string2 = "a=x~a\u00051t+ED*~_\u007fU=";
                            n5 = 4;
                            continue block67;
                        }
                        case 4: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 6;
                            string2 = "\u0016j";
                            n5 = 5;
                            continue block67;
                        }
                        case 5: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 7;
                            string2 = "D=n{mV++";
                            n5 = 6;
                            continue block67;
                        }
                        case 6: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 8;
                            string2 = "p\fSFGf\u0017EY4";
                            n5 = 7;
                            continue block67;
                        }
                        case 7: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 9;
                            string2 = "d\fS@Mb";
                            n5 = 8;
                            continue block67;
                        }
                        case 8: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 10;
                            string2 = "F+(TvN;i:7";
                            n5 = 9;
                            continue block67;
                        }
                        case 9: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 11;
                            string2 = "F3tmgV,7=2";
                            n5 = 10;
                            continue block67;
                        }
                        case 10: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 12;
                            string2 = "F5j:7";
                            n5 = 11;
                            continue block67;
                        }
                        case 11: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 13;
                            string2 = "U3yx7\u0014+|y";
                            n5 = 12;
                            continue block67;
                        }
                        case 12: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 14;
                            string2 = "L1~{7\u0014";
                            n5 = 13;
                            continue block67;
                        }
                        case 13: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 15;
                            string2 = "D3sxv\u0014i";
                            n5 = 14;
                            continue block67;
                        }
                        case 14: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 16;
                            string2 = "p\u0016QEIr\u0016";
                            n5 = 15;
                            continue block67;
                        }
                        case 15: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 17;
                            string2 = "d\u0013SXYn\u0013";
                            n5 = 16;
                            continue block67;
                        }
                        case 16: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 18;
                            string2 = "q\u0013[YR";
                            n5 = 17;
                            continue block67;
                        }
                        case 17: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 19;
                            string2 = "p\fSFGf\u0017";
                            n5 = 18;
                            continue block67;
                        }
                        case 18: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 20;
                            string2 = "A3y`4\u0015i";
                            n5 = 19;
                            continue block67;
                        }
                        case 19: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 21;
                            string2 = "v\u0019\\NH`\f";
                            n5 = 20;
                            continue block67;
                        }
                        case 20: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 22;
                            string2 = "P0ifvN;i:7";
                            n5 = 21;
                            continue block67;
                        }
                        case 21: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 23;
                            string2 = "V7|\u007fnV5(";
                            n5 = 22;
                            continue block67;
                        }
                        case 22: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 24;
                            string2 = "D;uxvN;i:7";
                            n5 = 23;
                            continue block67;
                        }
                        case 23: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 25;
                            string2 = "v\u0019\\NUl\u001fT";
                            n5 = 24;
                            continue block67;
                        }
                        case 24: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 26;
                            string2 = "a\u0019NJM`\u0001";
                            n5 = 25;
                            continue block67;
                        }
                        case 25: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 27;
                            string2 = "n\u001dCHIw\b";
                            n5 = 26;
                            continue block67;
                        }
                        case 26: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 28;
                            string2 = "k=n&Oa";
                            n5 = 27;
                            continue block67;
                        }
                        case 27: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 29;
                            string2 = "d\u0014[OBl\u0016";
                            n5 = 28;
                            continue block67;
                        }
                        case 28: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 30;
                            string2 = "k\u001bS[N`\n";
                            n5 = 29;
                            continue block67;
                        }
                        case 29: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 31;
                            string2 = "d\fS@Nv\u0015";
                            n5 = 30;
                            continue block67;
                        }
                        case 30: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 32;
                            string2 = "F+E{mF++:Ywj";
                            n5 = 31;
                            continue block67;
                        }
                        case 31: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 33;
                            string2 = "Q;q`v\u0014i";
                            n5 = 32;
                            continue block67;
                        }
                        case 32: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 34;
                            string2 = "j\b_EBk\u000bINE\u0005\u000bUMRm\u000bW}4";
                            n5 = 33;
                            continue block67;
                        }
                        case 33: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 35;
                            string2 = "V1\u007fhgUi+";
                            n5 = 34;
                            continue block67;
                        }
                        case 34: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 36;
                            string2 = "d\u0013SX";
                            n5 = 35;
                            continue block67;
                        }
                        case 35: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 37;
                            string2 = "f\u0019HOIv";
                            n5 = 36;
                            continue block67;
                        }
                        case 36: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 38;
                            string2 = "F*c{rJ3s";
                            n5 = 37;
                            continue block67;
                        }
                        case 37: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 39;
                            string2 = "F3tmgV,";
                            n5 = 38;
                            continue block67;
                        }
                        case 38: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 40;
                            string2 = "V7|\u007fnV5(&~\u0013l";
                            n5 = 39;
                            continue block67;
                        }
                        case 39: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 41;
                            string2 = "G((;7Rk(CUh";
                            n5 = 40;
                            continue block67;
                        }
                        case 40: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 42;
                            string2 = "d\u001dJ@C|\b_Y";
                            n5 = 41;
                            continue block67;
                        }
                        case 41: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 43;
                            string2 = "P0ifvN;i:7]n.";
                            n5 = 42;
                            continue block67;
                        }
                        case 42: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 44;
                            string2 = "D,s`MB\u0007peo";
                            n5 = 43;
                            continue block67;
                        }
                        case 43: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 45;
                            string2 = "b\u001dW[Jp\u000b";
                            n5 = 44;
                            continue block67;
                        }
                        case 44: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 46;
                            string2 = "A1hjmUi+&0\u0011";
                            n5 = 45;
                            continue block67;
                        }
                        case 45: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 47;
                            string2 = "@\fJ@Evi+";
                            n5 = 46;
                            continue block67;
                        }
                        case 46: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 48;
                            string2 = "v\u001d\\BTj\f";
                            n5 = 47;
                            continue block67;
                        }
                        case 47: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 49;
                            string2 = "V(w{7\u0014k(";
                            n5 = 48;
                            continue block67;
                        }
                        case 48: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 50;
                            string2 = "A1hjmUi+&5\u0017";
                            n5 = 49;
                            continue block67;
                        }
                        case 49: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 51;
                            string2 = "a1HJMz\u0010IF";
                            n5 = 50;
                            continue block67;
                        }
                        case 50: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 52;
                            string2 = "d\u001bI";
                            n5 = 51;
                            continue block67;
                        }
                        case 51: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 53;
                            string2 = "B;vbd";
                            n5 = 52;
                            continue block67;
                        }
                        case 52: 
                    }
                    break;
                }
                stringArray2[n4] = string.intern();
                c = stringArray3;
                cards = new TreeMap<String, CardType>();
                cardATRs = new HashMap<String, List<String>>();
                char[] cArray8 = "V-t%gW;r%bD,{%kJ<\u007fg".toCharArray();
                n3 = 0;
                int n11 = cArray8.length;
                cArray2 = cArray8;
                n2 = n11;
                if (n11 <= 1) break block76;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block77;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n12 = n3;
                while (true) {
                    int n13;
                    char c = cArray9[n12];
                    switch (n3 % 5) {
                        case 0: {
                            n13 = 37;
                            break;
                        }
                        case 1: {
                            n13 = 88;
                            break;
                        }
                        case 2: {
                            n13 = 26;
                            break;
                        }
                        case 3: {
                            n13 = 11;
                            break;
                        }
                        default: {
                            n13 = 6;
                        }
                    }
                    cArray9[n12] = (char)(c ^ n13);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n12 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        JVM_BITSIZE = System.getProperty(new String(cArray).intern());
        AKIS = new CardType(c[15], AkisTemplate.class, c[36], Application.ESIGNATURE);
        AKIS_KK = new CardType(c[33], AkisTemplate.class, c[17], Application.TCKK);
        CARDOS = new CardType(c[12], CardosTemplate.class, c[37], Application.ESIGNATURE);
        ACS = new CardType(c[24], AcsTemplate.class, c[52], Application.ESIGNATURE);
        ALADDIN = new CardType(c[47], AladdinTemplate.class, c[29], Application.ESIGNATURE);
        DATAKEY = new CardType(c[20], DataKeyTemplate.class, c[26], Application.ESIGNATURE);
        GEMPLUS = new CardType(c[53], GemPlusTemplate.class, c[45], Application.ESIGNATURE);
        KEYCORP = new CardType(c[49], KeyCorpTemplate.class, c[27], Application.ESIGNATURE);
        NCIPHER = new CardType(c[39], c[11], NCipherTemplate.class, c[30], Application.ESIGNATURE, true);
        SAFESIGN = new CardType(c[7], SafeSignTemplate.class, c[25], Application.ESIGNATURE, true);
        SEFIROT = new CardType(c[13], SefirotTemplate.class, c[48], Application.ESIGNATURE);
        AEPKEYPER = new CardType(c[41], AEPTemplate.class, c[42], Application.ESIGNATURE);
        UTIMACO = new CardType(c[10], UtimacoTemplate.class, c[19], Application.ESIGNATURE, true);
        UTIMACO_R2 = new CardType(c[32], UtimacoTemplateR2.class, c[8], Application.ESIGNATURE, true);
        TKART = new CardType(c[35], TKartTemplate.class, c[18], Application.ESIGNATURE);
        ATIKKG = new CardType(c[44], AtikKGTemplate.class, c[9], Application.ESIGNATURE);
        SAFENET = new CardType(c[38], SafenetTemplate.class, c[21], Application.ESIGNATURE, true);
        ATIKHSM = new CardType(c[22], c[43], ATIKHSMTemplate.class, c[31], Application.ESIGNATURE);
        DIRAKHSM = new CardType(c[50], c[46], DirakHSMTemplate.class, c[51], Application.ESIGNATURE, false);
        OPENDNSSOFTHSM = new CardType(c[23], c[40], DefaultCardTemplate.class, c[34], Application.ESIGNATURE);
        NETID = new CardType(c[14], DefaultCardTemplate.class, c[28], Application.ESIGNATURE);
        UNKNOWN = new CardType("", DefaultCardTemplate.class, c[16], Application.ESIGNATURE);
        a = LoggerFactory.getLogger(CardType.class);
    }
}

