/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.Constants;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtendedKeyUsage;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPSignatureChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;

public class SigningCertificateChecker
extends OCSPResponseChecker {
    private static final Logger d;
    private static final String e;

    @Override
    protected PathValidationResult _check(EOCSPResponse aOCSPResponse, OCSPResponseStatusInfo aOCSPResponseInfo) throws ESYAException {
        if (this.mParentSystem == null) {
            return null;
        }
        ECertificate eCertificate = aOCSPResponse.getBasicOCSPResponse().getCertificate(0);
        if (!this.a(eCertificate)) {
            d.error(e);
            aOCSPResponseInfo.addDetail(this, OCSPSignatureChecker.OCSPSignatureCheckStatus.CERTIFICATE_IS_NOT_OCSP_CERTIFICATE, false);
            return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
        }
        IssuerCheckParameters issuerCheckParameters = this.mParentSystem.getCheckSystem().getConstraintCheckParam();
        long l = issuerCheckParameters.getCertificateOrder();
        issuerCheckParameters.setCertificateOrder(-1L);
        CertificateController certificateController = new CertificateController();
        CertificateStatusInfo certificateStatusInfo = certificateController.check(this.mParentSystem, eCertificate);
        aOCSPResponseInfo.setSigningCertficateInfo(certificateStatusInfo);
        issuerCheckParameters.setCertificateOrder(l);
        if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
            aOCSPResponseInfo.addDetail(this, SigningCertificateCheckStatus.VALID, true);
            return PathValidationResult.SUCCESS;
        }
        aOCSPResponseInfo.addDetail(this, SigningCertificateCheckStatus.INVALID, false);
        return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
    }

    private boolean a(ECertificate eCertificate) {
        EExtendedKeyUsage eExtendedKeyUsage = eCertificate.getExtensions().getExtendedKeyUsage();
        return eExtendedKeyUsage == null || eExtendedKeyUsage.hasElement(Constants.IMP_ID_KP_OCSPSIGNING);
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.OCSP_IMZALAYAN_SERTIFIKA_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                char[] cArray3 = "\rB0A#%V#C&d\\/R;-I#K.d`\ts\u001fdF'Z.(N3A,\u0175\u000f\u00bcZ*(C#\u013f&*JjS.,F:\u0000+!\u0130#L".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 68;
                            break;
                        }
                        case 1: {
                            n6 = 47;
                            break;
                        }
                        case 2: {
                            n6 = 74;
                            break;
                        }
                        case 3: {
                            n6 = 32;
                            break;
                        }
                        default: {
                            n6 = 79;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        e = new String(cArray).intern();
        d = LoggerFactory.getLogger(SigningCertificateChecker.class);
    }

    public static final class SigningCertificateCheckStatus
    extends Enum<SigningCertificateCheckStatus>
    implements CheckStatus {
        public static final /* enum */ SigningCertificateCheckStatus VALID;
        public static final /* enum */ SigningCertificateCheckStatus INVALID;
        private static final /* synthetic */ SigningCertificateCheckStatus[] a;
        private static final String[] b;

        public static SigningCertificateCheckStatus[] values() {
            return (SigningCertificateCheckStatus[])a.clone();
        }

        public static SigningCertificateCheckStatus valueOf(String name) {
            return Enum.valueOf(SigningCertificateCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case VALID: {
                    return CertI18n.message((String)CertI18n.IMZALAYAN_SERTIFIKA_GECERLI);
                }
                case INVALID: {
                    return CertI18n.message((String)CertI18n.IMZALAYAN_SERTIFIKA_GECERSIZ);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "\u0000\u00016R\r";
            int n2 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block13;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 86;
                                    break;
                                }
                                case 1: {
                                    n8 = 64;
                                    break;
                                }
                                case 2: {
                                    n8 = 122;
                                    break;
                                }
                                case 3: {
                                    n8 = 27;
                                    break;
                                }
                                default: {
                                    n8 = 73;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "\u001f\u000e,Z\u0005\u001f\u0004";
                        n2 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            b = stringArray3;
            VALID = new SigningCertificateCheckStatus();
            INVALID = new SigningCertificateCheckStatus();
            a = new SigningCertificateCheckStatus[]{VALID, INVALID};
        }
    }
}

