/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp;

import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.Constants;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtendedKeyUsage;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;

public class OCSPSignatureChecker
extends OCSPResponseChecker {
    private static final Logger d;
    private static final String[] e;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PathValidationResult _check(EOCSPResponse aOCSPCevabi, OCSPResponseStatusInfo aOCSPCevapBilgisi) {
        PathValidationResult pathValidationResult;
        boolean bl;
        block20: {
            boolean bl2 = OCSPResponseStatusInfo.f;
            byte[] byArray = aOCSPCevabi.getTbsResponseData();
            if (byArray == null) {
                d.error(e[1]);
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.INVALID_RESPONSE_STRUCTURE, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            byte[] byArray2 = aOCSPCevabi.getSignatureValue();
            if (byArray2 == null) {
                d.error(e[4]);
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.RESPONSE_NOT_SIGNED, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            EBasicOCSPResponse eBasicOCSPResponse = aOCSPCevabi.getBasicOCSPResponse();
            if (eBasicOCSPResponse.getCertificateCount() == 0) {
                d.error(e[0]);
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.NO_CERTIFICATE_IN_RESPONSE, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            ECertificate eCertificate = eBasicOCSPResponse.getCertificate(0);
            if (!this.a(eCertificate)) {
                d.error(e[2]);
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.CERTIFICATE_IS_NOT_OCSP_CERTIFICATE, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            try {
                block21: {
                    block23: {
                        block22: {
                            Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)aOCSPCevabi.getBasicOCSPResponse().getSignatureAlgorithm());
                            PublicKey publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)eCertificate.getSubjectPublicKeyInfo());
                            bl = SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray2, (PublicKey)publicKey);
                            if (bl) break block21;
                            byte[] byArray3 = new byte[byArray2.length];
                            int n = byArray2.length - 1;
                            for (int i = 0; i < byArray2.length; ++i) {
                                byArray3[i] = byArray2[n - i];
                                if (!bl2) continue;
                            }
                            if (bl = SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray3, (PublicKey)publicKey)) break block22;
                            aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.SIGNATURE_NOT_VERIFIED, false);
                            if (!bl2) break block23;
                        }
                        aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.SIGNATURE_VERIFIED, true);
                    }
                    if (!bl2) break block20;
                }
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.SIGNATURE_VERIFIED, true);
            }
            catch (CryptoException cryptoException) {
                d.error(e[5], (Throwable)cryptoException);
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
        }
        d.debug(e[3] + bl);
        if (bl) {
            pathValidationResult = PathValidationResult.SUCCESS;
            return pathValidationResult;
        }
        pathValidationResult = PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
        return pathValidationResult;
    }

    private boolean a(ECertificate eCertificate) {
        EExtendedKeyUsage eExtendedKeyUsage = eCertificate.getExtensions().getExtendedKeyUsage();
        return eExtendedKeyUsage == null || eExtendedKeyUsage.hasElement(Constants.IMP_ID_KP_OCSPSIGNING);
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.OCSP_IMZA_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = ",K\bx<OG\u0099p\"\u000bK\u00109%\u0002T\u001fu-\u0016G\u001dpl\u001cK\fm%\tG\u0015xl\u000eB\u014fw-\u0002O\u001a\u0128";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 111;
                                break;
                            }
                            case 1: {
                                n8 = 46;
                                break;
                            }
                            case 2: {
                                n8 = 126;
                                break;
                            }
                            case 3: {
                                n8 = 25;
                                break;
                            }
                            default: {
                                n8 = 76;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = ",K\bx<OG\u0099p\"\u000bK\u00109%\u0002T\u001fu-\u0001O\u00109(\n\u0131\u001bkl\u000eB\u014fw-\u0002O\u001a\u0128";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "&C\u0004x \u000eW\u0017z%O]\u001bk8\u0006H\u0017r-Oa=J\u001cOG\u0013c-\u0003O\u0007x\u017d\f\u011f^\u00ef6\nB\u0012p\u0153\u0006@\u001b9?\u000eF\u0017il\u000bK\u0161p ";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "&C\u0004xl\u000bK\u0161|>\u0006\u000e\u001av+\u001d[\u0012x!\u000e\u000e\rv\"\u001aM\u000b#";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = ",K\bx<OG\u0099p\"\u000bK\u00109%\u0002T\u001fu\u017dOJ\u001b\u0106)\u001d\u000e\u001fu\u017d\u0001O\u0013x(\u015e";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "&C\u0004xl\u000bA\u0161k9\u0003O\u0010\u0128>\u0004K\u00109$\u000eZ\u001f9#\u0003[\u0121m9";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
        d = LoggerFactory.getLogger(OCSPSignatureChecker.class);
    }

    public static final class OCSPSignatureCheckStatus
    extends Enum<OCSPSignatureCheckStatus>
    implements CheckStatus {
        public static final /* enum */ OCSPSignatureCheckStatus RESPONSE_NOT_SIGNED;
        public static final /* enum */ OCSPSignatureCheckStatus INVALID_RESPONSE_STRUCTURE;
        public static final /* enum */ OCSPSignatureCheckStatus NO_CERTIFICATE_IN_RESPONSE;
        public static final /* enum */ OCSPSignatureCheckStatus CERTIFICATE_IS_NOT_OCSP_CERTIFICATE;
        public static final /* enum */ OCSPSignatureCheckStatus KRIPTO_ERROR_ON_VERIFICATION;
        public static final /* enum */ OCSPSignatureCheckStatus SIGNATURE_NOT_VERIFIED;
        public static final /* enum */ OCSPSignatureCheckStatus SIGNATURE_VERIFIED;
        private static final /* synthetic */ OCSPSignatureCheckStatus[] a;
        private static final String[] b;

        public static OCSPSignatureCheckStatus[] values() {
            return (OCSPSignatureCheckStatus[])a.clone();
        }

        public static OCSPSignatureCheckStatus valueOf(String name) {
            return Enum.valueOf(OCSPSignatureCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case RESPONSE_NOT_SIGNED: {
                    return CertI18n.message((String)CertI18n.CEVAP_IMZALI_DEGIL);
                }
                case INVALID_RESPONSE_STRUCTURE: {
                    return CertI18n.message((String)CertI18n.CEVAP_YAPISI_BOZUK);
                }
                case NO_CERTIFICATE_IN_RESPONSE: {
                    return CertI18n.message((String)CertI18n.CEVAPTA_SERTIFIKA_YOK);
                }
                case CERTIFICATE_IS_NOT_OCSP_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_OCSP_SERTIFIKASI_DEGIL);
                }
                case KRIPTO_ERROR_ON_VERIFICATION: {
                    return CertI18n.message((String)CertI18n.DOGRULAMA_KRIPTO_HATASI);
                }
                case SIGNATURE_NOT_VERIFIED: {
                    return CertI18n.message((String)CertI18n.IMZA_DOGRULANAMADI);
                }
                case SIGNATURE_VERIFIED: {
                    return CertI18n.message((String)CertI18n.IMZA_DOGRULANDI);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[7];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "Gd\u001ez\u0002Ci\u0012x\u0004Cd\be\u0018S`\u0012x\u001fJ\u007f\u0014k\u0002Ey\u0019";
            int n2 = -1;
            block14: while (true) {
                char[] cArray;
                block19: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block18: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block18;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block19;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 12;
                                    break;
                                }
                                case 1: {
                                    n8 = 54;
                                    break;
                                }
                                case 2: {
                                    n8 = 87;
                                    break;
                                }
                                case 3: {
                                    n8 = 42;
                                    break;
                                }
                                default: {
                                    n8 = 86;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "Ex\u0001k\u001aEr\bx\u0013_f\u0018d\u0005Ii\u0004~\u0004Yu\u0003\u007f\u0004I";
                        n2 = 0;
                        continue block14;
                    }
                    case 0: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 2;
                        string2 = "_\u007f\u0010d\u0017Xc\u0005o\tBy\u0003u\u0000Id\u001el\u001fIr";
                        n2 = 1;
                        continue block14;
                    }
                    case 1: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 3;
                        string2 = "Os\u0005~\u001fJ\u007f\u0014k\u0002Ii\u001ey\tBy\u0003u\u0019Oe\u0007u\u0015Id\u0003c\u0010Eu\u0016~\u0013";
                        n2 = 2;
                        continue block14;
                    }
                    case 2: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 4;
                        string2 = "_\u007f\u0010d\u0017Xc\u0005o\tZs\u0005c\u0010Es\u0013";
                        n2 = 3;
                        continue block14;
                    }
                    case 3: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 5;
                        string2 = "By\bi\u0013^b\u001el\u001fOw\u0003o\tEx\bx\u0013_f\u0018d\u0005I";
                        n2 = 4;
                        continue block14;
                    }
                    case 4: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 6;
                        string2 = "^s\u0004z\u0019Be\u0012u\u0018Cb\by\u001fKx\u0012n";
                        n2 = 5;
                        continue block14;
                    }
                    case 5: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            b = stringArray3;
            RESPONSE_NOT_SIGNED = new OCSPSignatureCheckStatus();
            INVALID_RESPONSE_STRUCTURE = new OCSPSignatureCheckStatus();
            NO_CERTIFICATE_IN_RESPONSE = new OCSPSignatureCheckStatus();
            CERTIFICATE_IS_NOT_OCSP_CERTIFICATE = new OCSPSignatureCheckStatus();
            KRIPTO_ERROR_ON_VERIFICATION = new OCSPSignatureCheckStatus();
            SIGNATURE_NOT_VERIFIED = new OCSPSignatureCheckStatus();
            SIGNATURE_VERIFIED = new OCSPSignatureCheckStatus();
            a = new OCSPSignatureCheckStatus[]{RESPONSE_NOT_SIGNED, INVALID_RESPONSE_STRUCTURE, NO_CERTIFICATE_IN_RESPONSE, CERTIFICATE_IS_NOT_OCSP_CERTIFICATE, KRIPTO_ERROR_ON_VERIFICATION, SIGNATURE_NOT_VERIFIED, SIGNATURE_VERIFIED};
        }
    }
}

