/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.issuer;

import java.security.PublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.issuer.CRLIssuerChecker;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;

public class CRLSignatureChecker
extends CRLIssuerChecker {
    private static Logger e;
    private static final String[] f;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PathValidationResult _check(IssuerCheckParameters aConstraintCheckParams, ECRL aCRL, ECertificate aIssuerCertificate, CRLStatusInfo aCRLStatusInfo) {
        boolean bl;
        byte[] byArray;
        e.debug(f[2]);
        byte[] byArray2 = aCRL.getSignature();
        if (byArray2 == null) {
            e.error(f[0]);
            aCRLStatusInfo.addDetail(this, CRLSignatureCheckStatus.CRL_NOT_SIGNED, false);
            return PathValidationResult.CRL_SIGNATURE_CONTROL_FAILURE;
        }
        try {
            byArray = aCRL.getTBSEncodedBytes();
        }
        catch (Exception exception) {
            e.error(f[4], (Throwable)exception);
            aCRLStatusInfo.addDetail(this, CRLSignatureCheckStatus.CRL_INVALID_STRUCTURE, false);
            return PathValidationResult.CRL_SIGNATURE_CONTROL_FAILURE;
        }
        try {
            ESubjectPublicKeyInfo eSubjectPublicKeyInfo = aIssuerCertificate.getSubjectPublicKeyInfo();
            EAlgorithmIdentifier eAlgorithmIdentifier = eSubjectPublicKeyInfo.getAlgorithm();
            if (Arrays.equals(eAlgorithmIdentifier.getAlgorithm().value, AsymmetricAlg.DSA.getOID()) && eAlgorithmIdentifier.getParameters() == null) {
                if (aConstraintCheckParams.getPreviousDSAParams() == null) {
                    e.error(f[5]);
                    return PathValidationResult.CRL_SIGNATURE_CONTROL_FAILURE;
                }
                eAlgorithmIdentifier.setParameters(aConstraintCheckParams.getPreviousDSAParams());
                eSubjectPublicKeyInfo.setAlgorithm(eAlgorithmIdentifier);
            }
            String string = AsymmetricAlg.fromOID((int[])aIssuerCertificate.getPublicKeyAlgorithm().getAlgorithm().value).getName();
            PublicKey publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)eSubjectPublicKeyInfo);
            eAlgorithmIdentifier = aCRL.getTBSSignatureAlgorithm();
            Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eAlgorithmIdentifier);
            if (pair.getObject1() == null) {
                e.error(f[6] + new OID(eAlgorithmIdentifier.getAlgorithm().value));
            }
            bl = SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray2, (PublicKey)publicKey);
        }
        catch (Exception exception) {
            e.error(f[1], (Throwable)exception);
            aCRLStatusInfo.addDetail(this, CRLSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, false);
            return PathValidationResult.CRL_SIGNATURE_CONTROL_FAILURE;
        }
        if (bl) {
            e.debug(f[7]);
            aCRLStatusInfo.addDetail(this, CRLSignatureCheckStatus.SIGNATURE_VERIFIED, true);
            return PathValidationResult.SUCCESS;
        }
        e.error(f[3]);
        aCRLStatusInfo.addDetail(this, CRLSignatureCheckStatus.SIGNATURE_NOT_VERIFIED, false);
        return PathValidationResult.CRL_SIGNATURE_CONTROL_FAILURE;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.SIL_IMZA_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = ":6a\u0006E\u0004%l\u0006H\f\u0140hTEI1xJ@";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 105;
                                break;
                            }
                            case 1: {
                                n8 = 95;
                                break;
                            }
                            case 2: {
                                n8 = 13;
                                break;
                            }
                            case 3: {
                                n8 = 38;
                                break;
                            }
                            default: {
                                n8 = 44;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = ":6a\u0006E\u0004%lU\u011dI;b\u0139^\u001c3lH\u011d\u001b4hH\f\u0001>yG\f\u00063x\u0179X\u001cq";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = ":6a\u0006E\u0004%lU\u011dI4bHX\u001b0a\u0006I\r6aCO\f4";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = ":6a\u0006E\u0004%lU\u011dI;b\u0139^\u001c3lHM\u0004>i\u0117\u0002";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = ":6a\u0006H\f\u0140hTEI>a\u0117B\u0158-fCBI7lRMI0aS\u0173\u001d*#";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\":t\u0006M\u00058-VM\u001b>`CX\u001b:-_C\u0002\u007f{C\f\u0095,yRI\u0007\u007fiC\f\u000e:aKI\u00046\u0152\b\f";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "*\rA\u0006_\u00008cGX\u001c-h\u0006M\u00058bTE\u001d7`\u0006O\u0006*aB\f\u00070y\u0006N\f\u007fiCX\f<yCHI";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = ":6a\u0006E\u0004%lU\u011dI;b\u0139^\u001c3lHH\u0158q";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        f = stringArray3;
        e = LoggerFactory.getLogger(CRLSignatureChecker.class);
    }

    public static final class CRLSignatureCheckStatus
    extends Enum<CRLSignatureCheckStatus>
    implements CheckStatus {
        public static final /* enum */ CRLSignatureCheckStatus CRL_NOT_SIGNED;
        public static final /* enum */ CRLSignatureCheckStatus CRL_INVALID_STRUCTURE;
        public static final /* enum */ CRLSignatureCheckStatus NO_PUBLIC_KEY_IN_CERTIFICATE;
        public static final /* enum */ CRLSignatureCheckStatus INVALID_PUBLIC_KEY_IN_CERTIFICATE;
        public static final /* enum */ CRLSignatureCheckStatus KRIPTO_ERROR_ON_VERIFICATION;
        public static final /* enum */ CRLSignatureCheckStatus SIGNATURE_NOT_VERIFIED;
        public static final /* enum */ CRLSignatureCheckStatus SIGNATURE_VERIFIED;
        private static final /* synthetic */ CRLSignatureCheckStatus[] a;
        private static final String[] b;

        public static CRLSignatureCheckStatus[] values() {
            return (CRLSignatureCheckStatus[])a.clone();
        }

        public static CRLSignatureCheckStatus valueOf(String name) {
            return Enum.valueOf(CRLSignatureCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case CRL_NOT_SIGNED: {
                    return CertI18n.message((String)CertI18n.SIL_IMZALI_DEGIL);
                }
                case CRL_INVALID_STRUCTURE: {
                    return CertI18n.message((String)CertI18n.SIL_YAPISI_BOZUK);
                }
                case NO_PUBLIC_KEY_IN_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKADA_ACIK_ANAHTAR_YOK);
                }
                case INVALID_PUBLIC_KEY_IN_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKADA_ACIK_ANAHTAR_BOZUK);
                }
                case KRIPTO_ERROR_ON_VERIFICATION: {
                    return CertI18n.message((String)CertI18n.DOGRULAMA_KRIPTO_HATASI);
                }
                case SIGNATURE_NOT_VERIFIED: {
                    return CertI18n.message((String)CertI18n.SIL_IMZA_DOGRULANAMADI);
                }
                case SIGNATURE_VERIFIED: {
                    return CertI18n.message((String)CertI18n.SIL_IMZA_DOGRULANDI);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[7];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "5&$#\u00078\")0\u00072+;(\u001c#7<)\u001c3";
            int n2 = -1;
            block14: while (true) {
                char[] cArray;
                block19: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block18: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block18;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block19;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 118;
                                    break;
                                }
                                case 1: {
                                    n8 = 116;
                                    break;
                                }
                                case 2: {
                                    n8 = 104;
                                    break;
                                }
                                case 3: {
                                    n8 = 124;
                                    break;
                                }
                                default: {
                                    n8 = 78;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "?:>=\u0002?07,\u001b48!?\u0011=11#\u00078++9\u001c\"=.5\r7 -";
                        n2 = 0;
                        continue block14;
                    }
                    case 0: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 2;
                        string2 = "=&!,\u001a9+-.\u001c9&73\u0000)\"-.\u00070=+=\u001a?;&";
                        n2 = 1;
                        continue block14;
                    }
                    case 1: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 3;
                        string2 = "%=/2\u000f\"!:9\u0011 1:5\b?1,";
                        n2 = 2;
                        continue block14;
                    }
                    case 2: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 4;
                        string2 = "5&$#\u00009 7/\u00071:-8";
                        n2 = 3;
                        continue block14;
                    }
                    case 3: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 5;
                        string2 = "8;7,\u001b48!?\u0011=11#\u00078++9\u001c\"=.5\r7 -";
                        n2 = 4;
                        continue block14;
                    }
                    case 4: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 6;
                        string2 = "%=/2\u000f\"!:9\u00118;<#\u00183&!:\u000730";
                        n2 = 5;
                        continue block14;
                    }
                    case 5: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            b = stringArray3;
            CRL_NOT_SIGNED = new CRLSignatureCheckStatus();
            CRL_INVALID_STRUCTURE = new CRLSignatureCheckStatus();
            NO_PUBLIC_KEY_IN_CERTIFICATE = new CRLSignatureCheckStatus();
            INVALID_PUBLIC_KEY_IN_CERTIFICATE = new CRLSignatureCheckStatus();
            KRIPTO_ERROR_ON_VERIFICATION = new CRLSignatureCheckStatus();
            SIGNATURE_NOT_VERIFIED = new CRLSignatureCheckStatus();
            SIGNATURE_VERIFIED = new CRLSignatureCheckStatus();
            a = new CRLSignatureCheckStatus[]{CRL_NOT_SIGNED, CRL_INVALID_STRUCTURE, NO_PUBLIC_KEY_IN_CERTIFICATE, INVALID_PUBLIC_KEY_IN_CERTIFICATE, KRIPTO_ERROR_ON_VERIFICATION, SIGNATURE_NOT_VERIFIED, SIGNATURE_VERIFIED};
        }
    }
}

