/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EBasicConstraints;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerChecker;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;

public class PathLenConstraintChecker
extends IssuerChecker {
    private static final Logger e;
    private static final String[] f;

    @Override
    protected PathValidationResult _check(IssuerCheckParameters aIssuerCheckParameters, ECertificate aIssuerCertificate, ECertificate aCertificate, CertificateStatusInfo aCertStatusInfo) {
        EBasicConstraints eBasicConstraints = aIssuerCertificate.getExtensions().getBasicConstraints();
        if (eBasicConstraints == null) {
            e.error(f[1]);
            aCertStatusInfo.addDetail(this, PathLenConstraintCheckStatus.BASIC_CONST_EXTENSION_NOT_EXIST, false);
            return PathValidationResult.PATHLENCONSTRAINTS_FAILURE;
        }
        if (eBasicConstraints.getPathLenConstraint() == null) {
            e.debug(f[4]);
            aCertStatusInfo.addDetail(this, PathLenConstraintCheckStatus.BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NOT_EXISTS, true);
            return PathValidationResult.SUCCESS;
        }
        long l = eBasicConstraints.getPathLenConstraint();
        if (l < 0L) {
            e.debug(f[2]);
            aCertStatusInfo.addDetail(this, PathLenConstraintCheckStatus.BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NEGATIVE, true);
            return PathValidationResult.SUCCESS;
        }
        long l2 = aIssuerCheckParameters.getCertificateOrder();
        if (l2 > l) {
            e.error(f[0] + l2 + ">" + l);
            aCertStatusInfo.addDetail(this, PathLenConstraintCheckStatus.BASIC_CONST_EXTENSION_LEN_CONS_VALUE_EXCEEDED, false);
            return PathValidationResult.PATHLENCONSTRAINTS_FAILURE;
        }
        e.debug(f[3] + l2 + f[5] + l);
        aCertStatusInfo.addDetail(this, PathLenConstraintCheckStatus.BASIC_CONST_EXTENSION_LEN_CONS_VALUE_VALID, true);
        return PathValidationResult.SUCCESS;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.PATH_LEN_CONSTRAINT_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "N(Q\"\u001bO&L8\f~(K%\f\u007fiR*\fdiN.\u0016k=Jk\u001bc'Q?\nm L?Xh,\u013d.\neiC\u0114\u0149`-\u0113q";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 12;
                                break;
                            }
                            case 1: {
                                n8 = 73;
                                break;
                            }
                            case 2: {
                                n8 = 34;
                                break;
                            }
                            case 3: {
                                n8 = 75;
                                break;
                            }
                            default: {
                                n8 = 120;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "_,P?\u0011j I*\u001cmi`*\u000be*\u0002\b\u0017b:V9\u0019e'V8Xy3C%\f\u013d:\u0113k\u0001c\"";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "N(Q\"\u001bO&L8\f~(K%\f\u007fiR*\fdiN.\u0016k=Jk\u001bc'Q?\nm L?Xh,\u013d.\neiL.\u001fm=K-";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "N(Q\"\u001bO&L8\f~(K%\f\u007fiR*\fdiN.\u0016k=Jk\u001bc'Q?\nm L?Xh,\u013d.\neiE.\u009fi;N\"B";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "N(Q\"\u001bO&L8\f~(K%\f\u007fiR*\fdiN.\u0016k=Jk\u001bc'Q?\nm L?Xh,\u013d.\nei[$\u0013";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "0t";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        f = stringArray3;
        e = LoggerFactory.getLogger(PathLenConstraintChecker.class);
    }

    public static final class PathLenConstraintCheckStatus
    extends Enum<PathLenConstraintCheckStatus>
    implements CheckStatus {
        public static final /* enum */ PathLenConstraintCheckStatus BASIC_CONST_EXTENSION_NOT_EXIST;
        public static final /* enum */ PathLenConstraintCheckStatus BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NOT_EXISTS;
        public static final /* enum */ PathLenConstraintCheckStatus BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NEGATIVE;
        public static final /* enum */ PathLenConstraintCheckStatus BASIC_CONST_EXTENSION_LEN_CONS_VALUE_EXCEEDED;
        public static final /* enum */ PathLenConstraintCheckStatus BASIC_CONST_EXTENSION_LEN_CONS_VALUE_VALID;
        private static final /* synthetic */ PathLenConstraintCheckStatus[] a;
        private static final String[] b;

        public static PathLenConstraintCheckStatus[] values() {
            return (PathLenConstraintCheckStatus[])a.clone();
        }

        public static PathLenConstraintCheckStatus valueOf(String name) {
            return Enum.valueOf(PathLenConstraintCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case BASIC_CONST_EXTENSION_NOT_EXIST: {
                    return CertI18n.message((String)CertI18n.BASIC_CONST_EKLENTI_YOK);
                }
                case BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NOT_EXISTS: {
                    return CertI18n.message((String)CertI18n.BASIC_CONST_EKLENTI_LEN_CONS_DEGERI_YOK);
                }
                case BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NEGATIVE: {
                    return CertI18n.message((String)CertI18n.BASIC_CONST_EKLENTI_LEN_CONS_DEGERI_NEGATIF);
                }
                case BASIC_CONST_EXTENSION_LEN_CONS_VALUE_EXCEEDED: {
                    return CertI18n.message((String)CertI18n.BASIC_CONST_EKLENTI_LEN_CONS_DEGERI_ASILDI);
                }
                case BASIC_CONST_EXTENSION_LEN_CONS_VALUE_VALID: {
                    return CertI18n.message((String)CertI18n.BASIC_CONST_EKLENTI_LEN_CONS_DEGERI_GECERLI);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[5];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "\tN>rz\u0014L\"uj\u001fP(cm\u000eA>rv\u0005P!~w\u0014L\"uj\u0014Y,wl\u000eP(cz\u000eJ)~}";
            int n2 = -1;
            block12: while (true) {
                char[] cArray;
                block17: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block16: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block16;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block17;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 75;
                                    break;
                                }
                                case 1: {
                                    n8 = 15;
                                    break;
                                }
                                case 2: {
                                    n8 = 109;
                                    break;
                                }
                                case 3: {
                                    n8 = 59;
                                    break;
                                }
                                default: {
                                    n8 = 57;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "\tN>rz\u0014L\"uj\u001fP(cm\u000eA>rv\u0005P!~w\u0014L\"uj\u0014Y,wl\u000eP#~~\n[$m|";
                        n2 = 0;
                        continue block12;
                    }
                    case 0: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 2;
                        string2 = "\tN>rz\u0014L\"uj\u001fP(cm\u000eA>rv\u0005P!~w\u0014L\"uj\u0014Y,wl\u000eP#tm\u0014J5rj\u001f\\";
                        n2 = 1;
                        continue block12;
                    }
                    case 1: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 3;
                        string2 = "\tN>rz\u0014L\"uj\u001fP(cm\u000eA>rv\u0005P#tm\u0014J5rj\u001f";
                        n2 = 2;
                        continue block12;
                    }
                    case 2: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 4;
                        string2 = "\tN>rz\u0014L\"uj\u001fP(cm\u000eA>rv\u0005P!~w\u0014L\"uj\u0014Y,wl\u000eP;zu\u0002K";
                        n2 = 3;
                        continue block12;
                    }
                    case 3: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            b = stringArray3;
            BASIC_CONST_EXTENSION_NOT_EXIST = new PathLenConstraintCheckStatus();
            BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NOT_EXISTS = new PathLenConstraintCheckStatus();
            BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NEGATIVE = new PathLenConstraintCheckStatus();
            BASIC_CONST_EXTENSION_LEN_CONS_VALUE_EXCEEDED = new PathLenConstraintCheckStatus();
            BASIC_CONST_EXTENSION_LEN_CONS_VALUE_VALID = new PathLenConstraintCheckStatus();
            a = new PathLenConstraintCheckStatus[]{BASIC_CONST_EXTENSION_NOT_EXIST, BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NOT_EXISTS, BASIC_CONST_EXTENSION_LEN_CONS_VALUE_NEGATIVE, BASIC_CONST_EXTENSION_LEN_CONS_VALUE_EXCEEDED, BASIC_CONST_EXTENSION_LEN_CONS_VALUE_VALID};
        }
    }
}

