/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAuthorityKeyIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectKeyIdentifier;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerChecker;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;
import tr.gov.tubitak.uekae.esya.asn.util.UtilEsitlikler;

public class KeyIdentifierChecker
extends IssuerChecker {
    private static Logger e;
    private static final String[] f;

    @Override
    protected PathValidationResult _check(IssuerCheckParameters aIssuerCheckParameters, ECertificate aIssuerCertificate, ECertificate aCertificate, CertificateStatusInfo aCertStatusInfo) {
        EAuthorityKeyIdentifier eAuthorityKeyIdentifier = aCertificate.getExtensions().getAuthorityKeyIdentifier();
        if (eAuthorityKeyIdentifier == null) {
            e.error(f[3]);
            aCertStatusInfo.addDetail(this, KeyIdentifierCheckStatus.NO_CERTIFICATE_AUTHORITY_KEY_IDENTIFIER, false);
            return PathValidationResult.KEYID_CONTROL_FAILURE;
        }
        ESubjectKeyIdentifier eSubjectKeyIdentifier = aIssuerCertificate.getExtensions().getSubjectKeyIdentifier();
        if (eSubjectKeyIdentifier == null) {
            e.error(f[1]);
            aCertStatusInfo.addDetail(this, KeyIdentifierCheckStatus.NO_ISSUER_CERTIFICATE_SUBJECT_KEY_IDENTIFIER, false);
            return PathValidationResult.KEYID_CONTROL_FAILURE;
        }
        if (!UtilEsitlikler.esitMi((byte[])eAuthorityKeyIdentifier.getKeyIdentifier(), (byte[])eSubjectKeyIdentifier.getValue())) {
            e.error(f[0]);
            aCertStatusInfo.addDetail(this, KeyIdentifierCheckStatus.AUTHORITY_SUBJECT_KEY_IDENTIFIER_MISMATCH, false);
            return PathValidationResult.KEYID_CONTROL_FAILURE;
        }
        if (e.isDebugEnabled()) {
            e.debug(f[2]);
        }
        aCertStatusInfo.addDetail(this, KeyIdentifierCheckStatus.AUTHORITY_SUBJECT_KEY_IDENTIFIER_MATCH_OK, true);
        return PathValidationResult.SUCCESS;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.KEY_IDENTIFIER_KONTROLU);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "Y_kQ5jCk@zSOf\u0019\u0013|OqM3~CzKznO?j/z@zZ.8az@zQNzW.qLv\\(8Nz\u0126?jFzK38KfW\u016b8Nz\u01263t";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 24;
                                break;
                            }
                            case 1: {
                                n8 = 42;
                                break;
                            }
                            case 2: {
                                n8 = 31;
                                break;
                            }
                            case 3: {
                                n8 = 57;
                                break;
                            }
                            default: {
                                n8 = 90;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "KOmM3~CtX>y\nLr\u00138SpR";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "Y_kQ5jCk@zSOf\u0019\u0013|OqM3~CzKznO?j/z@zZ.8az@zQNzW.qLv\\(8Nz\u0126?jFzK38KfW\u016b";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "KOmM3~CtX>y\n^r\u00138SpR";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        f = stringArray3;
        e = LoggerFactory.getLogger(KeyIdentifierChecker.class);
    }

    public static final class KeyIdentifierCheckStatus
    extends Enum<KeyIdentifierCheckStatus>
    implements CheckStatus {
        public static final /* enum */ KeyIdentifierCheckStatus NO_CERTIFICATE_AUTHORITY_KEY_IDENTIFIER;
        public static final /* enum */ KeyIdentifierCheckStatus NO_ISSUER_CERTIFICATE_SUBJECT_KEY_IDENTIFIER;
        public static final /* enum */ KeyIdentifierCheckStatus AUTHORITY_SUBJECT_KEY_IDENTIFIER_MISMATCH;
        public static final /* enum */ KeyIdentifierCheckStatus AUTHORITY_SUBJECT_KEY_IDENTIFIER_MATCH_OK;
        private static final /* synthetic */ KeyIdentifierCheckStatus[] a;
        private static final String[] b;

        public static KeyIdentifierCheckStatus[] values() {
            return (KeyIdentifierCheckStatus[])a.clone();
        }

        public static KeyIdentifierCheckStatus valueOf(String name) {
            return Enum.valueOf(KeyIdentifierCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case NO_CERTIFICATE_AUTHORITY_KEY_IDENTIFIER: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_AUTHORITY_KEY_IDENTIFIER_YOK);
                }
                case NO_ISSUER_CERTIFICATE_SUBJECT_KEY_IDENTIFIER: {
                    return CertI18n.message((String)CertI18n.SMSERTIFIKA_SUBJECT_KEY_IDENTIFIER_YOK);
                }
                case AUTHORITY_SUBJECT_KEY_IDENTIFIER_MISMATCH: {
                    return CertI18n.message((String)CertI18n.AUTHORITY_SUBJECT_KEY_IDENTIFIER_UYUMSUZ);
                }
                case AUTHORITY_SUBJECT_KEY_IDENTIFIER_MATCH_OK: {
                    return CertI18n.message((String)CertI18n.AUTHORITY_SUBJECT_KEY_IDENTIFIER_UYUMLU);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[4];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "&\bS1M5\u0014S ]4\bE3G$\tX2G>\u0002N=G)\tN?K\"\u000fX4K4\u0010F-A/";
            int n2 = -1;
            block11: while (true) {
                char[] cArray;
                block16: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block15: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block15;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block16;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 103;
                                    break;
                                }
                                case 1: {
                                    n8 = 93;
                                    break;
                                }
                                case 2: {
                                    n8 = 7;
                                    break;
                                }
                                case 3: {
                                    n8 = 121;
                                    break;
                                }
                                default: {
                                    n8 = 2;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = ")\u0012X0Q4\bB+]$\u0018U-K!\u0014D8V\"\u0002T,@-\u0018D-],\u0018^&K#\u0018I-K!\u0014B+";
                        n2 = 0;
                        continue block11;
                    }
                    case 0: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 2;
                        string2 = "&\bS1M5\u0014S ]4\bE3G$\tX2G>\u0002N=G)\tN?K\"\u000fX4C3\u001eO&M,";
                        n2 = 1;
                        continue block11;
                    }
                    case 1: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 3;
                        string2 = ")\u0012X:G5\tN?K$\u001cS<]&\bS1M5\u0014S ],\u0018^&K#\u0018I-K!\u0014B+";
                        n2 = 2;
                        continue block11;
                    }
                    case 2: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            b = stringArray3;
            NO_CERTIFICATE_AUTHORITY_KEY_IDENTIFIER = new KeyIdentifierCheckStatus();
            NO_ISSUER_CERTIFICATE_SUBJECT_KEY_IDENTIFIER = new KeyIdentifierCheckStatus();
            AUTHORITY_SUBJECT_KEY_IDENTIFIER_MISMATCH = new KeyIdentifierCheckStatus();
            AUTHORITY_SUBJECT_KEY_IDENTIFIER_MATCH_OK = new KeyIdentifierCheckStatus();
            a = new KeyIdentifierCheckStatus[]{NO_CERTIFICATE_AUTHORITY_KEY_IDENTIFIER, NO_ISSUER_CERTIFICATE_SUBJECT_KEY_IDENTIFIER, AUTHORITY_SUBJECT_KEY_IDENTIFIER_MISMATCH, AUTHORITY_SUBJECT_KEY_IDENTIFIER_MATCH_OK};
        }
    }
}

