/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.StatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.match.certificate.CertificateMatcher;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.match.crl.CRLMatcher;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.match.cross.CrossCertificateMatcher;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.match.deltacrl.DeltaCRLMatcher;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.match.ocsp.OCSPResponseMatcher;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;

public class MatchSystem {
    private static Logger a;
    private List<CertificateMatcher> b = new ArrayList<CertificateMatcher>();
    private List<CRLMatcher> c = new ArrayList<CRLMatcher>();
    private List<CrossCertificateMatcher> d = new ArrayList<CrossCertificateMatcher>();
    private List<DeltaCRLMatcher> e = new ArrayList<DeltaCRLMatcher>();
    private List<OCSPResponseMatcher> f = new ArrayList<OCSPResponseMatcher>();
    private static final String[] g;

    public MatchSystem() {
        try {
            LV.getInstance().checkLD(LV.Urunler.SERTIFIKADOGRULAMA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(g[3] + lE.getMessage());
        }
    }

    public List<CertificateMatcher> getCertificateMatchers() {
        return this.b;
    }

    public void setCertificateMatchers(List<CertificateMatcher> aCertificateMatchers) {
        this.b = aCertificateMatchers;
    }

    public void addCertificateMatcher(CertificateMatcher aCertificateMatcher) {
        this.b.add(aCertificateMatcher);
    }

    public List<CRLMatcher> getCRLMatchers() {
        return this.c;
    }

    public void setCRLMatchers(List<CRLMatcher> aCRLMatchers) {
        this.c = aCRLMatchers;
    }

    public void addCRLMatcher(CRLMatcher aCRLMatcher) {
        this.c.add(aCRLMatcher);
    }

    public List<CrossCertificateMatcher> getCrossCertificateMatchers() {
        return this.d;
    }

    public void setCrossCertificateMatchers(List<CrossCertificateMatcher> aCrossCertificateMatchers) {
        this.d = aCrossCertificateMatchers;
    }

    public void addCrossCertificateMatcher(CrossCertificateMatcher aCrossCertificateMatcher) {
        this.d.add(aCrossCertificateMatcher);
    }

    public List<DeltaCRLMatcher> getDeltaCRLMatchers() {
        return this.e;
    }

    public void setDeltaCRLMatchers(List<DeltaCRLMatcher> aDeltaCRLMatchers) {
        this.e = aDeltaCRLMatchers;
    }

    public void addDeltaCRLMatcher(DeltaCRLMatcher aDeltaCRLMatcher) {
        this.e.add(aDeltaCRLMatcher);
    }

    public List<OCSPResponseMatcher> getOCSPResponseMatchers() {
        return this.f;
    }

    public void setOCSPResponseMatchers(List<OCSPResponseMatcher> aOCSPResponseMatchers) {
        this.f = aOCSPResponseMatchers;
    }

    public void addOCSPResponseMatcher(OCSPResponseMatcher aOCSPResponseMatcher) {
        this.f.add(aOCSPResponseMatcher);
    }

    public boolean matchCertificate(ECertificate aCertificate, ECertificate aIssuerCertificate) {
        boolean bl = StatusInfo.c;
        for (CertificateMatcher certificateMatcher : this.b) {
            boolean bl2 = certificateMatcher.matchCertificate(aCertificate, aIssuerCertificate);
            if (!bl2) {
                a.debug(certificateMatcher.getClass().getName() + g[0]);
                return false;
            }
            if (!bl) continue;
        }
        return true;
    }

    public boolean matchCertificate(ECRL aCRL, ECertificate aIssuerCertificate) {
        boolean bl = StatusInfo.c;
        for (CertificateMatcher certificateMatcher : this.b) {
            if (!certificateMatcher.matchCertificate(aCRL, aIssuerCertificate)) {
                a.debug(certificateMatcher.getClass().getName() + g[1]);
                return false;
            }
            if (!bl) continue;
        }
        return true;
    }

    public boolean matchCRL(ECertificate aCertificate, ECRL aCRL) {
        boolean bl = StatusInfo.c;
        for (CRLMatcher cRLMatcher : this.c) {
            if (!cRLMatcher.matchCRL(aCertificate, aCRL)) {
                a.debug(cRLMatcher.getClass().getName() + g[4]);
                a.debug(g[5] + aCRL);
                return false;
            }
            if (!bl) continue;
        }
        return true;
    }

    public boolean matchDeltaCRL(ECRL aCRL, ECRL aDeltaCRL) {
        boolean bl = StatusInfo.c;
        for (DeltaCRLMatcher deltaCRLMatcher : this.e) {
            if (!deltaCRLMatcher.deltaSilEslestir(aCRL, aDeltaCRL)) {
                a.debug(deltaCRLMatcher.getClass().getName() + g[6]);
                return false;
            }
            if (!bl) continue;
        }
        return true;
    }

    public boolean matchOCSPResponse(ECertificate aCertificate, ECertificate aIssuer, EOCSPResponse aOCSPResponse) {
        boolean bl = StatusInfo.c;
        for (OCSPResponseMatcher oCSPResponseMatcher : this.f) {
            if (!oCSPResponseMatcher.matchOCSPResponse(aCertificate, aIssuer, aOCSPResponse)) {
                a.debug(oCSPResponseMatcher.getClass().getName() + g[2]);
                return false;
            }
            if (!bl) continue;
        }
        return true;
    }

    public boolean matchCrossCertificate(ECertificate aCertificate, ECertificate aCrossCertificate) {
        boolean bl = StatusInfo.c;
        for (CrossCertificateMatcher crossCertificateMatcher : this.d) {
            if (!crossCertificateMatcher.matchCrossCertificate(aCertificate, aCrossCertificate)) {
                a.debug(crossCertificateMatcher.getClass().getName() + g[7]);
                return false;
            }
            if (!bl) continue;
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\rp\bL@Hr";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 45;
                                break;
                            }
                            case 1: {
                                n8 = 22;
                                break;
                            }
                            case 2: {
                                n8 = 105;
                                break;
                            }
                            case 3: {
                                n8 = 37;
                                break;
                            }
                            default: {
                                n8 = 44;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\rp\bL@Hr";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\rp\bL@Hr";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "a\u007f\u001aDB^6\u0002JBYd\u0006IY\rt\bVM_\u007f\u001aLV\u00036";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\rp\bL@Hr";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "nD%\u001f&";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\rp\bL@Hr";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\rp\bL@Hr";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        g = stringArray3;
        a = LoggerFactory.getLogger(MatchSystem.class);
    }
}

