/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu;

import gnu.crypto.key.dss.DSSKeyPairX509Codec;
import gnu.crypto.key.ecdsa.ECDSAKeyPairX509Codec;
import gnu.crypto.key.ecdsa.ECDSAPrivateKey;
import gnu.crypto.key.ecdsa.ECDSAPublicKey;
import gnu.crypto.key.rsa.GnuRSAPrivateKey;
import gnu.crypto.key.rsa.GnuRSAPublicKey;
import gnu.crypto.key.rsa.RSAKeyPairX509Codec;
import gnu.crypto.sig.ecdsa.ecmath.curve.CurveF2m;
import gnu.crypto.sig.ecdsa.ecmath.curve.CurveFp;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECDomainParameter;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECGNUPoint;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECPointF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECPointFp;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldFp;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import tr.gov.tubitak.uekae.esya.api.common.bundle.GenelDil;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.UnknownElement;
import tr.gov.tubitak.uekae.esya.api.crypto.params.KeySpec;
import tr.gov.tubitak.uekae.esya.api.crypto.params.PBEKeySpec;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.PBEKeyGen;
import tr.gov.tubitak.uekae.esya.api.crypto.util.RandomUtil;

public class GNUKeyFactory
implements KeyFactory {
    public static boolean b;
    private static final String[] a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicKey decodePublicKey(AsymmetricAlg aAsymmetricAlg, byte[] aBytes) throws CryptoException {
        switch (aAsymmetricAlg) {
            case RSA: {
                return new RSAKeyPairX509Codec().decodePublicKey(aBytes);
            }
            case DSA: {
                return new DSSKeyPairX509Codec().decodePublicKey(aBytes);
            }
            case ECDSA: {
                return new ECDSAKeyPairX509Codec().decodePublicKey(aBytes);
            }
        }
        throw new UnknownElement(GenelDil.mesaj((String)GenelDil.IMZALG_0_BILINMIYOR, (String[])new String[]{aAsymmetricAlg.name()}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivateKey decodePrivateKey(AsymmetricAlg aAsymmetricAlg, byte[] aBytes) throws CryptoException {
        switch (aAsymmetricAlg) {
            case RSA: {
                return new RSAKeyPairX509Codec().decodePrivateKey(aBytes);
            }
            case DSA: {
                return new DSSKeyPairX509Codec().decodePrivateKey(aBytes);
            }
            case ECDSA: {
                return new ECDSAKeyPairX509Codec().decodePrivateKey(aBytes);
            }
        }
        throw new UnknownElement(GenelDil.mesaj((String)GenelDil.IMZALG_0_BILINMIYOR, (String[])new String[]{aAsymmetricAlg.name()}));
    }

    public SecretKey generateSecretKey(KeySpec aKeySpec) throws CryptoException {
        if (aKeySpec instanceof PBEKeySpec) {
            return new PBEKeyGen((PBEKeySpec)aKeySpec).generateKey();
        }
        throw new UnknownElement(a[5] + aKeySpec);
    }

    public SecretKey generateSecretKey(CipherAlg alg, int keyLength) throws CryptoException {
        block4: {
            if (alg != null && alg.getName().startsWith(a[1])) break block4;
            throw new CryptoException(a[0] + alg);
        }
        return new SecretKeySpec(RandomUtil.generateRandom((int)(keyLength / 8)), a[2]);
    }

    public byte[] generateKey(CipherAlg aAlg, int aBitLength) {
        return RandomUtil.generateRandom((int)(aBitLength / 8));
    }

    public PublicKey generatePublicKey(java.security.spec.KeySpec aKeySpec) throws CryptoException {
        if (aKeySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)aKeySpec;
            return new GnuRSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        if (aKeySpec instanceof ECPublicKeySpec) {
            Object object;
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)aKeySpec;
            EllipticCurve ellipticCurve = eCPublicKeySpec.getParams().getCurve();
            ECField eCField = ellipticCurve.getField();
            ECPoint eCPoint = eCPublicKeySpec.getW();
            ECDomainParameter eCDomainParameter = ECDomainParameter.getInstance(eCPublicKeySpec.getParams());
            ECGNUPoint eCGNUPoint = null;
            try {
                if (eCField instanceof ECFieldF2m) {
                    object = (ECFieldF2m)eCField;
                    FieldF2mPolynomial fieldF2mPolynomial = FieldF2mPolynomial.getInstance(((ECFieldF2m)object).getM(), ((ECFieldF2m)object).getReductionPolynomial());
                    CurveF2m curveF2m = new CurveF2m(fieldF2mPolynomial, ellipticCurve.getA(), ellipticCurve.getB());
                    eCGNUPoint = new ECPointF2mPolynomial(curveF2m, eCPoint.getAffineX(), eCPoint.getAffineY());
                } else {
                    object = (ECFieldFp)eCField;
                    FieldFp fieldFp = FieldFp.getInstance(((ECFieldFp)object).getP());
                    CurveFp curveFp = new CurveFp(fieldFp, ellipticCurve.getA(), ellipticCurve.getB());
                    eCGNUPoint = new ECPointFp(curveFp, eCPoint.getAffineX(), eCPoint.getAffineY());
                }
            }
            catch (Exception exception) {
                throw new CryptoException(a[4], (Throwable)exception);
            }
            object = new ECDSAPublicKey(eCDomainParameter, eCGNUPoint);
            return object;
        }
        throw new UnknownElement(a[3] + aKeySpec);
    }

    public PrivateKey generatePrivateKey(java.security.spec.KeySpec aKeySpec) throws CryptoException {
        if (aKeySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)aKeySpec;
            return new GnuRSAPrivateKey(rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent());
        }
        if (aKeySpec instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)aKeySpec;
            ECParameterSpec eCParameterSpec = eCPrivateKeySpec.getParams();
            ECDomainParameter eCDomainParameter = ECDomainParameter.getInstance(eCParameterSpec);
            return new ECDSAPrivateKey(eCDomainParameter, eCPrivateKeySpec.getS());
        }
        throw new UnknownElement(a[6] + aKeySpec);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "iF>F\u001dgm\u0001\u001fTU\b!JMVG KXB\u0012";
        int n2 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block18;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 38;
                                break;
                            }
                            case 1: {
                                n8 = 40;
                                break;
                            }
                            case 2: {
                                n8 = 82;
                                break;
                            }
                            case 3: {
                                n8 = 63;
                                break;
                            }
                            default: {
                                n8 = 61;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "gm\u0001";
                    n2 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "gm\u0001";
                    n2 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "sF9QRQFrTX_\b!OXE\b";
                    n2 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "cZ PO\u0006A<\u001fVCQrXXHI ^IOF5";
                    n2 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "sF9QRQFrTX_\b!OXE\b";
                    n2 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "sF9QRQFrTX_\b!OXE\b";
                    n2 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

