/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu;

import tr.gov.tubitak.uekae.esya.api.crypto.Cipher;
import tr.gov.tubitak.uekae.esya.api.crypto.Digester;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyPairGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.MAC;
import tr.gov.tubitak.uekae.esya.api.crypto.RandomGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.Signer;
import tr.gov.tubitak.uekae.esya.api.crypto.Verifier;
import tr.gov.tubitak.uekae.esya.api.crypto.Wrapper;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.KeyAgreementAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MACAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.PBEAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.WrapAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.CryptoProvider;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.core.PBEDecryptor;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.core.PBEEncryptor;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUAESWrapper;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUAsymmetricDecryptor;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUAsymmetricEncryptor;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUDecryptor;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUDigester;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUEncryptor;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUKeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUKeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUKeyPairGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUMAC;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNURandomGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUSigner;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.gnu.GNUVerifier;

public class GNUCryptoProvider
implements CryptoProvider {
    private static final String[] a;

    public Cipher getEncryptor(CipherAlg aCipherAlg) throws CryptoException {
        if (aCipherAlg instanceof PBEAlg) {
            return new PBEEncryptor((PBEAlg)aCipherAlg);
        }
        if (aCipherAlg.getName().toLowerCase().startsWith(a[0])) {
            return new GNUAsymmetricEncryptor(aCipherAlg);
        }
        return new GNUEncryptor(aCipherAlg);
    }

    public Cipher getDecryptor(CipherAlg aCipherAlg) throws CryptoException {
        if (aCipherAlg instanceof PBEAlg) {
            return new PBEDecryptor((PBEAlg)aCipherAlg);
        }
        if (aCipherAlg.getName().toLowerCase().startsWith(a[1])) {
            return new GNUAsymmetricDecryptor(aCipherAlg);
        }
        return new GNUDecryptor(aCipherAlg);
    }

    public Digester getDigester(DigestAlg aDigestAlg) throws CryptoException {
        return new GNUDigester(aDigestAlg);
    }

    public Signer getSigner(SignatureAlg aSignatureAlg) throws CryptoException {
        return new GNUSigner(aSignatureAlg);
    }

    public Verifier getVerifier(SignatureAlg aSignatureAlg) throws CryptoException {
        return new GNUVerifier(aSignatureAlg);
    }

    public MAC getMAC(MACAlg aMACAlg) throws CryptoException {
        return new GNUMAC(aMACAlg);
    }

    public Wrapper getWrapper(WrapAlg aWrapAlg) throws CryptoException {
        return new GNUAESWrapper((Algorithm)aWrapAlg, true);
    }

    public Wrapper getUnwrapper(WrapAlg aWrapAlg) throws CryptoException {
        return new GNUAESWrapper((Algorithm)aWrapAlg, false);
    }

    public KeyAgreement getKeyAgreement(KeyAgreementAlg aKeyAgreementAlg) throws CryptoException {
        return new GNUKeyAgreement(aKeyAgreementAlg);
    }

    public KeyFactory getKeyFactory() throws CryptoException {
        return new GNUKeyFactory();
    }

    public KeyPairGenerator getKeyPairGenerator(AsymmetricAlg aAsymmetricAlg) throws CryptoException {
        return new GNUKeyPairGenerator(aAsymmetricAlg);
    }

    public RandomGenerator getRandomGenerator() {
        return new GNURandomGenerator();
    }

    public boolean isFipsMode() {
        return false;
    }

    public void destroyProvider() {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0003\fm";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 113;
                                break;
                            }
                            case 1: {
                                n8 = 127;
                                break;
                            }
                            case 2: {
                                n8 = 12;
                                break;
                            }
                            case 3: {
                                n8 = 14;
                                break;
                            }
                            default: {
                                n8 = 25;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u0003\fm";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

