/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.prng.JavaRandomGenerator;
import gnu.crypto.sig.rsa.RSA;
import gnu.crypto.util.PRNG;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.crypto.IRandom;
import tr.gov.tubitak.uekae.esya.api.common.util.UtilBytes;
import tr.gov.tubitak.uekae.esya.api.crypto.Crypto;
import tr.gov.tubitak.uekae.esya.api.crypto.Signer;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;

public class RSA_SSCD {
    protected BaseSigner mSigner;
    protected int blockSize;
    protected BigInteger mModulus;
    protected DigestAlg mDigestAlg;
    protected RSAPublicKey mPublicKey;
    protected RSAPrivateKey mPrivKey;
    protected static Logger LOGGER;
    byte[] a;
    private static final String[] b;

    public static final RSA_SSCD getInstance(DigestAlg aDigestAlg, IRandom aRand) {
        if (aRand == null) {
            return new RSA_SSCD(aDigestAlg, (IRandom)new JavaRandomGenerator());
        }
        return new RSA_SSCD(aDigestAlg, aRand);
    }

    public static final RSA_SSCD getInstance(DigestAlg aDigestAlg) {
        return new RSA_SSCD(aDigestAlg, (IRandom)new JavaRandomGenerator());
    }

    private RSA_SSCD(DigestAlg digestAlg, IRandom iRandom) {
        this.mDigestAlg = digestAlg;
    }

    public void setupForVerification(PublicKey key) throws IllegalArgumentException {
        if (!(key instanceof RSAPublicKey)) {
            throw new IllegalArgumentException(b[0]);
        }
        this.mPublicKey = (RSAPublicKey)key;
    }

    public void setupForSigning(PrivateKey key) throws IllegalArgumentException, CryptoException {
        if (!(key instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException(b[3]);
        }
        this.mPrivKey = (RSAPrivateKey)key;
        this.mModulus = ((RSAPrivateKey)key).getModulus();
        this.blockSize = (((RSAPrivateKey)key).getModulus().bitLength() + 7) / 8;
        Signer signer = Crypto.getSigner((SignatureAlg)SignatureAlg.RSA_RAW);
        signer.init(key);
        this.mSigner = signer;
    }

    public void setupForSigning(BaseSigner signer, BigInteger modulus) {
        this.mModulus = modulus;
        this.blockSize = (modulus.bitLength() + 7) / 8;
        this.mSigner = signer;
    }

    public byte[] generateSignature(byte[] dataToBeSigned, byte[] dataToBeRecovered) throws IllegalStateException, ESYAException {
        byte[] byArray = new byte[this.blockSize];
        byArray[0] = 106;
        byte[] byArray2 = new byte[this.blockSize - 2 - this.mDigestAlg.getDigestLength() - dataToBeRecovered.length];
        try {
            PRNG.nextBytes(byArray2, 0, byArray2.length);
            System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
            System.arraycopy(dataToBeRecovered, 0, byArray, byArray.length - 1 - this.mDigestAlg.getDigestLength() - dataToBeRecovered.length, dataToBeRecovered.length);
            byte[] byArray3 = UtilBytes.concatAll((byte[])byArray2, (byte[][])new byte[][]{dataToBeSigned});
            byte[] byArray4 = DigestUtil.digest((DigestAlg)this.mDigestAlg, (byte[])byArray3);
            System.arraycopy(byArray4, 0, byArray, byArray.length - 1 - byArray4.length, byArray4.length);
            byArray[byArray.length - 1] = -68;
            byte[] byArray5 = this.mSigner.sign(byArray);
            BigInteger bigInteger = new BigInteger(1, byArray5);
            if (this.mModulus.divide(BigInteger.valueOf(2L)).compareTo(bigInteger) == -1) {
                bigInteger = this.mModulus.subtract(bigInteger);
            }
            return RSA.I2OSP(bigInteger, this.blockSize);
        }
        catch (CryptoException cryptoException) {
            new RuntimeException(b[2], cryptoException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifySignature(byte[] signature, byte[] aDataThatisIncludedByMe, int aLenOfDataToBeRecovered) throws IllegalStateException {
        boolean bl;
        BigInteger bigInteger;
        BigInteger bigInteger2 = new BigInteger(1, signature);
        try {
            bigInteger = RSA.verify(this.mPublicKey, bigInteger2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        byte[] byArray = bigInteger.toByteArray();
        byte by = -52;
        byte by2 = -68;
        boolean bl3 = byArray[byArray.length - 1] == by2;
        boolean bl2 = byArray[byArray.length - 1] == by && byArray[byArray.length - 2] == 51;
        boolean bl4 = bl = byArray[byArray.length - 1] == by && byArray[byArray.length - 2] == 52;
        if (!(bl3 || bl2 || bl)) {
            bigInteger = this.mPublicKey.getModulus().subtract(bigInteger);
            byArray = bigInteger.toByteArray();
            bl3 = byArray[byArray.length - 1] == by2;
            bl2 = byArray[byArray.length - 1] == by && byArray[byArray.length - 2] == 51;
            boolean bl5 = bl = byArray[byArray.length - 1] == by && byArray[byArray.length - 2] == 52;
        }
        if (!(bl3 || bl2 || bl)) {
            return false;
        }
        int n = 1;
        if (bl2 || bl) {
            n = 2;
        }
        int n2 = this.mDigestAlg.getDigestLength();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, byArray.length - n - n2, byArray2, 0, n2);
        byte[] byArray3 = new byte[byArray.length - n - n2 - 1];
        System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
        byte[] byArray4 = UtilBytes.concatAll((byte[])byArray3, (byte[][])new byte[][]{aDataThatisIncludedByMe});
        byte[] byArray5 = null;
        try {
            byArray5 = DigestUtil.digest((DigestAlg)this.mDigestAlg, (byte[])byArray4);
        }
        catch (CryptoException cryptoException) {
            LOGGER.error(b[1], (Throwable)cryptoException);
            return false;
        }
        if (Arrays.equals(byArray5, byArray2)) {
            this.a = new byte[aLenOfDataToBeRecovered];
            System.arraycopy(byArray3, byArray3.length - aLenOfDataToBeRecovered, this.a, 0, aLenOfDataToBeRecovered);
            return true;
        }
        return false;
    }

    public byte[] getDataRecovered() {
        return this.a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "h;\u001ayJX\u00042Jt_\u0011{@QI\u001c:G\\_H>QO_\u000b/L[";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 58;
                                break;
                            }
                            case 1: {
                                n8 = 104;
                                break;
                            }
                            case 2: {
                                n8 = 91;
                                break;
                            }
                            case 3: {
                                n8 = 41;
                                break;
                            }
                            default: {
                                n8 = 63;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "y\t5\tQU\u001c{J^V\u000b.E^N\r{MV]\r(]";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "~\u0001<LLNH+[PX\u0004>D";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "h;\u001ayMS\u001e:]Zq\r\"\tVT\u001b/HQY\r{LGJ\r8]Z^";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        b = stringArray3;
        LOGGER = LoggerFactory.getLogger(RSA_SSCD.class);
    }
}

