/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.sig.BaseSignature;
import gnu.crypto.sig.rsa.EMSA_PKCS1_V1_5;
import gnu.crypto.sig.rsa.EMSA_PKCS1_V1_5_WithErroneousAlgId;
import gnu.crypto.sig.rsa.RSA;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class RSAPKCS1V1_5Signature
extends BaseSignature {
    private EMSA_PKCS1_V1_5 d;
    private static final String[] e;

    public RSAPKCS1V1_5Signature() {
        this(e[1]);
    }

    public RSAPKCS1V1_5Signature(String mdName) {
        super(e[0], HashFactory.getInstance(mdName));
        this.d = EMSA_PKCS1_V1_5.getInstance(mdName);
    }

    private RSAPKCS1V1_5Signature(RSAPKCS1V1_5Signature rSAPKCS1V1_5Signature) {
        this(rSAPKCS1V1_5Signature.md.name());
        this.publicKey = rSAPKCS1V1_5Signature.publicKey;
        this.privateKey = rSAPKCS1V1_5Signature.privateKey;
        this.md = (IMessageDigest)rSAPKCS1V1_5Signature.md.clone();
        this.d = (EMSA_PKCS1_V1_5)rSAPKCS1V1_5Signature.d.clone();
    }

    @Override
    public Object clone() {
        return new RSAPKCS1V1_5Signature(this);
    }

    @Override
    protected void setupForVerification(PublicKey k) throws IllegalArgumentException {
        if (!(k instanceof RSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = k;
    }

    @Override
    protected void setupForSigning(PrivateKey k) throws IllegalArgumentException {
        if (!(k instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = k;
    }

    @Override
    protected Object generateSignature() throws IllegalStateException {
        int n = ((RSAPrivateKey)this.privateKey).getModulus().bitLength();
        int n2 = (n + 7) / 8;
        byte[] byArray = this.d.encode(this.md.digest(), n2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSA.sign(this.privateKey, bigInteger);
        return RSA.I2OSP(bigInteger2, n2);
    }

    @Override
    protected boolean verifySignature(Object sig) throws IllegalStateException {
        byte[] byArray;
        BigInteger bigInteger;
        if (this.publicKey == null) {
            throw new IllegalStateException();
        }
        byte[] byArray2 = (byte[])sig;
        int n = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        int n2 = (n + 7) / 8;
        if (byArray2.length != n2) {
            return false;
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        try {
            bigInteger = RSA.verify(this.publicKey, bigInteger2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        try {
            byArray = RSA.I2OSP(bigInteger, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        byte[] byArray3 = this.md.digest();
        byte[] byArray4 = this.d.encode(byArray3, n2);
        boolean bl = Arrays.equals(byArray, byArray4);
        if (!bl) {
            EMSA_PKCS1_V1_5_WithErroneousAlgId eMSA_PKCS1_V1_5_WithErroneousAlgId = EMSA_PKCS1_V1_5_WithErroneousAlgId.getInstance(this.md.name());
            byte[] byArray5 = eMSA_PKCS1_V1_5_WithErroneousAlgId.encode(byArray3, n2);
            return Arrays.equals(byArray, byArray5);
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "}\r]\u0012*d\u001dO\u000ewyO\u0012\n";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 15;
                                break;
                            }
                            case 1: {
                                n8 = 126;
                                break;
                            }
                            case 2: {
                                n8 = 60;
                                break;
                            }
                            case 3: {
                                n8 = 63;
                                break;
                            }
                            default: {
                                n8 = 90;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "|\u0016]\u0012k9N";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

