/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.derivationFunctions.MGF1;
import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.Sha160;
import gnu.crypto.sig.rsa.RSA;
import gnu.crypto.util.PRNG;
import java.security.interfaces.RSAKey;
import tr.gov.tubitak.uekae.esya.api.common.crypto.IRandom;
import tr.gov.tubitak.uekae.esya.api.common.crypto.LimitReachedException;

public class EME_OAEP {
    private IMessageDigest a;
    private IRandom b;
    private int c;
    private static final String[] d;

    private EME_OAEP(IMessageDigest iMessageDigest, int n, IRandom iRandom) {
        this.a = iMessageDigest;
        this.b = iRandom;
        this.c = n;
    }

    public static EME_OAEP getInstance(RSAKey key) {
        int n = (key.getModulus().bitLength() + 7) / 8;
        return EME_OAEP.getInstance(n);
    }

    public static EME_OAEP getInstance(int blockSize) {
        return new EME_OAEP(new Sha160(), blockSize, null);
    }

    public static EME_OAEP getInstance(String mdName, int blockSize) {
        IMessageDigest iMessageDigest = HashFactory.getInstance(mdName);
        return new EME_OAEP(iMessageDigest, blockSize, null);
    }

    public static EME_OAEP getInstance(String mdName, int blockSize, IRandom irnd) {
        IMessageDigest iMessageDigest = HashFactory.getInstance(mdName);
        return new EME_OAEP(iMessageDigest, blockSize, irnd);
    }

    public byte[] encode(byte[] M) {
        return this.encode(M, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encode(byte[] M, byte[] label) {
        byte[] byArray;
        byte[] byArray2;
        boolean bl;
        block17: {
            block19: {
                block18: {
                    bl = RSA.c;
                    if (M.length > this.c - 2 * this.a.hashSize() - 2) {
                        throw new IllegalArgumentException(d[0]);
                    }
                    byArray2 = new byte[this.c - this.a.hashSize() - 1];
                    System.arraycopy(M, 0, byArray2, byArray2.length - M.length, M.length);
                    byArray2[byArray2.length - M.length - 1] = 1;
                    if (label != null) break block18;
                    this.a.update(null, 0, 0);
                    if (!bl) break block19;
                }
                this.a.update(label, 0, label.length);
            }
            byte[] byArray3 = this.a.digest();
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            byArray = new byte[this.a.hashSize()];
            try {
                if (this.b != null) {
                    this.b.nextBytes(byArray, 0, byArray.length);
                    if (!bl) break block17;
                }
                PRNG.nextBytes(byArray, 0, byArray.length);
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException(d[1] + String.valueOf(illegalStateException));
            }
            catch (LimitReachedException limitReachedException) {
                throw new RuntimeException(d[2] + String.valueOf((Object)limitReachedException));
            }
        }
        byte[] byArray4 = MGF1.generateBytes(byArray, byArray2.length, this.a);
        for (int k = 0; k < byArray4.length; ++k) {
            int n = k;
            byArray2[n] = (byte)(byArray2[n] ^ byArray4[k]);
            if (!bl) continue;
        }
        byte[] byArray5 = MGF1.generateBytes(byArray2, byArray.length, this.a);
        for (int k = 0; k < byArray5.length; ++k) {
            int n = k;
            byArray[n] = (byte)(byArray[n] ^ byArray5[k]);
            if (!bl) continue;
        }
        byte[] byArray6 = new byte[this.c];
        byArray6[0] = 0;
        System.arraycopy(byArray, 0, byArray6, 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray6, 1 + byArray.length, byArray2.length);
        return byArray6;
    }

    public byte[] decode(byte[] EM) {
        return this.decode(EM, null);
    }

    public byte[] decode(byte[] EM, byte[] label) {
        byte[] byArray;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    int n;
                    byte[] byArray2;
                    boolean bl2;
                    block31: {
                        block30: {
                            block29: {
                                bl2 = RSA.c;
                                if (this.c != EM.length) {
                                    throw new IllegalArgumentException(d[5]);
                                }
                                if (this.c < 2 * this.a.hashSize() + 2) {
                                    throw new IllegalArgumentException(d[3]);
                                }
                                byte[] byArray3 = new byte[this.a.hashSize()];
                                byte[] byArray4 = new byte[this.c - this.a.hashSize() - 1];
                                System.arraycopy(EM, 1, byArray3, 0, byArray3.length);
                                System.arraycopy(EM, 1 + byArray3.length, byArray4, 0, byArray4.length);
                                byte[] byArray5 = MGF1.generateBytes(byArray4, this.a.hashSize(), this.a);
                                byte[] byArray6 = byArray3;
                                for (int k = 0; k < byArray5.length; ++k) {
                                    int n2 = k;
                                    byArray6[n2] = (byte)(byArray6[n2] ^ byArray5[k]);
                                    if (!bl2) continue;
                                }
                                byte[] byArray7 = MGF1.generateBytes(byArray6, this.c - this.a.hashSize() - 1, this.a);
                                byArray2 = byArray4;
                                for (int k = 0; k < byArray7.length; ++k) {
                                    int n3 = k;
                                    byArray2[n3] = (byte)(byArray2[n3] ^ byArray7[k]);
                                    if (!bl2) continue;
                                }
                                if (label != null) break block29;
                                this.a.update(null, 0, 0);
                                if (!bl2) break block30;
                            }
                            this.a.update(label, 0, label.length);
                        }
                        byte[] byArray8 = this.a.digest();
                        if (EM[0] != 0) {
                            throw new IllegalArgumentException(d[7]);
                        }
                        for (n = 0; n < byArray8.length; ++n) {
                            if (byArray8[n] == byArray2[n]) continue;
                            throw new IllegalArgumentException(d[4]);
                        }
                        for (n = this.a.hashSize(); n < byArray2.length; ++n) {
                            if (byArray2[n] != 0) break;
                            if (!bl2) continue;
                            break;
                        }
                        if (n < byArray2.length && byArray2[n] == 1) break block31;
                        throw new IllegalArgumentException(d[6]);
                    }
                    byte[] byArray9 = new byte[byArray2.length - ++n];
                    System.arraycopy(byArray2, byArray2.length - byArray9.length, byArray9, 0, byArray9.length);
                    byArray = byArray9;
                    if (BaseCipher.b == 0) break block32;
                    if (!bl2) break block33;
                    bl = false;
                    break block34;
                }
                bl = true;
            }
            RSA.c = bl;
        }
        return byArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "k\u001eVp\u001ea\u001e\u0005w\u0010i[Il\u0011a";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 6;
                                break;
                            }
                            case 1: {
                                n8 = 123;
                                break;
                            }
                            case 2: {
                                n8 = 37;
                                break;
                            }
                            case 3: {
                                n8 = 3;
                                break;
                            }
                            default: {
                                n8 = 127;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "c\u0015Fl\u001bcS\f9_";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "c\u0015Fl\u001bcS\f9_";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "b\u001eFq\u0006v\u000fLl\u0011&\u001eWq\u0010t";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "b\u001eFq\u0006v\u000fLl\u0011&\u001eWq\u0010t";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "b\u001eFq\u0006v\u000fLl\u0011&\u001eWq\u0010t";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "b\u001eFq\u0006v\u000fLl\u0011&\u001eWq\u0010t";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "b\u001eFq\u0006v\u000fLl\u0011&\u001eWq\u0010t";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        d = stringArray3;
    }
}

