/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.curve.CurveFp;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECGNUPoint;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.util.Prime;
import java.math.BigInteger;

public class ECPointFp
extends ECGNUPoint {
    private static final int c = 1;
    BigInteger d;
    BigInteger e;
    BigInteger f;
    private static final String[] g;

    public ECPointFp(Curve aCurve, byte[] aOctet) throws EllipticCurveException {
        super(aCurve);
        BigInteger[] bigIntegerArray = this.fromOctetString(aOctet);
        this.d = bigIntegerArray[0];
        this.e = bigIntegerArray[1];
        this.f = BigInteger.ONE;
        if (!(aCurve instanceof CurveFp)) {
            throw new EllipticCurveException(g[0]);
        }
    }

    public ECPointFp(Curve aCurve, BigInteger aX, BigInteger aY) {
        super(aCurve);
        this.d = aX;
        this.e = aY;
        this.f = BigInteger.ONE;
    }

    public ECPointFp(CurveFp aCurve, BigInteger aX, BigInteger aY) {
        super(aCurve);
        this.d = aX;
        this.e = aY;
        this.f = BigInteger.ONE;
    }

    public ECPointFp(CurveFp aCurve, BigInteger aX, BigInteger aY, BigInteger aZ) {
        super(aCurve);
        this.d = aX;
        this.e = aY;
        this.f = aZ;
    }

    @Override
    protected ECGNUPoint _add(ECGNUPoint aElem) {
        ECPointFp eCPointFp = (ECPointFp)aElem;
        switch (1) {
            case 1: {
                BigInteger[] bigIntegerArray = this.a(eCPointFp.d, eCPointFp.e, eCPointFp.f);
                return new ECPointFp((CurveFp)this.mCurve, bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2]);
            }
        }
        BigInteger[] bigIntegerArray = this.a(aElem.getAffineX(), aElem.getAffineY());
        return new ECPointFp((CurveFp)this.mCurve, bigIntegerArray[0], bigIntegerArray[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigInteger[] a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger7;
        block6: {
            BigInteger bigInteger8;
            bigInteger7 = this.mField.getMSize();
            if (!this.d.equals(bigInteger)) break block6;
            if (!this.e.equals(bigInteger2)) throw new IllegalArgumentException();
            if (!this.f.equals(bigInteger3)) throw new IllegalArgumentException();
            BigInteger bigInteger9 = this.e.multiply(this.e).mod(bigInteger7);
            BigInteger bigInteger10 = this.f.multiply(this.f).mod(bigInteger7);
            BigInteger bigInteger11 = this.d.multiply(bigInteger9).shiftLeft(2).mod(bigInteger7);
            BigInteger bigInteger12 = this.d.multiply(this.d).mod(bigInteger7);
            BigInteger bigInteger13 = bigInteger12.shiftLeft(1).add(bigInteger12).add(this.mCurve.mA.multiply(bigInteger10).mod(bigInteger7).multiply(bigInteger10).mod(bigInteger7)).mod(bigInteger7);
            bigInteger6 = bigInteger8 = bigInteger13.multiply(bigInteger13).mod(bigInteger7).subtract(bigInteger11.shiftLeft(1)).mod(bigInteger7);
            bigInteger12 = bigInteger9.multiply(bigInteger9).mod(bigInteger7);
            bigInteger12 = bigInteger12.shiftLeft(3).mod(bigInteger7);
            bigInteger5 = bigInteger13.multiply(bigInteger11.subtract(bigInteger8).mod(bigInteger7)).subtract(bigInteger12).mod(bigInteger7);
            bigInteger12 = this.e.multiply(this.f).mod(bigInteger7);
            bigInteger4 = bigInteger12.shiftLeft(1).mod(bigInteger7);
            if (ECGNUPoint.b == 0) return new BigInteger[]{bigInteger6, bigInteger5, bigInteger4};
            throw new IllegalArgumentException();
        }
        BigInteger bigInteger14 = this.f.multiply(this.f).mod(bigInteger7);
        BigInteger bigInteger15 = bigInteger3.multiply(bigInteger3).mod(bigInteger7);
        BigInteger bigInteger16 = this.d.multiply(bigInteger15).mod(bigInteger7);
        BigInteger bigInteger17 = bigInteger.multiply(bigInteger14).mod(bigInteger7);
        BigInteger bigInteger18 = this.e.multiply(bigInteger15).multiply(bigInteger3).mod(bigInteger7);
        BigInteger bigInteger19 = bigInteger2.multiply(bigInteger14).multiply(this.f).mod(bigInteger7);
        BigInteger bigInteger20 = bigInteger17.subtract(bigInteger16).mod(bigInteger7);
        BigInteger bigInteger21 = bigInteger19.subtract(bigInteger18).mod(bigInteger7);
        BigInteger bigInteger22 = bigInteger20.multiply(bigInteger20).mod(bigInteger7);
        BigInteger bigInteger23 = bigInteger22.multiply(bigInteger20);
        BigInteger bigInteger24 = bigInteger22.multiply(bigInteger16).mod(bigInteger7);
        bigInteger6 = bigInteger21.multiply(bigInteger21).subtract(bigInteger23).subtract(bigInteger24.shiftLeft(1).mod(bigInteger7)).mod(bigInteger7);
        bigInteger5 = bigInteger21.multiply(bigInteger24.subtract(bigInteger6)).mod(bigInteger7).subtract(bigInteger23.multiply(bigInteger18).mod(bigInteger7)).mod(bigInteger7);
        bigInteger4 = this.f.multiply(bigInteger3).mod(bigInteger7).multiply(bigInteger20).mod(bigInteger7);
        return new BigInteger[]{bigInteger6, bigInteger5, bigInteger4};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigInteger[] a(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger7;
        block6: {
            block5: {
                bigInteger7 = this.getAffineX();
                bigInteger6 = this.getAffineY();
                bigInteger5 = this.mField.getMSize();
                if (!bigInteger7.equals(bigInteger)) break block5;
                if (!bigInteger6.equals(bigInteger2)) throw new IllegalArgumentException();
                BigInteger bigInteger8 = bigInteger7.multiply(bigInteger7).mod(bigInteger5);
                bigInteger4 = bigInteger8.add(bigInteger8).add(bigInteger8).add(this.mCurve.mA).mod(bigInteger5);
                bigInteger3 = bigInteger6.add(bigInteger6).mod(bigInteger5);
                if (ECGNUPoint.b != 0) {
                    throw new IllegalArgumentException();
                }
                break block6;
            }
            bigInteger4 = bigInteger2.subtract(bigInteger6).mod(bigInteger5);
            bigInteger3 = bigInteger.subtract(bigInteger7).mod(bigInteger5);
        }
        BigInteger bigInteger9 = bigInteger4.multiply(bigInteger3.modInverse(bigInteger5)).remainder(bigInteger5);
        BigInteger bigInteger10 = bigInteger9.multiply(bigInteger9).mod(bigInteger5).subtract(bigInteger7).subtract(bigInteger).mod(bigInteger5);
        BigInteger bigInteger11 = bigInteger9.multiply(bigInteger7.subtract(bigInteger10).mod(bigInteger5)).subtract(bigInteger6).mod(bigInteger5);
        return new BigInteger[]{bigInteger10, bigInteger11};
    }

    @Override
    protected void _addToThis(ECGNUPoint aElem) {
        ECPointFp eCPointFp = (ECPointFp)aElem;
        switch (1) {
            case 1: {
                BigInteger[] bigIntegerArray = this.a(eCPointFp.d, eCPointFp.e, eCPointFp.f);
                this.d = bigIntegerArray[0];
                this.e = bigIntegerArray[1];
                this.f = bigIntegerArray[2];
                if (ECGNUPoint.b == 0) break;
            }
            default: {
                BigInteger[] bigIntegerArray = this.a(aElem.getAffineX(), aElem.getAffineY());
                this.d = bigIntegerArray[0];
                this.e = bigIntegerArray[1];
                this.f = BigInteger.ONE;
            }
        }
    }

    @Override
    public ECGNUPoint negate() {
        ECPointFp eCPointFp = (ECPointFp)this.clone();
        eCPointFp.e = eCPointFp.e.negate();
        return eCPointFp;
    }

    @Override
    public void negateThis() {
        this.e.negate();
    }

    @Override
    protected boolean _ypTilda() {
        return this.getAffineY().testBit(0);
    }

    @Override
    protected BigInteger _convert(BigInteger aXP, int aYTilda) throws EllipticCurveException {
        BigInteger bigInteger = this.mField.getMSize();
        BigInteger bigInteger2 = this.mCurve.mA;
        BigInteger bigInteger3 = this.mCurve.mB;
        BigInteger bigInteger4 = aXP.pow(3).remainder(bigInteger).add(bigInteger2.multiply(aXP)).add(bigInteger3).remainder(bigInteger);
        BigInteger bigInteger5 = Prime.modPrimeSqrt(bigInteger4, bigInteger);
        int n = bigInteger5.testBit(0) ? 1 : 0;
        int n2 = n;
        if (n2 == aYTilda) {
            return bigInteger5;
        }
        return bigInteger.subtract(bigInteger5);
    }

    @Override
    public Object clone() {
        return new ECPointFp((CurveFp)this.mCurve, this.d, this.e, this.f);
    }

    @Override
    public boolean equals(Object aObject) {
        boolean bl;
        block20: {
            block19: {
                ECPointFp eCPointFp;
                block18: {
                    block17: {
                        if (aObject != null && aObject instanceof ECPointFp) break block17;
                        return false;
                    }
                    eCPointFp = (ECPointFp)aObject;
                    if (!this.d.equals(eCPointFp.d) || !this.e.equals(eCPointFp.e)) break block18;
                    if (!this.f.equals(eCPointFp.f)) break block18;
                    return true;
                }
                BigInteger bigInteger = this.mField.getMSize();
                if (!bigInteger.equals(eCPointFp.mField.getMSize())) {
                    return false;
                }
                BigInteger bigInteger2 = this.f.multiply(this.f).mod(bigInteger);
                BigInteger bigInteger3 = this.f.multiply(bigInteger2).mod(bigInteger);
                BigInteger bigInteger4 = eCPointFp.f.multiply(eCPointFp.f).mod(bigInteger);
                BigInteger bigInteger5 = eCPointFp.f.multiply(bigInteger4).mod(bigInteger);
                if (!this.d.multiply(bigInteger4).mod(bigInteger).equals(eCPointFp.d.multiply(bigInteger2).mod(bigInteger)) || !this.e.multiply(bigInteger5).mod(bigInteger).equals(eCPointFp.e.multiply(bigInteger3).mod(bigInteger))) break block19;
                bl = true;
                break block20;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public BigInteger getAffineX() {
        BigInteger bigInteger = this.mField.getMSize();
        return this.d.multiply(this.f.multiply(this.f).modInverse(bigInteger)).mod(bigInteger);
    }

    @Override
    public BigInteger getAffineY() {
        BigInteger bigInteger = this.mField.getMSize();
        return this.e.multiply(this.f.multiply(this.f).mod(bigInteger).multiply(this.f).modInverse(bigInteger)).mod(bigInteger);
    }

    public String toString() {
        String string = "(" + this.d + "," + this.e + "," + this.f + g[1];
        string = string + g[2] + this.getAffineX() + "," + this.getAffineY();
        return string;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "14nj~_+h#r\u001a{|#z\u0013?:)j\r-\u007fk";
        int n2 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block14;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 127;
                                break;
                            }
                            case 1: {
                                n8 = 91;
                                break;
                            }
                            case 2: {
                                n8 = 26;
                                break;
                            }
                            case 3: {
                                n8 = 74;
                                break;
                            }
                            default: {
                                n8 = 31;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "VQ";
                    n2 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "_{:";
                    n2 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        g = stringArray3;
    }
}

