/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.curve.CurveF2m;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECGNUPoint;
import gnu.crypto.sig.ecdsa.ecmath.curve.ElementF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveRuntimeException;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldF2mPolynomial;
import gnu.crypto.util.PRNG;
import java.math.BigInteger;

public class ECPointF2mPolynomial
extends ECGNUPoint {
    private ElementF2mPolynomial c;
    private ElementF2mPolynomial d;
    private ElementF2mPolynomial e;
    private final CurveF2m f;
    private static final String[] g;

    public ECPointF2mPolynomial(Curve aCurve, byte[] aOctet) throws EllipticCurveException {
        super(aCurve);
        if (!(this.mCurve instanceof CurveF2m)) {
            throw new EllipticCurveException(g[2]);
        }
        if (!(this.mField instanceof FieldF2mPolynomial)) {
            throw new EllipticCurveException(g[3]);
        }
        this.f = (CurveF2m)this.mCurve;
        BigInteger[] bigIntegerArray = this.fromOctetString(aOctet);
        this.c = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, bigIntegerArray[0]);
        this.d = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, bigIntegerArray[1]);
        this.e = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, BigInteger.ONE);
    }

    public ECPointF2mPolynomial(CurveF2m aCurve, BigInteger aX, BigInteger aY) {
        super(aCurve);
        this.f = aCurve;
        this.c = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, aX);
        this.d = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, aY);
        this.e = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, BigInteger.ONE);
        if (!(this.mField instanceof FieldF2mPolynomial)) {
            throw new EllipticCurveRuntimeException(g[5]);
        }
    }

    public ECPointF2mPolynomial(CurveF2m aCurve, BigInteger aX, BigInteger aY, BigInteger aZ) {
        super(aCurve);
        this.f = aCurve;
        this.c = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, aX);
        this.d = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, aY);
        this.e = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, aZ);
        if (!(this.mField instanceof FieldF2mPolynomial)) {
            throw new EllipticCurveRuntimeException(g[4]);
        }
    }

    @Override
    protected ECGNUPoint _add(ECGNUPoint aElem) {
        ECPointF2mPolynomial eCPointF2mPolynomial = (ECPointF2mPolynomial)aElem;
        ElementF2mPolynomial[] elementF2mPolynomialArray = this.a(eCPointF2mPolynomial.c, eCPointF2mPolynomial.d, eCPointF2mPolynomial.e);
        return new ECPointF2mPolynomial(this.f, elementF2mPolynomialArray[0].getMElem(), elementF2mPolynomialArray[1].getMElem(), elementF2mPolynomialArray[2].getMElem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ElementF2mPolynomial[] a(ElementF2mPolynomial elementF2mPolynomial, ElementF2mPolynomial elementF2mPolynomial2, ElementF2mPolynomial elementF2mPolynomial3) {
        ElementF2mPolynomial elementF2mPolynomial4;
        ElementF2mPolynomial elementF2mPolynomial5;
        ElementF2mPolynomial elementF2mPolynomial6;
        block9: {
            if (!this.c.equals(elementF2mPolynomial)) break block9;
            if (!this.d.equals(elementF2mPolynomial2)) throw new IllegalArgumentException();
            if (!this.e.equals(elementF2mPolynomial3)) throw new IllegalArgumentException();
            ElementF2mPolynomial elementF2mPolynomial7 = this.e.sqr();
            elementF2mPolynomial6 = this.c.unsafeMultiply(elementF2mPolynomial7);
            elementF2mPolynomial5 = elementF2mPolynomial7.sqr().sqr();
            elementF2mPolynomial5.unsafeMultiplyThisBy(this.f.b);
            elementF2mPolynomial5.unsafeAddToThis(this.c.sqr().sqr());
            ElementF2mPolynomial elementF2mPolynomial8 = this.c.sqr();
            ElementF2mPolynomial elementF2mPolynomial9 = elementF2mPolynomial8.sqr();
            elementF2mPolynomial8.unsafeAddToThis(this.d.unsafeMultiply(this.e));
            elementF2mPolynomial8.unsafeAddToThis(elementF2mPolynomial6);
            elementF2mPolynomial4 = elementF2mPolynomial5.unsafeMultiply(elementF2mPolynomial8);
            elementF2mPolynomial9.unsafeMultiplyThisBy(elementF2mPolynomial6);
            elementF2mPolynomial4.unsafeAddToThis(elementF2mPolynomial9);
            if (ECGNUPoint.b == 0) return new ElementF2mPolynomial[]{elementF2mPolynomial5, elementF2mPolynomial4, elementF2mPolynomial6};
            throw new IllegalArgumentException();
        }
        a.start();
        ElementF2mPolynomial elementF2mPolynomial10 = this.e.sqr();
        ElementF2mPolynomial elementF2mPolynomial11 = elementF2mPolynomial3.sqr();
        ElementF2mPolynomial elementF2mPolynomial12 = this.c.unsafeMultiply(elementF2mPolynomial11);
        ElementF2mPolynomial elementF2mPolynomial13 = elementF2mPolynomial.unsafeMultiply(elementF2mPolynomial10);
        elementF2mPolynomial10.unsafeMultiplyThisBy(this.e);
        elementF2mPolynomial11.unsafeMultiplyThisBy(elementF2mPolynomial3);
        elementF2mPolynomial13.unsafeAddToThis(elementF2mPolynomial12);
        if (elementF2mPolynomial13.getMElem().equals(BigInteger.ZERO)) {
            return this.a(this.c, this.d, this.e);
        }
        elementF2mPolynomial11.unsafeMultiplyThisBy(this.d);
        elementF2mPolynomial10.unsafeMultiplyThisBy(elementF2mPolynomial2);
        elementF2mPolynomial10.unsafeAddToThis(elementF2mPolynomial11);
        ElementF2mPolynomial elementF2mPolynomial14 = elementF2mPolynomial10.sqr();
        elementF2mPolynomial6 = elementF2mPolynomial13.unsafeMultiply(this.e);
        elementF2mPolynomial6.unsafeMultiplyThisBy(elementF2mPolynomial3);
        ElementF2mPolynomial elementF2mPolynomial15 = elementF2mPolynomial6.sqr();
        elementF2mPolynomial15.unsafeMultiplyThisBy(this.f.a);
        ElementF2mPolynomial elementF2mPolynomial16 = elementF2mPolynomial13.sqr();
        elementF2mPolynomial4 = elementF2mPolynomial16.unsafeMultiply(elementF2mPolynomial12);
        elementF2mPolynomial16.unsafeMultiplyThisBy(elementF2mPolynomial13);
        elementF2mPolynomial11.unsafeMultiplyThisBy(elementF2mPolynomial16);
        elementF2mPolynomial5 = elementF2mPolynomial6.unsafeMultiply(elementF2mPolynomial10);
        elementF2mPolynomial5.unsafeAddToThis(elementF2mPolynomial14);
        elementF2mPolynomial5.unsafeAddToThis(elementF2mPolynomial16);
        elementF2mPolynomial5.unsafeAddToThis(elementF2mPolynomial15);
        elementF2mPolynomial4.unsafeAddToThis(elementF2mPolynomial5);
        elementF2mPolynomial4.unsafeMultiplyThisBy(elementF2mPolynomial10);
        elementF2mPolynomial4.unsafeAddToThis(elementF2mPolynomial6.unsafeMultiply(elementF2mPolynomial5));
        elementF2mPolynomial4.unsafeAddToThis(elementF2mPolynomial11);
        a.stop();
        return new ElementF2mPolynomial[]{elementF2mPolynomial5, elementF2mPolynomial4, elementF2mPolynomial6};
    }

    @Override
    protected void _addToThis(ECGNUPoint aElem) {
        ECPointF2mPolynomial eCPointF2mPolynomial = (ECPointF2mPolynomial)aElem;
        ElementF2mPolynomial[] elementF2mPolynomialArray = this.a(eCPointF2mPolynomial.c, eCPointF2mPolynomial.d, eCPointF2mPolynomial.e);
        this.c = elementF2mPolynomialArray[0];
        this.d = elementF2mPolynomialArray[1];
        this.e = elementF2mPolynomialArray[2];
    }

    @Override
    public ECGNUPoint negate() {
        ECPointF2mPolynomial eCPointF2mPolynomial = (ECPointF2mPolynomial)this.clone();
        eCPointF2mPolynomial.negateThis();
        return eCPointF2mPolynomial;
    }

    @Override
    public void negateThis() {
        this.d = this.c.unsafeMultiply(this.e).unsafeAdd(this.d);
    }

    @Override
    public boolean equals(Object aObject) {
        boolean bl;
        block19: {
            block18: {
                ECPointF2mPolynomial eCPointF2mPolynomial;
                block17: {
                    block16: {
                        if (aObject != null && aObject instanceof ECPointF2mPolynomial) break block16;
                        return false;
                    }
                    eCPointF2mPolynomial = (ECPointF2mPolynomial)aObject;
                    if (!this.c.equals(eCPointF2mPolynomial.c) || !this.d.equals(eCPointF2mPolynomial.d)) break block17;
                    if (!this.e.equals(eCPointF2mPolynomial.e)) break block17;
                    if (!this.f.equals(eCPointF2mPolynomial.f)) break block17;
                    return true;
                }
                ElementF2mPolynomial elementF2mPolynomial = this.e.unsafeMultiply(this.e);
                ElementF2mPolynomial elementF2mPolynomial2 = this.e.unsafeMultiply(elementF2mPolynomial);
                ElementF2mPolynomial elementF2mPolynomial3 = eCPointF2mPolynomial.e.unsafeMultiply(eCPointF2mPolynomial.e);
                ElementF2mPolynomial elementF2mPolynomial4 = eCPointF2mPolynomial.e.unsafeMultiply(elementF2mPolynomial3);
                if (!this.c.unsafeMultiply(elementF2mPolynomial3).equals(eCPointF2mPolynomial.c.unsafeMultiply(elementF2mPolynomial)) || !this.d.unsafeMultiply(elementF2mPolynomial4).equals(eCPointF2mPolynomial.d.unsafeMultiply(elementF2mPolynomial2))) break block18;
                bl = true;
                break block19;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public Object clone() {
        return new ECPointF2mPolynomial(this.f, this.c.getMElem(), this.d.getMElem(), this.e.getMElem());
    }

    @Override
    public BigInteger getAffineX() {
        if (this.e.equals(this.f.c)) {
            return this.c.getMElem();
        }
        return this.c.unsafeMultiply(this.e.sqr().inverse()).getMElem();
    }

    @Override
    public BigInteger getAffineY() {
        if (this.e.equals(this.f.c)) {
            return this.d.getMElem();
        }
        return this.d.unsafeMultiply(this.e.sqr().unsafeMultiply(this.e).inverse()).getMElem();
    }

    public String toString() {
        String string = "(" + this.c.getMElem() + "," + this.d.getMElem() + "," + this.e.getMElem() + g[6];
        string = string + g[7] + this.getAffineX() + "," + this.getAffineY();
        return string;
    }

    @Override
    protected boolean _ypTilda() {
        ElementF2mPolynomial elementF2mPolynomial = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, this.getAffineX());
        ElementF2mPolynomial elementF2mPolynomial2 = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, this.getAffineY());
        return elementF2mPolynomial2.unsafeMultiply(elementF2mPolynomial.inverse()).getMElem().testBit(0);
    }

    @Override
    protected BigInteger _convert(BigInteger aXP, int aYTilda) throws EllipticCurveException {
        int n;
        if (aXP.equals(BigInteger.ZERO)) {
            return this.f.b.pow(new BigInteger("2").pow(((FieldF2mPolynomial)this.f.mField).getMM() - 1)).getMElem();
        }
        ElementF2mPolynomial elementF2mPolynomial = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, aXP);
        ElementF2mPolynomial elementF2mPolynomial2 = elementF2mPolynomial.inverse2();
        ElementF2mPolynomial elementF2mPolynomial3 = elementF2mPolynomial.unsafeAdd(this.f.a).unsafeAdd(this.f.b.unsafeMultiply(elementF2mPolynomial2.unsafeMultiply(elementF2mPolynomial2)));
        ElementF2mPolynomial elementF2mPolynomial4 = this.a(elementF2mPolynomial3);
        int n2 = n = elementF2mPolynomial4.getMElem().testBit(0) ? 1 : 0;
        if (aYTilda != n) {
            elementF2mPolynomial4 = elementF2mPolynomial4.unsafeAdd(new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, BigInteger.ONE));
        }
        return elementF2mPolynomial.unsafeMultiply(elementF2mPolynomial4).getMElem();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ElementF2mPolynomial a(ElementF2mPolynomial elementF2mPolynomial) throws EllipticCurveException {
        ElementF2mPolynomial elementF2mPolynomial2;
        ElementF2mPolynomial elementF2mPolynomial3;
        int n = ECGNUPoint.b;
        if ((((FieldF2mPolynomial)this.f.mField).getMM() & 1) != 0) {
            ElementF2mPolynomial elementF2mPolynomial4 = this.b(elementF2mPolynomial);
            ElementF2mPolynomial elementF2mPolynomial5 = elementF2mPolynomial4.unsafeMultiply(elementF2mPolynomial4).unsafeAdd(elementF2mPolynomial4);
            if (elementF2mPolynomial5.equals(elementF2mPolynomial)) {
                return elementF2mPolynomial4;
            }
            throw new EllipticCurveException(g[0]);
        }
        do {
            ElementF2mPolynomial elementF2mPolynomial6;
            int n2 = ((FieldF2mPolynomial)this.f.mField).getMM();
            ElementF2mPolynomial elementF2mPolynomial7 = elementF2mPolynomial6 = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, ECPointF2mPolynomial.rastgeleSayi(n2));
            elementF2mPolynomial2 = new ElementF2mPolynomial((FieldF2mPolynomial)this.mField, BigInteger.ZERO);
            for (int k = 1; k < n2; ++k) {
                ElementF2mPolynomial elementF2mPolynomial8 = elementF2mPolynomial7.sqr();
                elementF2mPolynomial2 = elementF2mPolynomial2.sqr().unsafeAdd(elementF2mPolynomial8.unsafeMultiply(elementF2mPolynomial));
                elementF2mPolynomial7 = elementF2mPolynomial8.unsafeAdd(elementF2mPolynomial6);
                if (n == 0) continue;
            }
        } while ((elementF2mPolynomial3 = elementF2mPolynomial2.sqr().unsafeAdd(elementF2mPolynomial2)).getMElem().equals(BigInteger.ZERO));
        return elementF2mPolynomial2;
    }

    public static BigInteger rastgeleSayi(int aBitLen) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(aBitLen);
        int n = aBitLen;
        int n2 = n / 8;
        int n3 = n % 8 == 0 ? 0 : 1;
        int n4 = n2 + n3;
        byte[] byArray = new byte[n4];
        do {
            PRNG.nextBytes(byArray);
        } while ((bigInteger = new BigInteger(1, byArray)).compareTo(bigInteger2) >= 0 || bigInteger.compareTo(BigInteger.ONE) < 0);
        return bigInteger;
    }

    private ElementF2mPolynomial b(ElementF2mPolynomial elementF2mPolynomial) throws EllipticCurveException {
        int n = ECGNUPoint.b;
        int n2 = ((FieldF2mPolynomial)this.f.mField).getMM();
        if ((n2 & 1) == 0) {
            throw new EllipticCurveException(g[1]);
        }
        n2 = n2 + 1 >> 1;
        ElementF2mPolynomial elementF2mPolynomial2 = new ElementF2mPolynomial(elementF2mPolynomial);
        for (int k = 1; k < n2; ++k) {
            elementF2mPolynomial2.unsafeMultiplyThisBy(elementF2mPolynomial2);
            elementF2mPolynomial2.unsafeMultiplyThisBy(elementF2mPolynomial2);
            elementF2mPolynomial2 = elementF2mPolynomial2.unsafeAdd(elementF2mPolynomial);
            if (n == 0) continue;
        }
        return elementF2mPolynomial2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\b9(\u0015\u0002\n#|\u000f\u0002\b%(\u0003\u0015\u000f%|";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 102;
                                break;
                            }
                            case 1: {
                                n8 = 86;
                                break;
                            }
                            case 2: {
                                n8 = 8;
                                break;
                            }
                            case 3: {
                                n8 = 102;
                                break;
                            }
                            default: {
                                n8 = 109;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u000bva\u0015M\b9|F\u0002\u00022$F\u000e\u00078(\b\u0002\u0012vk\u0007\u0001\u0005#d\u0007\u0019\u0003v`\u0007\u0001\u0000{|\u0014\f\u00053";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "(9|F\fFdV\u000bM\u0000?m\n\tF5}\u0014\u001b\u0003w";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "(9|F\fF&g\n\u0014\b9e\u000f\f\nvj\u0007\u001e\u0003%(\u0000\u0004\u0003:lG";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "(9|F\fF&g\n\u0014\b9e\u000f\f\nvj\u0007\u001e\u0003%(\u0000\u0004\u0003:lG";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "(9|F\fF&g\n\u0014\b9e\u000f\f\nvj\u0007\u001e\u0003%(\u0000\u0004\u0003:lG";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "O\\";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "Fv(";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        g = stringArray3;
    }
}

