/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldFp;
import java.math.BigInteger;

public class CurveFp
extends Curve {
    private static final String c;

    public CurveFp(Field aField, BigInteger aA, BigInteger aB) throws EllipticCurveException {
        super(aField, aA, aB);
        if (!(this.mField instanceof FieldFp)) {
            throw new EllipticCurveException(c);
        }
    }

    @Override
    public boolean onCurve(BigInteger aAffineX, BigInteger aAffineY) {
        BigInteger bigInteger = this.mField.getMSize();
        return aAffineY.pow(2).mod(bigInteger).compareTo(aAffineX.pow(3).add(this.mA.multiply(aAffineX)).add(this.mB).mod(bigInteger)) == 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                char[] cArray3 = "FfYYR(y_\u0010^m)K\u0010Vdm\r\u001c_mdH\u0017G".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 8;
                            break;
                        }
                        case 1: {
                            n6 = 9;
                            break;
                        }
                        case 2: {
                            n6 = 45;
                            break;
                        }
                        case 3: {
                            n6 = 121;
                            break;
                        }
                        default: {
                            n6 = 51;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        c = new String(cArray).intern();
    }
}

