/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa;

import gnu.crypto.agreement.BaseAgreement;
import gnu.crypto.derivationFunctions.DerivationFuncParamsWithSharedInfo;
import gnu.crypto.derivationFunctions.DerivationFunction;
import gnu.crypto.key.ecdsa.ECDSAPublicKey;
import gnu.crypto.util.Util;
import java.math.BigInteger;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.params.ParamsWithSharedInfo;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;

public class ECKeyAgreement
implements KeyAgreement {
    private BaseAgreement a;
    private DerivationFunction b;
    private AlgorithmParams c;
    public static boolean d;
    private static final String e;

    public ECKeyAgreement(BaseAgreement aBaseAgreement, DerivationFunction aKDF) {
        this.a = aBaseAgreement;
        this.b = aKDF;
    }

    public void init(Key key, AlgorithmParams params) {
        this.a.init(key);
        this.c = params;
    }

    public SecretKey generateKey(Key key, Algorithm alg) {
        BigInteger bigInteger = this.a.calculateAgreement(key);
        DerivationFuncParamsWithSharedInfo derivationFuncParamsWithSharedInfo = new DerivationFuncParamsWithSharedInfo(((ParamsWithSharedInfo)this.c).getSharedInfo());
        ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)key;
        int n = (eCDSAPublicKey.getMParameters().getMG().getAffineX().bitLength() + 7) / 8;
        byte[] byArray = Util.toBytes(bigInteger, n);
        this.b.init(byArray, derivationFuncParamsWithSharedInfo);
        int n2 = KeyUtil.getKeyLength((Algorithm)alg) / 8;
        byte[] byArray2 = this.b.generateBytes(n2);
        return new SecretKeySpec(byArray2, e);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                char[] cArray3 = "HqX".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 3;
                            break;
                        }
                        case 1: {
                            n6 = 53;
                            break;
                        }
                        case 2: {
                            n6 = 30;
                            break;
                        }
                        case 3: {
                            n6 = 49;
                            break;
                        }
                        default: {
                            n6 = 123;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        e = new String(cArray).intern();
    }
}

