/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.dss;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.Sha160;
import gnu.crypto.sig.BaseSignature;
import gnu.crypto.util.TLV;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.HashMap;
import java.util.Random;
import tr.gov.tubitak.uekae.esya.api.common.crypto.IRandom;

public class DSSSignature
extends BaseSignature {
    public static boolean d;
    private static final String[] e;

    public DSSSignature() {
        super(e[0], new Sha160());
    }

    private DSSSignature(DSSSignature dSSSignature) {
        this();
        this.publicKey = dSSSignature.publicKey;
        this.privateKey = dSSSignature.privateKey;
        this.md = (IMessageDigest)dSSSignature.md.clone();
    }

    public static final BigInteger[] sign(DSAPrivateKey k, byte[] h2) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, DSAPrivateKey> hashMap = new HashMap<String, DSAPrivateKey>();
        hashMap.put(e[4], k);
        dSSSignature.setupSign(hashMap);
        return dSSSignature.a(h2);
    }

    public static final BigInteger[] sign(DSAPrivateKey k, byte[] h2, Random rnd) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put(e[2], k);
        if (rnd != null) {
            hashMap.put(e[1], rnd);
        }
        dSSSignature.setupSign(hashMap);
        return dSSSignature.a(h2);
    }

    public static final BigInteger[] sign(DSAPrivateKey k, byte[] h2, IRandom irnd) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, DSAPrivateKey> hashMap = new HashMap<String, DSAPrivateKey>();
        hashMap.put(e[5], k);
        if (irnd != null) {
            hashMap.put(e[6], (DSAPrivateKey)irnd);
        }
        dSSSignature.setupSign(hashMap);
        return dSSSignature.a(h2);
    }

    public static final boolean verify(DSAPublicKey k, byte[] h2, BigInteger[] rs) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, DSAPublicKey> hashMap = new HashMap<String, DSAPublicKey>();
        hashMap.put(e[3], k);
        dSSSignature.setupVerify(hashMap);
        return dSSSignature.a(rs, h2);
    }

    @Override
    public Object clone() {
        return new DSSSignature(this);
    }

    @Override
    protected void setupForVerification(PublicKey k) throws IllegalArgumentException {
        if (!(k instanceof DSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = k;
    }

    @Override
    protected void setupForSigning(PrivateKey k) throws IllegalArgumentException {
        if (!(k instanceof DSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = k;
    }

    @Override
    protected Object generateSignature() throws IllegalStateException {
        BigInteger[] bigIntegerArray = this.a(this.md.digest());
        return this.a(bigIntegerArray[0], bigIntegerArray[1]);
    }

    @Override
    protected boolean verifySignature(Object sig) throws IllegalStateException {
        BigInteger[] bigIntegerArray = this.a(sig);
        return this.a(bigIntegerArray, this.md.digest());
    }

    private Object a(BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray = TLV.makeTLV((byte)2, bigInteger.toByteArray());
        byte[] byArray2 = TLV.makeTLV((byte)2, bigInteger2.toByteArray());
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return TLV.makeTLV((byte)48, byArray3);
    }

    private BigInteger[] a(Object object) {
        byte[] byArray = (byte[])object;
        if (byArray[0] != 48) {
            return null;
        }
        int[] nArray = TLV.getIcerik(byArray, 0);
        if (nArray[1] + 1 != byArray.length) {
            return null;
        }
        if (byArray[nArray[0]] != 2) {
            return null;
        }
        int[] nArray2 = TLV.getIcerik(byArray, nArray[0]);
        if (byArray[nArray2[1] + 1] != 2) {
            return null;
        }
        int[] nArray3 = TLV.getIcerik(byArray, nArray2[1] + 1);
        byte[] byArray2 = new byte[nArray2[1] - nArray2[0] + 1];
        byte[] byArray3 = new byte[nArray3[1] - nArray3[0] + 1];
        System.arraycopy(byArray, nArray2[0], byArray2, 0, byArray2.length);
        System.arraycopy(byArray, nArray3[0], byArray3, 0, byArray3.length);
        BigInteger bigInteger = new BigInteger(byArray2);
        BigInteger bigInteger2 = new BigInteger(byArray3);
        return new BigInteger[]{bigInteger, bigInteger2};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigInteger[] a(byte[] byArray) {
        BigInteger bigInteger8;
        BigInteger bigInteger6;
        BigInteger bigInteger7;
        boolean bl = d;
        BigInteger bigInteger = ((DSAPrivateKey)this.privateKey).getParams().getP();
        BigInteger bigInteger2 = ((DSAPrivateKey)this.privateKey).getParams().getQ();
        BigInteger bigInteger3 = ((DSAPrivateKey)this.privateKey).getParams().getG();
        BigInteger bigInteger4 = ((DSAPrivateKey)this.privateKey).getX();
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        byte[] byArray2 = new byte[20];
        do {
            this.nextRandomBytes(byArray2);
            bigInteger6 = new BigInteger(1, byArray2);
            bigInteger6.clearBit(159);
        } while ((bigInteger7 = bigInteger3.modPow(bigInteger6, bigInteger).mod(bigInteger2)).equals(BigInteger.ZERO) && !bl || (bigInteger8 = bigInteger5.add(bigInteger4.multiply(bigInteger7)).multiply(bigInteger6.modInverse(bigInteger2)).mod(bigInteger2)).equals(BigInteger.ZERO) && !bl);
        return new BigInteger[]{bigInteger7, bigInteger8};
    }

    private boolean a(BigInteger[] bigIntegerArray, byte[] byArray) {
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = ((DSAPublicKey)this.publicKey).getParams().getG();
        BigInteger bigInteger4 = ((DSAPublicKey)this.publicKey).getParams().getP();
        BigInteger bigInteger5 = ((DSAPublicKey)this.publicKey).getParams().getQ();
        BigInteger bigInteger6 = ((DSAPublicKey)this.publicKey).getY();
        BigInteger bigInteger7 = bigInteger2.modInverse(bigInteger5);
        BigInteger bigInteger8 = bigInteger7.multiply(new BigInteger(1, byArray)).mod(bigInteger5);
        BigInteger bigInteger9 = bigInteger.multiply(bigInteger7).mod(bigInteger5);
        BigInteger bigInteger10 = bigInteger3.modPow(bigInteger8, bigInteger4).multiply(bigInteger6.modPow(bigInteger9, bigInteger4)).mod(bigInteger4).mod(bigInteger5);
        return bigInteger10.equals(bigInteger);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "g$[";
        int n2 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block18;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 3;
                                break;
                            }
                            case 1: {
                                n8 = 87;
                                break;
                            }
                            case 2: {
                                n8 = 40;
                                break;
                            }
                            case 3: {
                                n8 = 87;
                                break;
                            }
                            default: {
                                n8 = 3;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "d9]y`q.X#l-$A0-s%F0";
                    n2 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "d9]y`q.X#l-$A0-s%A!bw2\u0006<fz";
                    n2 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "d9]y`q.X#l-$A0-s\"J;j`yC2z";
                    n2 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "d9]y`q.X#l-$A0-s%A!bw2\u0006<fz";
                    n2 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "d9]y`q.X#l-$A0-s%A!bw2\u0006<fz";
                    n2 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "d9]y`q.X#l-$A0-s%F0";
                    n2 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

