/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.key.rsa;

import gnu.crypto.key.IKeyPairCodec;
import gnu.crypto.key.rsa.GnuRSAKey;
import gnu.crypto.key.rsa.GnuRSAPrivateKey;
import gnu.crypto.key.rsa.GnuRSAPublicKey;
import gnu.crypto.util.TLV;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;

public class RSAKeyPairX509Codec
implements IKeyPairCodec {
    public static final byte[] RSA_OIDarray;
    public static final byte[] RSA_OIDarray2;
    private static final String[] a;

    @Override
    public int getFormatID() {
        return 2;
    }

    @Override
    public byte[] encodePublicKey(PublicKey key) {
        if (!(key instanceof RSAPublicKey)) {
            throw new IllegalArgumentException(a[8]);
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
        byte[] byArray = rSAPublicKey.getModulus().toByteArray();
        byte[] byArray2 = rSAPublicKey.getPublicExponent().toByteArray();
        byte[] byArray3 = TLV.makeTLV((byte)2, byArray);
        byte[] byArray4 = TLV.makeTLV((byte)2, byArray2);
        byte[] byArray5 = new byte[byArray3.length + byArray4.length];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
        byte[] byArray6 = TLV.makeTLV((byte)48, byArray5);
        byte[] byArray7 = new byte[byArray6.length + 1];
        byArray7[0] = 0;
        System.arraycopy(byArray6, 0, byArray7, 1, byArray6.length);
        byte[] byArray8 = TLV.makeTLV((byte)3, byArray7);
        byte[] byArray9 = new byte[RSA_OIDarray.length + byArray8.length];
        System.arraycopy(RSA_OIDarray, 0, byArray9, 0, RSA_OIDarray.length);
        System.arraycopy(byArray8, 0, byArray9, RSA_OIDarray.length, byArray8.length);
        return TLV.makeTLV((byte)48, byArray9);
    }

    @Override
    public byte[] encodePrivateKey(PrivateKey key) {
        if (!(key instanceof RSAPrivateCrtKey)) {
            throw new IllegalArgumentException(a[9]);
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
        byte[] byArray = rSAPrivateCrtKey.getModulus().toByteArray();
        byte[] byArray2 = rSAPrivateCrtKey.getPublicExponent().toByteArray();
        byte[] byArray3 = rSAPrivateCrtKey.getPrivateExponent().toByteArray();
        byte[] byArray4 = rSAPrivateCrtKey.getPrimeP().toByteArray();
        byte[] byArray5 = rSAPrivateCrtKey.getPrimeQ().toByteArray();
        byte[] byArray6 = rSAPrivateCrtKey.getPrimeExponentP().toByteArray();
        byte[] byArray7 = rSAPrivateCrtKey.getPrimeExponentQ().toByteArray();
        byte[] byArray8 = rSAPrivateCrtKey.getCrtCoefficient().toByteArray();
        byte[] byArray9 = TLV.makeTLV((byte)2, new byte[]{0});
        byte[] byArray10 = TLV.makeTLV((byte)2, byArray);
        byte[] byArray11 = TLV.makeTLV((byte)2, byArray2);
        byte[] byArray12 = TLV.makeTLV((byte)2, byArray3);
        byte[] byArray13 = TLV.makeTLV((byte)2, byArray4);
        byte[] byArray14 = TLV.makeTLV((byte)2, byArray5);
        byte[] byArray15 = TLV.makeTLV((byte)2, byArray6);
        byte[] byArray16 = TLV.makeTLV((byte)2, byArray7);
        byte[] byArray17 = TLV.makeTLV((byte)2, byArray8);
        byte[] byArray18 = TLV.yanyanaKoy(byArray9, byArray10);
        byte[] byArray19 = TLV.yanyanaKoy(byArray11, byArray12);
        byte[] byArray20 = TLV.yanyanaKoy(byArray13, byArray14);
        byte[] byArray21 = TLV.yanyanaKoy(byArray15, byArray16);
        byte[] byArray22 = TLV.yanyanaKoy(byArray18, byArray19);
        byte[] byArray23 = TLV.yanyanaKoy(byArray20, byArray21);
        byte[] byArray24 = TLV.yanyanaKoy(byArray23, byArray17);
        byte[] byArray25 = TLV.yanyanaKoy(byArray22, byArray24);
        byte[] byArray26 = TLV.makeTLV((byte)48, byArray25);
        byte[] byArray27 = TLV.makeTLV((byte)4, byArray26);
        byte[] byArray28 = new byte[3 + RSA_OIDarray.length + byArray27.length];
        byArray28[0] = 2;
        byArray28[1] = 1;
        byArray28[2] = 0;
        System.arraycopy(RSA_OIDarray, 0, byArray28, 3, RSA_OIDarray.length);
        System.arraycopy(byArray27, 0, byArray28, RSA_OIDarray.length + 3, byArray27.length);
        return TLV.makeTLV((byte)48, byArray28);
    }

    private int a(byte[] byArray, int n) {
        int n2 = GnuRSAKey.c;
        int n3 = 0;
        byte[] byArray2 = null;
        if (byArray[n + 1] == RSA_OIDarray[1]) {
            byArray2 = RSA_OIDarray;
        } else if (byArray[n + 1] == RSA_OIDarray2[1]) {
            byArray2 = RSA_OIDarray2;
        } else {
            throw new IllegalArgumentException(a[0]);
        }
        int n4 = n;
        while (n3 < byArray2.length) {
            if (byArray[n4] != byArray2[n3++]) {
                throw new IllegalArgumentException(a[1]);
            }
            ++n4;
            if (n2 == 0) continue;
        }
        return n4;
    }

    @Override
    public PublicKey decodePublicKey(byte[] input) {
        if (input[0] != 48) {
            throw new IllegalArgumentException(a[12]);
        }
        int[] nArray = TLV.getIcerik(input, 0);
        if (nArray[1] != input.length - 1) {
            throw new IllegalArgumentException(a[14]);
        }
        int n = this.a(input, nArray[0]);
        if (input[n] != 3) {
            throw new IllegalArgumentException(a[13]);
        }
        nArray = TLV.getIcerik(input, n);
        if (nArray[1] != input.length - 1) {
            throw new IllegalArgumentException(a[16]);
        }
        n = nArray[0] + 1;
        if (input[n] != 48) {
            throw new IllegalArgumentException(a[15]);
        }
        nArray = TLV.getIcerik(input, n);
        if (nArray[1] != input.length - 1) {
            throw new IllegalArgumentException(a[10]);
        }
        n = nArray[0];
        if (input[n] != 2) {
            throw new IllegalArgumentException(a[11]);
        }
        nArray = TLV.getIcerik(input, n);
        byte[] byArray = new byte[nArray[1] - nArray[0] + 1];
        System.arraycopy(input, nArray[0], byArray, 0, byArray.length);
        BigInteger bigInteger = new BigInteger(byArray);
        n = nArray[1] + 1;
        nArray = TLV.getIcerik(input, n);
        byte[] byArray2 = new byte[nArray[1] - nArray[0] + 1];
        System.arraycopy(input, nArray[0], byArray2, 0, byArray2.length);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        return new GnuRSAPublicKey(bigInteger, bigInteger2);
    }

    @Override
    public PrivateKey decodePrivateKey(byte[] input) {
        int[] nArray;
        block27: {
            block26: {
                block25: {
                    block24: {
                        if (input[0] != 48) {
                            throw new IllegalArgumentException(a[5]);
                        }
                        nArray = TLV.getIcerik(input, 0);
                        if (nArray[1] != input.length - 1) {
                            throw new IllegalArgumentException(a[2]);
                        }
                        if (input[nArray[0]] != 2 || input[nArray[0] + 1] != 1) break block24;
                        if (input[nArray[0] + 2] == 0) break block25;
                    }
                    throw new IllegalArgumentException(a[6]);
                }
                int n = this.a(input, nArray[0] + 3);
                if (input[n] != 4) {
                    throw new IllegalArgumentException(a[7]);
                }
                nArray = TLV.getIcerik(input, n);
                n = nArray[0];
                if (input[n] != 48) {
                    throw new IllegalArgumentException(a[3]);
                }
                nArray = TLV.getIcerik(input, n);
                n = nArray[0];
                if (input[n] != 2 || input[n + 1] != 1) break block26;
                if (input[n + 2] == 0) break block27;
            }
            throw new IllegalArgumentException(a[4]);
        }
        BigInteger bigInteger = TLV.decodeINT(input, n += 3, nArray);
        BigInteger bigInteger2 = TLV.decodeINT(input, nArray[1] + 1, nArray);
        BigInteger bigInteger3 = TLV.decodeINT(input, nArray[1] + 1, nArray);
        BigInteger bigInteger4 = TLV.decodeINT(input, nArray[1] + 1, nArray);
        BigInteger bigInteger5 = TLV.decodeINT(input, nArray[1] + 1, nArray);
        BigInteger bigInteger6 = TLV.decodeINT(input, nArray[1] + 1, nArray);
        BigInteger bigInteger7 = TLV.decodeINT(input, nArray[1] + 1, nArray);
        BigInteger bigInteger8 = TLV.decodeINT(input, nArray[1] + 1, nArray);
        return new GnuRSAPrivateKey(bigInteger4, bigInteger5, bigInteger2, bigInteger3);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[17];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\f\u0003\u0018pt7A;Q7-\u000e\u00065q,\u0014\u001cq";
        int n2 = -1;
        block24: while (true) {
            char[] cArray;
            block29: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block28: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block28;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 67;
                                break;
                            }
                            case 1: {
                                n8 = 97;
                                break;
                            }
                            case 2: {
                                n8 = 114;
                                break;
                            }
                            case 3: {
                                n8 = 21;
                                break;
                            }
                            default: {
                                n8 = 23;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\f\u0003\u0018pt7A;Q7-\u000e\u00065q,\u0014\u001cq";
                    n2 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u0015\u0004\u0000f~,\u000fRpe1\u000e\u0000";
                    n2 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0015\u0004\u0000f~,\u000fRpe1\u000e\u0000";
                    n2 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "(\u0004\u000b";
                    n2 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "(\u0004\u000b";
                    n2 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 10;
                    continue block24;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "\r\u000e\u00065D&\u0010\u0007py \u0004";
                    n2 = 11;
                    continue block24;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 12;
                    continue block24;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 13;
                    continue block24;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 14;
                    continue block24;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "\u0007$ 5s&\u0002\u001dqrc\u0004\u0000gx1";
                    n2 = 15;
                    continue block24;
                }
                case 15: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
        RSA_OIDarray = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};
        RSA_OIDarray2 = new byte[]{48, 11, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1};
    }
}

