/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.key.ecdsa;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1BitString;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1OpenType;
import com.objsys.asn1j.runtime.Asn1Type;
import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.key.IKeyPairCodec;
import gnu.crypto.key.ecdsa.ECDSAKey;
import gnu.crypto.key.ecdsa.ECDSAPrivateKey;
import gnu.crypto.key.ecdsa.ECDSAPublicKey;
import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.curve.CurveF2m;
import gnu.crypto.sig.ecdsa.ecmath.curve.CurveFp;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECDomainParameter;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECGNUPoint;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECPointF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.curve.ECPointFp;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldF2mPolynomial;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldFp;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import tr.gov.tubitak.uekae.esya.asn.algorithms.Characteristic_two;
import tr.gov.tubitak.uekae.esya.asn.algorithms.ECPVer;
import tr.gov.tubitak.uekae.esya.asn.algorithms.ECParameters;
import tr.gov.tubitak.uekae.esya.asn.algorithms.EcpkParameters;
import tr.gov.tubitak.uekae.esya.asn.algorithms.FieldID;
import tr.gov.tubitak.uekae.esya.asn.algorithms.Pentanomial;
import tr.gov.tubitak.uekae.esya.asn.algorithms._algorithmsValues;
import tr.gov.tubitak.uekae.esya.asn.pkcs1pkcs8.ECPrivateKey;
import tr.gov.tubitak.uekae.esya.asn.pkcs1pkcs8.PrivateKeyInfo;
import tr.gov.tubitak.uekae.esya.asn.util.UtilEsitlikler;
import tr.gov.tubitak.uekae.esya.asn.util.UtilOpenType;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.SubjectPublicKeyInfo;

public class ECDSAKeyPairX509Codec
implements IKeyPairCodec {
    private static final String[] a;

    @Override
    public int getFormatID() {
        return 2;
    }

    public AlgorithmIdentifier toAlgID(ECDomainParameter aDomainParameter) throws Asn1Exception, IOException {
        if (aDomainParameter.getmParamOID() != null) {
            return new AlgorithmIdentifier(_algorithmsValues.id_ecPublicKey, UtilOpenType.toOpenType((Asn1Type)new Asn1ObjectIdentifier(aDomainParameter.getmParamOID())));
        }
        return this.a(aDomainParameter);
    }

    public AlgorithmIdentifier toUnCompressedAlgID(ECDomainParameter aDomainParameter) throws Asn1Exception, IOException {
        return this.a(aDomainParameter);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AlgorithmIdentifier a(ECDomainParameter eCDomainParameter) throws Asn1Exception, IOException {
        Asn1Integer asn1Integer;
        FieldF2mPolynomial fieldF2mPolynomial;
        CurveF2m curveF2m;
        Asn1BigInteger asn1BigInteger;
        int[] nArray;
        block11: {
            void var6_9;
            boolean bl;
            block13: {
                block12: {
                    block10: {
                        bl = ECDSAKey.b;
                        if (!(eCDomainParameter.getMCurve() instanceof CurveFp)) break block10;
                        nArray = _algorithmsValues.prime_field;
                        asn1BigInteger = new Asn1BigInteger(eCDomainParameter.getMCurve().getMField().getMSize());
                        if (!bl) break block11;
                    }
                    nArray = _algorithmsValues.characteristic_two_field;
                    curveF2m = (CurveF2m)eCDomainParameter.getMCurve();
                    if (!(curveF2m.getMField() instanceof FieldF2mPolynomial)) throw new IllegalArgumentException(a[26]);
                    fieldF2mPolynomial = (FieldF2mPolynomial)curveF2m.getMField();
                    if (fieldF2mPolynomial.getMReductionPOnes().length != 3) break block12;
                    int[] nArray2 = _algorithmsValues.tpBasis;
                    asn1Integer = new Asn1Integer((long)fieldF2mPolynomial.getMReductionPOnes()[1]);
                    if (!bl) break block13;
                }
                if (fieldF2mPolynomial.getMReductionPOnes().length != 5) throw new IllegalArgumentException(a[27]);
                int[] nArray3 = _algorithmsValues.ppBasis;
                asn1Integer = new Pentanomial((long)fieldF2mPolynomial.getMReductionPOnes()[1], (long)fieldF2mPolynomial.getMReductionPOnes()[2], (long)fieldF2mPolynomial.getMReductionPOnes()[3]);
                if (bl) {
                    throw new IllegalArgumentException(a[27]);
                }
            }
            asn1BigInteger = new Characteristic_two((long)fieldF2mPolynomial.getMM(), (int[])var6_9, UtilOpenType.toOpenType((Asn1Type)asn1Integer));
            if (bl) {
                throw new IllegalArgumentException(a[26]);
            }
        }
        curveF2m = new FieldID(nArray, UtilOpenType.toOpenType((Asn1Type)asn1BigInteger));
        fieldF2mPolynomial = new tr.gov.tubitak.uekae.esya.asn.algorithms.Curve(new Asn1OctetString(eCDomainParameter.getMCurve().getMA().toByteArray()), new Asn1OctetString(eCDomainParameter.getMCurve().getMB().toByteArray()));
        ECParameters eCParameters = new ECParameters();
        eCParameters.version = new ECPVer(1L);
        eCParameters.fieldID = curveF2m;
        eCParameters.curve = fieldF2mPolynomial;
        eCParameters.cofactor = new Asn1BigInteger(eCDomainParameter.getMH());
        eCParameters.base = new Asn1OctetString(eCDomainParameter.getMG().toOctetString(1));
        eCParameters.order = new Asn1BigInteger(eCDomainParameter.getMN());
        if (eCDomainParameter.getMH() != null) {
            eCParameters.cofactor = new Asn1BigInteger(eCDomainParameter.getMH());
        }
        asn1Integer = new EcpkParameters();
        asn1Integer.set_ecParameters(eCParameters);
        return new AlgorithmIdentifier(_algorithmsValues.id_ecPublicKey, UtilOpenType.toOpenType((Asn1Type)asn1Integer));
    }

    @Override
    public byte[] encodePublicKey(PublicKey aKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = this.getSubjectPublicKeyInfo(aKey);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            subjectPublicKeyInfo.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            return asn1DerEncodeBuffer.getMsgCopy();
        }
        catch (IOException iOException) {
            throw new RuntimeException(a[7], iOException);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException(a[8], asn1Exception);
        }
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo(PublicKey aKey) throws Asn1Exception, IOException {
        if (!(aKey instanceof ECDSAPublicKey)) {
            throw new IllegalArgumentException(a[13]);
        }
        ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)aKey;
        AlgorithmIdentifier algorithmIdentifier = this.toAlgID(eCDSAPublicKey.getMParameters());
        byte[] byArray = eCDSAPublicKey.getMQ().toOctetString(1);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, new Asn1BitString(byArray.length << 3, byArray));
        return subjectPublicKeyInfo;
    }

    @Override
    public byte[] encodePrivateKey(PrivateKey aKey) {
        try {
            if (!(aKey instanceof ECDSAPrivateKey)) {
                throw new IllegalArgumentException(a[0]);
            }
            ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)aKey;
            byte[] byArray = eCDSAPrivateKey.getMD().toByteArray();
            if (byArray[0] == 0) {
                byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
            }
            ECPrivateKey eCPrivateKey = new ECPrivateKey(1L, byArray);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            eCPrivateKey.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(0L, this.toAlgID(eCDSAPrivateKey.getMParameters()), asn1DerEncodeBuffer.getMsgCopy());
            Asn1DerEncodeBuffer asn1DerEncodeBuffer2 = new Asn1DerEncodeBuffer();
            privateKeyInfo.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer2);
            return asn1DerEncodeBuffer2.getMsgCopy();
        }
        catch (IOException iOException) {
            throw new RuntimeException(a[1], iOException);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException(a[2], asn1Exception);
        }
    }

    public byte[] encodePrivateKey(PrivateKey aPriKey, PublicKey aPubKey) {
        try {
            if (!(aPriKey instanceof ECDSAPrivateKey)) {
                throw new IllegalArgumentException(a[10]);
            }
            if (!(aPubKey instanceof ECDSAPublicKey)) {
                throw new IllegalArgumentException(a[11]);
            }
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)aPubKey;
            byte[] byArray = eCDSAPublicKey.getMQ().toOctetString(1);
            ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)aPriKey;
            ECPrivateKey eCPrivateKey = new ECPrivateKey(1L, eCDSAPrivateKey.getMD().toByteArray(), null, new Asn1BitString(byArray.length << 3, byArray));
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            eCPrivateKey.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(0L, this.toAlgID(eCDSAPrivateKey.getMParameters()), asn1DerEncodeBuffer.getMsgCopy());
            Asn1DerEncodeBuffer asn1DerEncodeBuffer2 = new Asn1DerEncodeBuffer();
            privateKeyInfo.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer2);
            return asn1DerEncodeBuffer2.getMsgCopy();
        }
        catch (IOException iOException) {
            throw new RuntimeException(a[9], iOException);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException(a[12], asn1Exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ECDomainParameter toDomainParameters(AlgorithmIdentifier aAlgID) throws Asn1Exception, IOException, EllipticCurveException {
        void var6_12;
        void var5_19;
        void var4_16;
        ECParameters eCParameters;
        block15: {
            Characteristic_two characteristic_two;
            Object object;
            boolean bl;
            block17: {
                block16: {
                    block14: {
                        bl = ECDSAKey.b;
                        if (!UtilEsitlikler.esitMi((int[])aAlgID.algorithm.value, (int[])_algorithmsValues.id_ecPublicKey)) {
                            throw new IllegalArgumentException(a[15]);
                        }
                        EcpkParameters ecpkParameters = new EcpkParameters();
                        UtilOpenType.fromOpenType((Asn1OpenType)aAlgID.parameters, (Asn1Type)ecpkParameters);
                        if (ecpkParameters.getChoiceID() != 3) {
                            if (ecpkParameters.getChoiceID() != 2) throw new IllegalArgumentException(a[14]);
                            ECDomainParameter eCDomainParameter = ECDomainParameter.getInstance(((Asn1ObjectIdentifier)ecpkParameters.getElement()).value);
                            if (eCDomainParameter != null) return eCDomainParameter;
                            throw new IllegalArgumentException(a[17] + (Asn1ObjectIdentifier)ecpkParameters.getElement());
                        }
                        eCParameters = (ECParameters)ecpkParameters.getElement();
                        if (!UtilEsitlikler.esitMi((int[])eCParameters.fieldID.fieldType.value, (int[])_algorithmsValues.prime_field)) break block14;
                        Asn1BigInteger asn1BigInteger = new Asn1BigInteger();
                        UtilOpenType.fromOpenType((Asn1OpenType)eCParameters.fieldID.parameters, (Asn1Type)asn1BigInteger);
                        object = FieldFp.getInstance(asn1BigInteger.value);
                        CurveFp curveFp = new CurveFp((Field)object, new BigInteger(1, eCParameters.curve.a.value), new BigInteger(1, eCParameters.curve.b.value));
                        ECPointFp eCPointFp = new ECPointFp(curveFp, eCParameters.base.value);
                        if (!bl) break block15;
                    }
                    if (!UtilEsitlikler.esitMi((int[])eCParameters.fieldID.fieldType.value, (int[])_algorithmsValues.characteristic_two_field)) throw new IllegalArgumentException(a[16]);
                    characteristic_two = new Characteristic_two();
                    UtilOpenType.fromOpenType((Asn1OpenType)eCParameters.fieldID.parameters, (Asn1Type)characteristic_two);
                    object = new BigInteger("1");
                    object = ((BigInteger)object).setBit((int)characteristic_two.m.value);
                    if (!UtilEsitlikler.esitMi((int[])characteristic_two.basis.value, (int[])_algorithmsValues.tpBasis)) break block16;
                    Asn1Integer asn1Integer = new Asn1Integer();
                    UtilOpenType.fromOpenType((Asn1OpenType)characteristic_two.parameters, (Asn1Type)asn1Integer);
                    object = ((BigInteger)object).setBit((int)asn1Integer.value);
                    if (!bl) break block17;
                }
                if (!UtilEsitlikler.esitMi((int[])characteristic_two.basis.value, (int[])_algorithmsValues.ppBasis)) throw new IllegalArgumentException(a[18]);
                Pentanomial pentanomial = new Pentanomial();
                UtilOpenType.fromOpenType((Asn1OpenType)characteristic_two.parameters, (Asn1Type)pentanomial);
                object = ((BigInteger)object).setBit((int)pentanomial.k1.value);
                object = ((BigInteger)object).setBit((int)pentanomial.k2.value);
                object = ((BigInteger)object).setBit((int)pentanomial.k3.value);
                if (bl) {
                    throw new IllegalArgumentException(a[18]);
                }
            }
            FieldF2mPolynomial fieldF2mPolynomial = FieldF2mPolynomial.getInstance((int)characteristic_two.m.value, (BigInteger)object);
            CurveF2m curveF2m = new CurveF2m(fieldF2mPolynomial, new BigInteger(1, eCParameters.curve.a.value), new BigInteger(1, eCParameters.curve.b.value));
            ECPointF2mPolynomial eCPointF2mPolynomial = new ECPointF2mPolynomial(curveF2m, eCParameters.base.value);
            if (bl) {
                throw new IllegalArgumentException(a[16]);
            }
        }
        Object var6_9 = null;
        if (eCParameters.cofactor != null) {
            ECDomainParameter eCDomainParameter = ECDomainParameter.getInstance((Curve)var4_16, (ECGNUPoint)var5_19, eCParameters.order.value, eCParameters.cofactor.value);
            return var6_12;
        }
        ECDomainParameter eCDomainParameter = ECDomainParameter.getInstance((Curve)var4_16, (ECGNUPoint)var5_19, eCParameters.order.value);
        return var6_12;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey decodePublicKey(byte[] aInput) {
        boolean bl = ECDSAKey.b;
        try {
            void var5_11;
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aInput);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo();
            subjectPublicKeyInfo.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            ECDomainParameter eCDomainParameter = this.toDomainParameters(subjectPublicKeyInfo.algorithm);
            if (eCDomainParameter.getMCurve() instanceof CurveFp) {
                ECPointFp eCPointFp = new ECPointFp(eCDomainParameter.getMCurve(), subjectPublicKeyInfo.subjectPublicKey.value);
                if (!bl) return new ECDSAPublicKey(eCDomainParameter, (ECGNUPoint)var5_11);
            }
            if (!(eCDomainParameter.getMCurve() instanceof CurveF2m)) throw new IllegalArgumentException(a[19]);
            ECPointF2mPolynomial eCPointF2mPolynomial = new ECPointF2mPolynomial(eCDomainParameter.getMCurve(), subjectPublicKeyInfo.subjectPublicKey.value);
            if (!bl) return new ECDSAPublicKey(eCDomainParameter, (ECGNUPoint)var5_11);
            throw new IllegalArgumentException(a[19]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(a[20], iOException);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException(a[21], asn1Exception);
        }
        catch (EllipticCurveException ellipticCurveException) {
            throw new RuntimeException(a[22], ellipticCurveException);
        }
    }

    @Override
    public PrivateKey decodePrivateKey(byte[] aInput) {
        try {
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aInput);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
            privateKeyInfo.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            ECDomainParameter eCDomainParameter = this.toDomainParameters(privateKeyInfo.privateKeyAlgorithm);
            ECPrivateKey eCPrivateKey = new ECPrivateKey();
            asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(privateKeyInfo.privateKey.value);
            eCPrivateKey.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            return new ECDSAPrivateKey(eCDomainParameter, new BigInteger(1, eCPrivateKey.privateKey.value));
        }
        catch (IOException iOException) {
            throw new RuntimeException(a[25], iOException);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException(a[23], asn1Exception);
        }
        catch (EllipticCurveException ellipticCurveException) {
            throw new RuntimeException(a[24], ellipticCurveException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] decodePriAndPubKey(byte[] aPriKey) {
        boolean bl = ECDSAKey.b;
        try {
            void var7_13;
            ECDSAPrivateKey eCDSAPrivateKey;
            ECDomainParameter eCDomainParameter;
            block11: {
                ECPrivateKey eCPrivateKey;
                block10: {
                    Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aPriKey);
                    PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
                    privateKeyInfo.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
                    eCDomainParameter = this.toDomainParameters(privateKeyInfo.privateKeyAlgorithm);
                    eCPrivateKey = new ECPrivateKey();
                    asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(privateKeyInfo.privateKey.value);
                    eCPrivateKey.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
                    eCDSAPrivateKey = new ECDSAPrivateKey(eCDomainParameter, new BigInteger(eCPrivateKey.privateKey.value));
                    if (!(eCDomainParameter.getMCurve() instanceof CurveFp)) break block10;
                    ECPointFp eCPointFp = new ECPointFp(eCDomainParameter.getMCurve(), eCPrivateKey.publicKey.value);
                    if (!bl) break block11;
                    int n = BaseCipher.b;
                    BaseCipher.b = ++n;
                }
                if (!(eCDomainParameter.getMCurve() instanceof CurveF2m)) throw new IllegalArgumentException(a[3]);
                ECPointF2mPolynomial eCPointF2mPolynomial = new ECPointF2mPolynomial(eCDomainParameter.getMCurve(), eCPrivateKey.publicKey.value);
                if (bl) {
                    throw new IllegalArgumentException(a[3]);
                }
            }
            ECDSAPublicKey eCDSAPublicKey = new ECDSAPublicKey(eCDomainParameter, (ECGNUPoint)var7_13);
            Object[] objectArray = new Object[]{eCDSAPrivateKey, eCDSAPublicKey};
            return objectArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(a[5], iOException);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException(a[4], asn1Exception);
        }
        catch (EllipticCurveException ellipticCurveException) {
            throw new RuntimeException(a[6], ellipticCurveException);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "?b~";
        int n2 = -1;
        block35: while (true) {
            char[] cArray;
            block40: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block39: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block39;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block40;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 84;
                                break;
                            }
                            case 1: {
                                n8 = 7;
                                break;
                            }
                            case 2: {
                                n8 = 7;
                                break;
                            }
                            case 3: {
                                n8 = 82;
                                break;
                            }
                            default: {
                                n8 = 123;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u001dH'\u0017\t&hur\u0012:'F\u00015e'w \u00147bt!";
                    n2 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0015TIc[\u0011uu=\ttnir:\u0007I6r\u000b&hd7\b'";
                    n2 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0003of&\\''`=\u0012:`'=\u0015k8";
                    n2 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u0015TIc[\u0011uu=\ttnir:\u0007I6r\u000b&hd7\b'";
                    n2 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u001dH'\u0017\t&hur\u0012:'F\u00015e'w \u00147bt!";
                    n2 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0003uh<\u001ctwf \u001a9bs7\t'";
                    n2 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u001dH'\u0017\t&hur\u0012:'F\u00015e'w \u00147bt!";
                    n2 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0015TIc[\u0011uu=\ttnir:\u0007I6r\u000b&hd7\b'";
                    n2 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u001dH'\u0017\t&hur\u0012:'F\u00015e'w \u00147bt!";
                    n2 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "?b~";
                    n2 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "?b~";
                    n2 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "\u0015TIc[\u0011uu=\ttnir:\u0007I6r\u000b&hd7\b'";
                    n2 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "?b~";
                    n2 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "\u0004fu3\u00161sb [:hsr\u0010:hp<";
                    n2 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "\u001ahsr\u001a:'B\u0011?\u0007F'\u0013\u00173hu;\u000f<j'\u001b?";
                    n2 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "\u0012nb>\u001fts~\"\u001etih&[?ih%\u0015";
                    n2 = 15;
                    continue block35;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "\u0017ru$\u001etHN\u0016[:hsr\u0010:hp<At";
                    n2 = 16;
                    continue block35;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "\u00125jr\u0015;s'&\t=ih?\u00125k'=\ttwb<\u000f5ih?\u00125k'0\u001a'nt";
                    n2 = 17;
                    continue block35;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "\u0003of&\\''`=\u0012:`'=\u0015k8";
                    n2 = 18;
                    continue block35;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "\u001dH'\u0017\t&hur\u0012:'F\u00015e'w \u00147bt!";
                    n2 = 19;
                    continue block35;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "\u0015TIc[\u0011uu=\ttnir:\u0007I6r\u000b&hd7\b'";
                    n2 = 20;
                    continue block35;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "\u0003uh<\u001ctwf \u001a9bs7\t'";
                    n2 = 21;
                    continue block35;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "\u0015TIc[\u0011uu=\ttnir:\u0007I6r\u000b&hd7\b'";
                    n2 = 22;
                    continue block35;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "\u0003uh<\u001ctwf \u001a9bs7\t'";
                    n2 = 23;
                    continue block35;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "\u001dH'\u0017\t&hur\u0012:'F\u00015e'w \u00147bt!";
                    n2 = 24;
                    continue block35;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "?b~~[\u00125jr\u0015;s'\"\u00148~i=\u0016=fk";
                    n2 = 25;
                    continue block35;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "?b~~[\u00125jr\u0015;s'&\t=ih?\u00125k'=\ttwb<\u000f5ih?\u00125k'0\u001a'nt";
                    n2 = 26;
                    continue block35;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

