/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.hash.BaseHash;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.util.Util;

public class Sha224
implements IMessageDigest {
    private static final int a = 64;
    private static final String b;
    private static final int c = 28;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;
    private int[] l = new int[64];
    private int m;
    private static final int n = 64;
    private byte[] o;
    private int p;
    private long q;
    private static Boolean r;
    static final int[] s;
    private static final String[] t;

    public Sha224() {
        this.o = new byte[4];
        this.p = 0;
        this.reset();
    }

    public Sha224(Sha224 t) {
        this.o = new byte[t.o.length];
        System.arraycopy(t.o, 0, this.o, 0, t.o.length);
        this.p = t.p;
        this.q = t.q;
        this.d = t.d;
        this.e = t.e;
        this.f = t.f;
        this.g = t.g;
        this.h = t.h;
        this.i = t.i;
        this.j = t.j;
        this.k = t.k;
        System.arraycopy(t.l, 0, this.l, 0, t.l.length);
        this.m = t.m;
    }

    @Override
    public Object clone() {
        return new Sha224(this);
    }

    @Override
    public String name() {
        return t[0];
    }

    @Override
    public int hashSize() {
        return 28;
    }

    @Override
    public int blockSize() {
        return 64;
    }

    @Override
    public byte[] digest() {
        byte[] byArray = new byte[28];
        this.doFinal(byArray, 0);
        return byArray;
    }

    @Override
    public boolean selfTest() {
        if (r == null) {
            Sha224 sha224 = new Sha224();
            sha224.update((byte)97);
            sha224.update((byte)98);
            sha224.update((byte)99);
            String string = Util.toString(sha224.digest());
            r = t[2].equals(string);
        }
        return r;
    }

    @Override
    public void reset() {
        int n;
        this.q = 0L;
        this.p = 0;
        for (n = 0; n < this.o.length; ++n) {
            this.o[n] = 0;
        }
        this.d = -1056596264;
        this.e = 914150663;
        this.f = 812702999;
        this.g = -150054599;
        this.h = -4191439;
        this.i = 1750603025;
        this.j = 1694076839;
        this.k = -1090891868;
        this.m = 0;
        for (n = 0; n != this.l.length; ++n) {
            this.l[n] = 0;
        }
    }

    protected void processWord(byte[] in, int inOff) {
        int n = in[inOff] << 24;
        n |= (in[++inOff] & 0xFF) << 16;
        n |= (in[++inOff] & 0xFF) << 8;
        this.l[this.m] = n |= in[++inOff] & 0xFF;
        if (++this.m == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long bitLength) {
        if (this.m > 14) {
            this.processBlock();
        }
        this.l[14] = (int)(bitLength >>> 32);
        this.l[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Sha224.intToBigEndian(this.d, out, outOff);
        Sha224.intToBigEndian(this.e, out, outOff + 4);
        Sha224.intToBigEndian(this.f, out, outOff + 8);
        Sha224.intToBigEndian(this.g, out, outOff + 12);
        Sha224.intToBigEndian(this.h, out, outOff + 16);
        Sha224.intToBigEndian(this.i, out, outOff + 20);
        Sha224.intToBigEndian(this.j, out, outOff + 24);
        this.reset();
        return 28;
    }

    protected void processBlock() {
        int n;
        int n2;
        boolean bl = BaseHash.b;
        for (n2 = 16; n2 <= 63; ++n2) {
            this.l[n2] = this.d(this.l[n2 - 2]) + this.l[n2 - 7] + this.c(this.l[n2 - 15]) + this.l[n2 - 16];
            if (!bl) continue;
        }
        n2 = this.d;
        int n3 = this.e;
        int n4 = this.f;
        int n5 = this.g;
        int n6 = this.h;
        int n7 = this.i;
        int n8 = this.j;
        int n9 = this.k;
        int n10 = 0;
        for (n = 0; n < 8; ++n) {
            n5 += (n9 += this.b(n6) + this.a(n6, n7, n8) + s[n10] + this.l[n10]);
            n9 += this.a(n2) + this.b(n2, n3, n4);
            n4 += (n8 += this.b(n5) + this.a(n5, n6, n7) + s[++n10] + this.l[n10]);
            n8 += this.a(n9) + this.b(n9, n2, n3);
            n3 += (n7 += this.b(n4) + this.a(n4, n5, n6) + s[++n10] + this.l[n10]);
            n7 += this.a(n8) + this.b(n8, n9, n2);
            n2 += (n6 += this.b(n3) + this.a(n3, n4, n5) + s[++n10] + this.l[n10]);
            n6 += this.a(n7) + this.b(n7, n8, n9);
            n9 += (n5 += this.b(n2) + this.a(n2, n3, n4) + s[++n10] + this.l[n10]);
            n5 += this.a(n6) + this.b(n6, n7, n8);
            n8 += (n4 += this.b(n9) + this.a(n9, n2, n3) + s[++n10] + this.l[n10]);
            n4 += this.a(n5) + this.b(n5, n6, n7);
            n7 += (n3 += this.b(n8) + this.a(n8, n9, n2) + s[++n10] + this.l[n10]);
            n3 += this.a(n4) + this.b(n4, n5, n6);
            n6 += (n2 += this.b(n7) + this.a(n7, n8, n9) + s[++n10] + this.l[n10]);
            n2 += this.a(n3) + this.b(n3, n4, n5);
            ++n10;
            if (!bl) continue;
        }
        this.d += n2;
        this.e += n3;
        this.f += n4;
        this.g += n5;
        this.h += n6;
        this.i += n7;
        this.j += n8;
        this.k += n9;
        this.m = 0;
        for (n = 0; n < 16; ++n) {
            this.l[n] = 0;
            if (!bl) continue;
        }
    }

    private int a(int n, int n2, int n3) {
        return n & n2 ^ ~n & n3;
    }

    private int b(int n, int n2, int n3) {
        return n & n2 ^ n & n3 ^ n2 & n3;
    }

    private int a(int n) {
        return (n >>> 2 | n << 30) ^ (n >>> 13 | n << 19) ^ (n >>> 22 | n << 10);
    }

    private int b(int n) {
        return (n >>> 6 | n << 26) ^ (n >>> 11 | n << 21) ^ (n >>> 25 | n << 7);
    }

    private int c(int n) {
        return (n >>> 7 | n << 25) ^ (n >>> 18 | n << 14) ^ n >>> 3;
    }

    private int d(int n) {
        return (n >>> 17 | n << 15) ^ (n >>> 19 | n << 13) ^ n >>> 10;
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    @Override
    public void update(byte in) {
        this.o[this.p++] = in;
        if (this.p == this.o.length) {
            this.processWord(this.o, 0);
            this.p = 0;
        }
        ++this.q;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        boolean bl = BaseHash.b;
        while (this.p != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
            if (!bl) continue;
        }
        while (len > this.o.length) {
            this.processWord(in, inOff);
            inOff += this.o.length;
            len -= this.o.length;
            this.q += (long)this.o.length;
            if (!bl) continue;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
            if (!bl) continue;
        }
    }

    public void finish() {
        boolean bl = BaseHash.b;
        long l = this.q << 3;
        this.update((byte)-128);
        while (this.p != 0) {
            this.update((byte)0);
            if (!bl) continue;
        }
        this.processLength(l);
        this.processBlock();
    }

    public static void main(String[] args) {
        Sha224 sha224 = new Sha224();
        System.out.println(sha224.selfTest());
        byte[] byArray = new byte[1003];
        sha224.reset();
        sha224.update(byArray, 0, byArray.length);
        System.out.println(t[1]);
        System.out.println("" + Util.toString(sha224.digest()));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "D\u000b\u0017YM2\n\u0015SNF\rcXHD\u0000\u0011TH7\f\u0010W82y\u0015UO4\u000b\u0015!;2zd%N4|fP8E~\u0010%I@{\u001e$;A";
        int n2 = 2;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 118;
                                break;
                            }
                            case 1: {
                                n8 = 56;
                                break;
                            }
                            case 2: {
                                n8 = 39;
                                break;
                            }
                            case 3: {
                                n8 = 96;
                                break;
                            }
                            default: {
                                n8 = 122;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                case 2: {
                    b = string.intern();
                    string2 = "%pfMHD\f";
                    n2 = -1;
                    continue block11;
                }
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "4\r\u001eW84\u000f\u0011TK@\r\u0012&82\u000ea!?C\u000bbUB7\rbRO0\t\u0013UO7\td!85\nbRNE\rdP97\t\u0013TLC";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "D\u000b\u0017YM2\n\u0015SNF\rcXHD\u0000\u0011TH7\f\u0010W82y\u0015UO4\u000b\u0015!;2zd%N4|fP8E~\u0010%I@{\u001e$;A";
                    n2 = 1;
                    continue block11;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        t = stringArray3;
        s = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    }
}

