/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;

public abstract class BaseHash
implements IMessageDigest {
    protected String name;
    protected int hashSize;
    protected int blockSize;
    protected long count;
    protected byte[] buffer;
    public static boolean b;

    protected BaseHash(String name, int hashSize, int blockSize) {
        this.name = name;
        this.hashSize = hashSize;
        this.blockSize = blockSize;
        this.buffer = new byte[blockSize];
        this.resetContext();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int hashSize() {
        return this.hashSize;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public void update(byte b2) {
        int n = (int)(this.count % (long)this.blockSize);
        ++this.count;
        this.buffer[n] = b2;
        if (n == this.blockSize - 1) {
            this.transform(this.buffer, 0);
        }
    }

    @Override
    public void update(byte[] b2, int offset, int len) {
        boolean bl = b;
        int n = (int)(this.count % (long)this.blockSize);
        this.count += (long)len;
        int n2 = this.blockSize - n;
        int n3 = 0;
        if (len >= n2) {
            System.arraycopy(b2, offset, this.buffer, n, n2);
            this.transform(this.buffer, 0);
            n3 = n2;
            while (n3 + this.blockSize - 1 < len) {
                this.transform(b2, offset + n3);
                n3 += this.blockSize;
                if (!bl) continue;
            }
            n = 0;
        }
        if (n3 < len) {
            System.arraycopy(b2, offset + n3, this.buffer, n, len - n3);
        }
    }

    @Override
    public byte[] digest() {
        byte[] byArray = this.padBuffer();
        this.update(byArray, 0, byArray.length);
        byte[] byArray2 = this.getResult();
        this.reset();
        return byArray2;
    }

    @Override
    public void reset() {
        boolean bl = b;
        this.count = 0L;
        int n = 0;
        while (n < this.blockSize) {
            this.buffer[n++] = 0;
            if (!bl) continue;
        }
        this.resetContext();
    }

    @Override
    public abstract Object clone();

    @Override
    public abstract boolean selfTest();

    protected abstract byte[] padBuffer();

    protected abstract byte[] getResult();

    protected abstract void resetContext();

    protected abstract void transform(byte[] var1, int var2);
}

