/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.derivationFunctions;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.derivationFunctions.DerivationFuncParams;
import gnu.crypto.derivationFunctions.DerivationFuncParamsWithSharedInfo;
import gnu.crypto.derivationFunctions.DerivationFunction;
import gnu.crypto.derivationFunctions.MGF1;
import gnu.crypto.hash.IMessageDigest;

public class X9_63KeyDerivation
implements DerivationFunction {
    private byte[] a;
    private IMessageDigest b;
    private byte[] c;
    private int d;
    private static final String e;

    public X9_63KeyDerivation(IMessageDigest hash) {
        this.b = hash;
    }

    @Override
    public void init(byte[] seed, DerivationFuncParams params) {
        this.a = seed;
        this.d = this.b.hashSize();
        this.c = ((DerivationFuncParamsWithSharedInfo)params).getSharedInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] generateBytes(int len) {
        int n = MGF1.c;
        if ((long)len > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException(e);
        }
        byte[] byArray = new byte[len];
        int n2 = (len + this.d - 1) / this.d;
        int n3 = 1;
        int n4 = 0;
        for (int k = 0; k < n2; ++n3, ++k) {
            this.b.update(this.a, 0, this.a.length);
            this.b.update((byte)(n3 >> 24));
            this.b.update((byte)(n3 >> 16));
            this.b.update((byte)(n3 >> 8));
            this.b.update((byte)n3);
            if (this.c != null) {
                this.b.update(this.c, 0, this.c.length);
            }
            byte[] byArray2 = this.b.digest();
            if (len > this.d) {
                System.arraycopy(byArray2, 0, byArray, n4, this.d);
                n4 += this.d;
                len -= this.d;
                if (n == 0) continue;
            }
            System.arraycopy(byArray2, 0, byArray, n4, len);
            if (n == 0) continue;
        }
        if (BaseCipher.b == 0) return byArray;
        MGF1.c = ++n;
        return byArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                char[] cArray3 = "\u0007\u0017gb\u0018<B\u007fw\u0003/\u0016{2\u0019'\r3~\f:\u0005v".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 72;
                            break;
                        }
                        case 1: {
                            n6 = 98;
                            break;
                        }
                        case 2: {
                            n6 = 19;
                            break;
                        }
                        case 3: {
                            n6 = 18;
                            break;
                        }
                        default: {
                            n6 = 109;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        e = new String(cArray).intern();
    }
}

