/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicy;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicyId;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.asn.algorithms._algorithmsValues;

public class TurkishProfileAttributesChecker
extends BaseChecker {
    private static final int e = 300;
    private boolean f = false;
    private static final String[] g;

    public TurkishProfileAttributesChecker() {
    }

    public TurkishProfileAttributesChecker(boolean aSign) {
        this.f = aSign;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        Object object;
        DigestAlg digestAlg;
        Logger logger = LoggerFactory.getLogger(TurkishProfileAttributesChecker.class);
        aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.TURKISH_PROFILE_ATTRIBUTES_CHECKER, new String[0]), TurkishProfileAttributesChecker.class);
        if (aSigner.isTurkishProfile()) {
            digestAlg = this.b(aSigner);
            if (digestAlg == null || digestAlg.getOID() != _algorithmsValues.id_sha256) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.PROFILE_POLICY_HASH_NOT_SHA256, new String[0])));
                aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
                return false;
            }
            List list = aSigner.getSignerInfo().getSignedAttribute(AttributeOIDs.id_signingTime);
            if (list == null || list.size() == 0) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_TIME_ATTRIBUTE_MISSING, new String[0])));
                aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
                return false;
            }
            object = aSigner.getSignerInfo().getSignedAttribute(AttributeOIDs.id_aa_signingCertificateV2);
            if (object == null || object.size() == 0) {
                aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNING_CERTIFICATE_V2_ATTRIBUTE_MISSING, new String[0])));
                aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
                return false;
            }
        }
        if (!aSigner.isTurkishProfile() && !this.getParameters().containsKey(g[1])) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.NOT_A_TURKISH_PROFILE, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
            return true;
        }
        try {
            digestAlg = (TurkishESigProfile)this.getParameters().get(g[2]);
            if (digestAlg == null) {
                digestAlg = aSigner.getSignerInfo().getProfile();
            }
            if (digestAlg != TurkishESigProfile.P1_1 && (!this.f || aSigner.getType() != ESignatureType.TYPE_BES && aSigner.getType() != ESignatureType.TYPE_EPES)) {
                boolean bl = false;
                object = aSigner.getSignerInfo().getSigningTime();
                ((Calendar)object).add(13, -300);
                Calendar calendar = this.a(aSigner);
                if (((Calendar)object).after(calendar)) {
                    bl = true;
                }
                ((Calendar)object).add(13, 7500);
                if (calendar.after(object)) {
                    bl = true;
                }
                if (bl) {
                    aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TS_TIME_NOT_AFTER_2H, new String[0])));
                    aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.SIGNATURE_TIME_ERROR, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.UNSUCCESS);
            logger.warn(g[3], (Throwable)exception);
            return false;
        }
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.TURKISH_PROFILE_ATTRIBUTES_CHECKER_SUCCESSFUL, new String[0])));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        return true;
    }

    private Calendar a(Signer signer) throws ESYAException {
        EAttribute eAttribute = (EAttribute)signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_aa_signatureTimeStampToken).get(0);
        EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
        ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
        ETSTInfo eTSTInfo = new ETSTInfo(eSignedData.getEncapsulatedContentInfo().getContent());
        return eTSTInfo.getTime();
    }

    private DigestAlg b(Signer signer) {
        try {
            ESignaturePolicy eSignaturePolicy = signer.getSignerInfo().getPolicyAttr();
            ESignaturePolicyId eSignaturePolicyId = eSignaturePolicy.getSignaturePolicyId();
            return DigestAlg.fromOID((int[])eSignaturePolicyId.getHashInfo().getHashAlg().getAlgorithm().value);
        }
        catch (Exception exception) {
            this.logger.warn(g[0], (Throwable)exception);
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "<g)A(\u0005a{F/KR.]*\u0002u3\u007f3\u0004`2C$*r/](\ts/J2(n>L*\u000et";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 107;
                                break;
                            }
                            case 1: {
                                n8 = 6;
                                break;
                            }
                            case 2: {
                                n8 = 91;
                                break;
                            }
                            case 3: {
                                n8 = 47;
                                break;
                            }
                            default: {
                                n8 = 65;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = ";Y\rn\r\"B\u001a{\b$H\u0004\u007f\u0013$@\u0012c\u0004";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = ";Y\rn\r\"B\u001a{\b$H\u0004\u007f\u0013$@\u0012c\u0004";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "<g)A(\u0005a{F/KR.]*\u0002u3\u007f3\u0004`2C$*r/](\ts/J2(n>L*\u000et";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        g = stringArray3;
    }
}

