/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1UTCTime;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECompleteRevocationReferences;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ERevocationValues;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.asn.cms.CRLListID;
import tr.gov.tubitak.uekae.esya.asn.cms.CompleteRevocationRefs;
import tr.gov.tubitak.uekae.esya.asn.cms.CrlIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.CrlOcspRef;
import tr.gov.tubitak.uekae.esya.asn.cms.CrlValidatedID;
import tr.gov.tubitak.uekae.esya.asn.cms.OcspIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.OcspListID;
import tr.gov.tubitak.uekae.esya.asn.cms.OcspResponsesID;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherHash;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.asn.cms.RevocationValues;
import tr.gov.tubitak.uekae.esya.asn.ocsp.BasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.ResponderID;
import tr.gov.tubitak.uekae.esya.asn.util.UtilEsitlikler;
import tr.gov.tubitak.uekae.esya.asn.x509.CertificateList;
import tr.gov.tubitak.uekae.esya.asn.x509.Name;

public class RevocationRefsValuesMatchChecker
extends BaseChecker {
    protected static Logger logger;
    private static final String[] e;

    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_REFERENCES_AND_VALUES_MATCH_CHECKER, new String[0]), RevocationRefsValuesMatchChecker.class);
        if (!Boolean.TRUE.equals(this.getParameters().get(e[0]))) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_REFS_VALUES_MATCH_SUCCESSFUL, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
            return true;
        }
        List<EAttribute> list = aSigner.getUnsignedAttribute(AttributeOIDs.id_aa_ets_revocationRefs);
        if (list.isEmpty()) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_REFERENCES_ATTRIBUTE_NOT_FOUND, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.NOTFOUND);
            return false;
        }
        EAttribute eAttribute = list.get(0);
        ECompleteRevocationReferences eCompleteRevocationReferences = null;
        try {
            eCompleteRevocationReferences = new ECompleteRevocationReferences(eAttribute.getValue(0));
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_REFERENCES_ATTRIBUTE_DECODE_ERROR, new String[0]), exception));
            return false;
        }
        List<EAttribute> list2 = aSigner.getUnsignedAttribute(AttributeOIDs.id_aa_ets_revocationValues);
        if (list2.isEmpty()) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_VALUES_ATTRIBUTE_NOT_FOUND, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.NOTFOUND);
            return false;
        }
        EAttribute eAttribute2 = list2.get(0);
        ERevocationValues eRevocationValues = null;
        try {
            eRevocationValues = new ERevocationValues(eAttribute2.getValue(0));
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_VALUES_DECODE_ERROR, new String[0]), exception));
            return false;
        }
        if (eCompleteRevocationReferences.getRefCount() != eRevocationValues.getBasicOCSPResponseCount() + eRevocationValues.getCRLCount()) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_REFS_VALUES_MATCH_UNSUCCESSFUL, new String[0])));
            return false;
        }
        if (!this.a(eCompleteRevocationReferences, eRevocationValues)) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_REFS_VALUES_MATCH_UNSUCCESSFUL, new String[0])));
            return false;
        }
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.REVOCATION_REFS_VALUES_MATCH_SUCCESSFUL, new String[0])));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        return true;
    }

    private boolean a(ECompleteRevocationReferences eCompleteRevocationReferences, ERevocationValues eRevocationValues) {
        boolean bl;
        block17: {
            block16: {
                int n = CheckerResult.h;
                CrlOcspRef[] crlOcspRefArray = ((CompleteRevocationRefs)eCompleteRevocationReferences.getObject()).elements;
                ArrayList<CRLListID> arrayList = new ArrayList<CRLListID>();
                ArrayList<OcspListID> arrayList2 = new ArrayList<OcspListID>();
                for (CrlOcspRef crlOcspRef : crlOcspRefArray) {
                    block15: {
                        if (crlOcspRef.crlids == null || crlOcspRef.crlids.crls.elements.length == 0) break block15;
                        arrayList.add(crlOcspRef.crlids);
                    }
                    if (crlOcspRef.ocspids == null || crlOcspRef.ocspids.ocspResponses.elements.length == 0) continue;
                    arrayList2.add(crlOcspRef.ocspids);
                }
                boolean bl2 = true;
                if (((RevocationValues)eRevocationValues.getObject()).crlVals != null) {
                    CertificateList[] certificateListArray = ((RevocationValues)eRevocationValues.getObject()).crlVals.elements;
                    bl2 = this.a(arrayList, certificateListArray);
                }
                int n2 = 1;
                if (((RevocationValues)eRevocationValues.getObject()).ocspVals != null) {
                    BasicOCSPResponse[] basicOCSPResponseArray = ((RevocationValues)eRevocationValues.getObject()).ocspVals.elements;
                    n2 = this.a(arrayList2, basicOCSPResponseArray) ? 1 : 0;
                }
                if (!bl2 || n2 == 0) break block16;
                bl = true;
                break block17;
            }
            bl = false;
        }
        return bl;
    }

    private boolean a(ArrayList<CRLListID> arrayList, CertificateList[] certificateListArray) {
        int n = CheckerResult.h;
        for (CRLListID cRLListID : arrayList) {
            CrlValidatedID[] crlValidatedIDArray;
            for (CrlValidatedID crlValidatedID : crlValidatedIDArray = cRLListID.crls.elements) {
                OtherHash otherHash = crlValidatedID.crlHash;
                CrlIdentifier crlIdentifier = crlValidatedID.crlIdentifier;
                try {
                    if (this.a(otherHash, crlIdentifier, certificateListArray)) continue;
                    return false;
                }
                catch (Exception exception) {
                    logger.warn(e[2], (Throwable)exception);
                    return false;
                }
            }
            if (n == 0) continue;
        }
        return true;
    }

    private boolean a(ArrayList<OcspListID> arrayList, BasicOCSPResponse[] basicOCSPResponseArray) {
        int n = CheckerResult.h;
        for (OcspListID ocspListID : arrayList) {
            OcspResponsesID[] ocspResponsesIDArray;
            for (OcspResponsesID ocspResponsesID : ocspResponsesIDArray = ocspListID.ocspResponses.elements) {
                OtherHash otherHash = ocspResponsesID.ocspRepHash;
                OcspIdentifier ocspIdentifier = ocspResponsesID.ocspIdentifier;
                try {
                    if (this.a(otherHash, ocspIdentifier, basicOCSPResponseArray)) continue;
                    return false;
                }
                catch (Exception exception) {
                    logger.warn(e[1], (Throwable)exception);
                    return false;
                }
            }
            if (n == 0) continue;
        }
        return true;
    }

    private boolean a(OtherHash otherHash, CrlIdentifier crlIdentifier, CertificateList[] certificateListArray) throws ESYAException {
        Object object;
        int n = CheckerResult.h;
        Asn1OctetString asn1OctetString = null;
        DigestAlg digestAlg = null;
        if (otherHash.getChoiceID() == 1) {
            asn1OctetString = (Asn1OctetString)otherHash.getElement();
            digestAlg = DigestAlg.SHA1;
        } else {
            object = (OtherHashAlgAndValue)otherHash.getElement();
            digestAlg = DigestAlg.fromOID((int[])((OtherHashAlgAndValue)object).hashAlgorithm.algorithm.value);
            asn1OctetString = ((OtherHashAlgAndValue)object).hashValue;
        }
        object = null;
        Name name = null;
        BigInteger bigInteger = null;
        if (crlIdentifier != null) {
            object = crlIdentifier.crlIssuedTime.value;
            name = crlIdentifier.crlissuer;
            if (crlIdentifier.crlNumber != null) {
                bigInteger = crlIdentifier.crlNumber.value;
            }
        }
        for (int i = 0; i < certificateListArray.length; ++i) {
            Object object2;
            Object object3;
            if (crlIdentifier != null) {
                object3 = ((Asn1UTCTime)certificateListArray[i].tbsCertList.thisUpdate.getElement()).value;
                if (!((String)object).equals(object3)) {
                    continue;
                }
                object2 = certificateListArray[i].tbsCertList.issuer;
                if (!UtilEsitlikler.esitMi((Asn1Type)name, (Asn1Type)object2)) {
                    continue;
                }
                if (bigInteger != null) {
                    BigInteger bigInteger2 = new ECRL(certificateListArray[i]).getCRLNumber();
                    if (bigInteger2 == null || !bigInteger.equals(bigInteger2)) {
                        continue;
                    }
                }
            }
            object3 = this.a(certificateListArray[i]);
            object2 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])object3);
            if (!Arrays.equals(asn1OctetString.value, object2)) continue;
            return true;
        }
        return false;
    }

    private boolean a(OtherHash otherHash, OcspIdentifier ocspIdentifier, BasicOCSPResponse[] basicOCSPResponseArray) throws ESYAException {
        Object object;
        int n = CheckerResult.h;
        Asn1OctetString asn1OctetString = null;
        DigestAlg digestAlg = null;
        if (otherHash.getChoiceID() == 1) {
            asn1OctetString = (Asn1OctetString)otherHash.getElement();
            digestAlg = DigestAlg.SHA1;
        } else {
            object = (OtherHashAlgAndValue)otherHash.getElement();
            digestAlg = DigestAlg.fromOID((int[])object.hashAlgorithm.algorithm.value);
            asn1OctetString = object.hashValue;
        }
        object = ocspIdentifier.producedAt.value;
        ResponderID responderID = ocspIdentifier.ocspResponderID;
        for (int i = 0; i < basicOCSPResponseArray.length; ++i) {
            String string = basicOCSPResponseArray[i].tbsResponseData.producedAt.value;
            if (!string.equals(object)) {
                continue;
            }
            ResponderID responderID2 = basicOCSPResponseArray[i].tbsResponseData.responderID;
            if (!UtilEsitlikler.esitMi((Asn1Type)responderID, (Asn1Type)responderID2)) {
                continue;
            }
            byte[] byArray = this.a(basicOCSPResponseArray[i]);
            byte[] byArray2 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray);
            if (!Arrays.equals(asn1OctetString.value, byArray2)) continue;
            return true;
        }
        return false;
    }

    private byte[] a(CertificateList certificateList) throws Asn1Exception {
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        certificateList.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    private byte[] a(BasicOCSPResponse basicOCSPResponse) throws Asn1Exception {
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        basicOCSPResponse.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "C-\u0013NYP7\nR_A;\u0016UTA7\u0013DYV<\u0016DTF!\u0010";
        int n2 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block14;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 19;
                                break;
                            }
                            case 1: {
                                n8 = 114;
                                break;
                            }
                            case 2: {
                                n8 = 85;
                                break;
                            }
                            case 3: {
                                n8 = 1;
                                break;
                            }
                            default: {
                                n8 = 11;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "D\u0013'ob}\u0015uhe3 0wdp\u0013!hd} 0gxE\u00139tn`?4uh{1=dhx\u0017'";
                    n2 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "D\u0013'ob}\u0015uhe3 0wdp\u0013!hd} 0gxE\u00139tn`?4uh{1=dhx\u0017'";
                    n2 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
        logger = LoggerFactory.getLogger(RevocationRefsValuesMatchChecker.class);
    }
}

