/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check;

import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1OctetString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECertificateValues;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECompleteCertificateReferences;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.asn.cms.CertificateValues;
import tr.gov.tubitak.uekae.esya.asn.cms.CompleteCertificateRefs;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherCertID;
import tr.gov.tubitak.uekae.esya.asn.cms.OtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;

public class CertificateRefsValuesMatchChecker
extends BaseChecker {
    protected static Logger logger;
    private HashMap<Integer, HashMap<DigestAlg, byte[]>> e = new HashMap();
    private HashMap<Integer, byte[]> f = new HashMap();
    private static final String[] g;

    @Override
    protected boolean _check(Signer aSigner, CheckerResult aCheckerResult) {
        aCheckerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.CERTIFICATE_REFERENCES_VALUES_MATCH_CHECKER, new String[0]), CertificateRefsValuesMatchChecker.class);
        if (!Boolean.TRUE.equals(this.getParameters().get(g[0]))) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CertificateRefsValuesMatchChecker_SUCCESSFUL, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
            return true;
        }
        List<EAttribute> list = aSigner.getUnsignedAttribute(AttributeOIDs.id_aa_ets_certificateRefs);
        if (list.isEmpty()) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.NO_COMPLETE_CERTIFICATE_REFERENCES_IN_SIGNEDDATA, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.NOTFOUND);
            return false;
        }
        EAttribute eAttribute = list.get(0);
        ECompleteCertificateReferences eCompleteCertificateReferences = null;
        try {
            eCompleteCertificateReferences = new ECompleteCertificateReferences(eAttribute.getValue(0));
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.COMPLETE_CERTIFICATE_REFERENCES_DECODE_ERROR, new String[0]), exception));
            return false;
        }
        List<EAttribute> list2 = aSigner.getUnsignedAttribute(AttributeOIDs.id_aa_ets_certValues);
        if (list2.isEmpty()) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.NO_CERTIFICATE_VALUES_ATTRIBUTE_IN_SIGNEDDATA, new String[0])));
            aCheckerResult.setResultStatus(Types.CheckerResult_Status.NOTFOUND);
            return false;
        }
        EAttribute eAttribute2 = list2.get(0);
        ECertificateValues eCertificateValues = null;
        try {
            eCertificateValues = new ECertificateValues(eAttribute2.getValue(0));
        }
        catch (Exception exception) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CERTIFICATE_VALUES_ATTRIBUTE_DECODE_ERROR, new String[0]), exception));
            return false;
        }
        boolean bl = this.a(eCompleteCertificateReferences, eCertificateValues);
        if (!bl) {
            aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CertificateRefsValuesMatchChecker_UNSUCCESSFUL, new String[0])));
            return false;
        }
        aCheckerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.CertificateRefsValuesMatchChecker_SUCCESSFUL, new String[0])));
        aCheckerResult.setResultStatus(Types.CheckerResult_Status.SUCCESS);
        return true;
    }

    private boolean a(ECompleteCertificateReferences eCompleteCertificateReferences, ECertificateValues eCertificateValues) {
        int n = CheckerResult.h;
        OtherCertID[] otherCertIDArray = ((CompleteCertificateRefs)eCompleteCertificateReferences.getObject()).elements;
        Certificate[] certificateArray = ((CertificateValues)eCertificateValues.getObject()).elements;
        if (otherCertIDArray.length != certificateArray.length) {
            return false;
        }
        for (OtherCertID otherCertID : otherCertIDArray) {
            try {
                if (this.a(otherCertID, certificateArray)) continue;
                return false;
            }
            catch (Exception exception) {
                logger.warn(g[1], (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    private boolean a(OtherCertID otherCertID, Certificate[] certificateArray) throws ESYAException {
        int n = CheckerResult.h;
        Asn1OctetString asn1OctetString = null;
        DigestAlg digestAlg = null;
        if (otherCertID.otherCertHash.getChoiceID() == 1) {
            asn1OctetString = (Asn1OctetString)otherCertID.otherCertHash.getElement();
            digestAlg = DigestAlg.SHA1;
        } else {
            OtherHashAlgAndValue otherHashAlgAndValue = (OtherHashAlgAndValue)otherCertID.otherCertHash.getElement();
            digestAlg = DigestAlg.fromOID((int[])otherHashAlgAndValue.hashAlgorithm.algorithm.value);
            asn1OctetString = otherHashAlgAndValue.hashValue;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            byte[] byArray;
            HashMap<DigestAlg, byte[]> hashMap;
            byte[] byArray2 = this.f.get(i);
            if (byArray2 == null) {
                byArray2 = this.a(certificateArray[i]);
                this.f.put(i, byArray2);
            }
            if ((hashMap = this.e.get(i)) == null) {
                byArray = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray2);
                HashMap<DigestAlg, byte[]> hashMap2 = new HashMap<DigestAlg, byte[]>();
                hashMap2.put(digestAlg, byArray);
                this.e.put(i, hashMap2);
                if (Arrays.equals(asn1OctetString.value, byArray)) {
                    return true;
                }
                if (n == 0) continue;
            }
            if ((byArray = hashMap.get(digestAlg)) == null) {
                byArray = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray2);
                hashMap.put(digestAlg, byArray);
                if (!Arrays.equals(asn1OctetString.value, byArray)) continue;
                return true;
            }
            if (!Arrays.equals(asn1OctetString.value, byArray)) continue;
            return true;
        }
        return false;
    }

    private byte[] a(Certificate certificate) throws Asn1Exception {
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        certificate.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        return asn1DerEncodeBuffer.getMsgCopy();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "i\u0010\u0014B@z\n\r^Fk\u0006\u0011YMk\n\u0014H@|\u0001\u0011HMl\u001c\u0017";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 57;
                                break;
                            }
                            case 1: {
                                n8 = 79;
                                break;
                            }
                            case 2: {
                                n8 = 82;
                                break;
                            }
                            case 3: {
                                n8 = 13;
                                break;
                            }
                            default: {
                                n8 = 18;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "n. c{W(rd|\u0019\f7\u007ffP);nsM*\u0000htJ\u00193ag\\<\u001flfZ'\u0011ewZ$7\u007f";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        g = stringArray3;
        logger = LoggerFactory.getLogger(CertificateRefsValuesMatchChecker.class);
    }
}

